/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import org.eclipse.ajdt.internal.core.exports.FeatureExportOperation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AJFeatureExportJob
extends Job {
    protected FeatureExportInfo fInfo;
    protected FeatureExportOperation op;

    public AJFeatureExportJob(FeatureExportInfo info) {
        super(PDEUIMessages.FeatureExportJob_name);
        this.fInfo = info;
        this.setRule(new SchedulingRule());
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.op = this.getOperation();
        return this.op.run(monitor);
    }

    protected FeatureExportOperation getOperation() {
        if (this.op == null) {
            this.op = new FeatureExportOperation(this.fInfo, PDEUIMessages.FeatureExportJob_name);
        }
        return this.op;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void asyncNotifyExportException(String errorMessage) {
        AJFeatureExportJob.getStandardDisplay().beep();
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)"Export feature error", (String)errorMessage);
        this.done((IStatus)new Status(0, PDEPlugin.getPluginId(), 0, "", null));
    }

    protected String getLogFoundMessage() {
        return NLS.bind((String)"Export feature error", (Object)this.fInfo.destinationDirectory);
    }

    class SchedulingRule
    implements ISchedulingRule {
        SchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof SchedulingRule || rule instanceof IResource;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof SchedulingRule;
        }
    }
}

