/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.javaelements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.internal.core.AJWorkingCopyOwner;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.OpenableElementInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AJCompilationUnitManager {
    public static final AJCompilationUnitManager INSTANCE;
    private HashMap compilationUnitStore = new HashMap();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;

    static {
        Factory factory = new Factory("AJCompilationUnitManager.java", Class.forName("org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 179);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "removeFileFromModel", "org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager", "org.eclipse.core.resources.IFile:", "file:", "", "void"), 165);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 195);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "createCU", "org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager", "org.eclipse.core.resources.IFile:", "file:", "", "org.eclipse.ajdt.core.javaelements.AJCompilationUnit"), 185);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 269);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "addProjectToList", "org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager", "org.eclipse.core.resources.IProject:java.util.List:", "project:l:", "", "void"), 253);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 292);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "addAllAJFilesInFolder", "org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager", "org.eclipse.core.resources.IContainer:java.util.List:", "folder:l:", "", "void"), 278);
        INSTANCE = new AJCompilationUnitManager();
    }

    public AJCompilationUnit getAJCompilationUnit(IFile file) {
        AJCompilationUnit unit = this.getAJCompilationUnitFromCache(file);
        if (unit != null) {
            return unit;
        }
        if (this.creatingCUisAllowedFor(file)) {
            unit = this.createCU(file);
        }
        return unit;
    }

    public AJCompilationUnit getAJCompilationUnitFromCache(IFile file) {
        return (AJCompilationUnit)this.compilationUnitStore.get(file);
    }

    public static ICompilationUnit mapToAJCompilationUnit(ICompilationUnit cu) {
        AJCompilationUnit ajcu;
        if (AspectJPlugin.USING_CU_PROVIDER) {
            return cu;
        }
        if (cu == null) {
            return cu;
        }
        IResource res = cu.getResource();
        if (res.getType() == 1 && (ajcu = INSTANCE.getAJCompilationUnit((IFile)res)) != null) {
            return ajcu;
        }
        return cu;
    }

    public static WorkingCopyOwner defaultAJWorkingCopyOwner() {
        return AJWorkingCopyOwner.INSTANCE;
    }

    public boolean ensureUnitIsInModel(AJCompilationUnit unit) throws JavaModelException {
        OpenableElementInfo info = (OpenableElementInfo)((JavaElement)unit.getParent()).getElementInfo();
        IJavaElement[] elems = info.getChildren();
        int i = 0;
        while (i < elems.length) {
            IJavaElement element = elems[i];
            if (element == unit) {
                return true;
            }
            ++i;
        }
        info.addChild((IJavaElement)unit);
        return false;
    }

    public List getAJCompilationUnitsForPackage(IPackageFragment pFragment) throws CoreException, JavaModelException {
        final ArrayList ajcus = new ArrayList();
        final IResource folder = pFragment.getCorrespondingResource();
        if (folder != null) {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (resource instanceof IFile && CoreUtils.ASPECTJ_SOURCE_ONLY_FILTER.accept(resource.getName())) {
                        ajcus.add(AJCompilationUnitManager.this.getAJCompilationUnit((IFile)resource));
                    }
                    return resource.equals((Object)folder);
                }
            });
        }
        return ajcus;
    }

    public List getAJCompilationUnits(IJavaProject jp) throws CoreException {
        final ArrayList ajcus = new ArrayList();
        jp.getProject().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) {
                AJCompilationUnit ajcu;
                if (resource instanceof IFile && "aj".equals(resource.getFileExtension()) && (ajcu = AJCompilationUnitManager.this.getAJCompilationUnit((IFile)resource)) != null) {
                    ajcus.add(ajcu);
                }
                return resource.getType() == 2 || resource.getType() == 4;
            }
        });
        return ajcus;
    }

    public List getAJCompilationUnits(IPackageFragmentRoot root) throws CoreException {
        final ArrayList ajcus = new ArrayList();
        root.getResource().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) {
                AJCompilationUnit ajcu;
                if (resource instanceof IFile && "aj".equals(resource.getFileExtension()) && (ajcu = AJCompilationUnitManager.this.getAJCompilationUnit((IFile)resource)) != null) {
                    ajcus.add(ajcu);
                }
                return resource.getType() == 2 || resource.getType() == 4;
            }
        });
        return ajcus;
    }

    public void removeFileFromModel(IFile file) {
        AJCompilationUnit unit = (AJCompilationUnit)this.compilationUnitStore.get(file);
        if (unit != null) {
            try {
                if (file.getProject().isOpen()) {
                    OpenableElementInfo info = (OpenableElementInfo)((JavaElement)unit.getParent()).getElementInfo();
                    info.removeChild((IJavaElement)unit);
                }
                JavaModelManager.getJavaModelManager().removeInfoAndChildren((JavaElement)unit);
            }
            catch (JavaModelException javaModelException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
            this.compilationUnitStore.remove(file);
        }
    }

    private AJCompilationUnit createCU(IFile file) {
        AJCompilationUnit unit = new AJCompilationUnit(file);
        try {
            OpenableElementInfo info = (OpenableElementInfo)((JavaElement)unit.getParent()).getElementInfo();
            info.removeChild((IJavaElement)unit);
            info.addChild((IJavaElement)unit);
            this.compilationUnitStore.put(file, unit);
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        return unit;
    }

    private boolean creatingCUisAllowedFor(IFile file) {
        return file != null && CoreUtils.ASPECTJ_SOURCE_ONLY_FILTER.accept(file.getName()) && AspectJPlugin.isAJProject(file.getProject()) && JavaCore.create((IProject)file.getProject()).isOnClasspath((IResource)file);
    }

    public void initCompilationUnits(IProject project) {
        ArrayList l = new ArrayList(30);
        this.addProjectToList(project, l);
        for (IFile ajfile : l) {
            this.createCU(ajfile);
        }
    }

    public List removeCUsfromJavaModel(IProject project) {
        ArrayList l = new ArrayList(30);
        this.addProjectToList(project, l);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            this.removeFileFromModel((IFile)iter.next());
        }
        return l;
    }

    public void initCompilationUnits(IWorkspace workspace) {
        ArrayList l = new ArrayList(20);
        IProject[] projects = workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            this.addProjectToList(project, l);
            for (IFile f : l) {
                this.createCU(f);
            }
            l.clear();
            ++i;
        }
    }

    public List<AJCompilationUnit> getCachedCUs(IProject project) {
        ArrayList<AJCompilationUnit> ajList = new ArrayList<AJCompilationUnit>();
        for (IFile f : this.compilationUnitStore.keySet()) {
            if (!f.getProject().equals((Object)project)) continue;
            ajList.add((AJCompilationUnit)this.compilationUnitStore.get(f));
        }
        return ajList;
    }

    private void addProjectToList(IProject project, List l) {
        if (AspectJPlugin.isAJProject(project)) {
            try {
                IJavaProject jp = JavaCore.create((IProject)project);
                IClasspathEntry[] cpes = jp.getRawClasspath();
                int i = 0;
                while (i < cpes.length) {
                    IClasspathEntry entry = cpes[i];
                    if (entry.getEntryKind() == 3) {
                        IPath p = entry.getPath();
                        if (p.segmentCount() == 1) {
                            this.addAllAJFilesInFolder((IContainer)project, l);
                        } else {
                            this.addAllAJFilesInFolder((IContainer)project.getFolder(p.removeFirstSegments(1)), l);
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
            }
        }
    }

    private void addAllAJFilesInFolder(IContainer folder, List l) {
        if (folder == null || !folder.exists()) {
            return;
        }
        try {
            IResource[] children = folder.members();
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource.getType() == 2) {
                    this.addAllAJFilesInFolder((IContainer)((IFolder)resource), l);
                } else if (resource.getType() == 1 && CoreUtils.ASPECTJ_SOURCE_ONLY_FILTER.accept(resource.getName())) {
                    l.add(resource);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
        }
    }

    public void clearCache() {
        this.compilationUnitStore.clear();
    }
}

