/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.corext.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.dialogs.AJOpenType;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIException;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class History {
    private static final String DEFAULT_ROOT_NODE_NAME = "histroyRootNode";
    private static final String DEFAULT_INFO_NODE_NAME = "infoNode";
    private static final int MAX_HISTORY_SIZE = 60;
    private final Map fHistory = new LinkedHashMap(80, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 60;
        }
    };
    private final Hashtable fPositions;
    private final String fFileName;
    private final String fRootNodeName;
    private final String fInfoNodeName;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;

    private static JavaUIException createException(Throwable t, String message) {
        return new JavaUIException(JavaUIStatus.createError((int)4, (String)message, (Throwable)t));
    }

    public History(String fileName, String rootNodeName, String infoNodeName) {
        this.fFileName = fileName;
        this.fRootNodeName = rootNodeName;
        this.fInfoNodeName = infoNodeName;
        this.fPositions = new Hashtable(60);
    }

    public History(String fileName) {
        this(fileName, DEFAULT_ROOT_NODE_NAME, DEFAULT_INFO_NODE_NAME);
    }

    public synchronized void accessed(Object object) {
        this.fHistory.put(this.getKey(object), object);
        this.rebuildPositions();
    }

    public synchronized boolean contains(Object object) {
        return this.fHistory.containsKey(this.getKey(object));
    }

    public synchronized boolean containsKey(Object key) {
        return this.fHistory.containsKey(key);
    }

    public synchronized boolean isEmpty() {
        return this.fHistory.isEmpty();
    }

    public synchronized Object remove(Object object) {
        Object removed = this.fHistory.remove(this.getKey(object));
        this.rebuildPositions();
        return removed;
    }

    public synchronized Object removeKey(Object key) {
        Object removed = this.fHistory.remove(key);
        this.rebuildPositions();
        return removed;
    }

    public synchronized float getNormalizedPosition(Object key) {
        if (!this.containsKey(key)) {
            return 0.0f;
        }
        int pos = (Integer)this.fPositions.get(key) + 1;
        return (float)pos / (float)this.fHistory.size();
    }

    public synchronized int getPosition(Object key) {
        if (!this.containsKey(key)) {
            return -1;
        }
        return (Integer)this.fPositions.get(key);
    }

    public synchronized void load() {
        block19: {
            JavaPlugin javaPlugin = JavaPlugin.getDefault();
            IPath stateLocation = History.getStateLocation_aroundBody1$advice(this, javaPlugin, AJOpenType.aspectOf(), null).append(this.fFileName);
            File file = new File(stateLocation.toOSString());
            if (file.exists()) {
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                    this.load(new InputSource(reader));
                }
                catch (IOException iOException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    IOException e = iOException;
                    JavaPlugin.log((Throwable)e);
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException2) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException2, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                        IOException e2 = iOException2;
                        JavaPlugin.log((Throwable)e2);
                    }
                    break block19;
                }
                catch (CoreException coreException) {
                    try {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_1);
                        CoreException e = coreException;
                        JavaPlugin.log((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_1);
                            IOException e = iOException;
                            JavaPlugin.log((Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_1);
                        IOException e = iOException;
                        JavaPlugin.log((Throwable)e);
                    }
                    break block19;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_1);
                    IOException e = iOException;
                    JavaPlugin.log((Throwable)e);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void save() {
        block23: {
            JavaPlugin javaPlugin = JavaPlugin.getDefault();
            IPath stateLocation = History.getStateLocation_aroundBody3$advice(this, javaPlugin, AJOpenType.aspectOf(), null).append(this.fFileName);
            File file = new File(stateLocation.toOSString());
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                this.save(out);
            }
            catch (IOException iOException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_7, (JoinPoint.StaticPart)ajc$tjp_8);
                IOException e = iOException;
                JavaPlugin.log((Throwable)e);
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    break block23;
                }
                catch (IOException iOException2) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException2, this, ajc$tjp_9, (JoinPoint.StaticPart)ajc$tjp_8);
                    IOException e2 = iOException2;
                    JavaPlugin.log((Throwable)e2);
                }
                break block23;
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_10, (JoinPoint.StaticPart)ajc$tjp_8);
                CoreException e = coreException;
                JavaPlugin.log((Throwable)e);
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    break block23;
                }
                catch (IOException iOException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_11, (JoinPoint.StaticPart)ajc$tjp_8);
                    IOException e3 = iOException;
                    JavaPlugin.log((Throwable)e3);
                }
                break block23;
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(transformerFactoryConfigurationError, this, ajc$tjp_12, (JoinPoint.StaticPart)ajc$tjp_8);
                TransformerFactoryConfigurationError e = transformerFactoryConfigurationError;
                JavaPlugin.log((Throwable)e);
                {
                    catch (Throwable throwable) {
                        try {
                            if (out != null) {
                                ((OutputStream)out).close();
                            }
                        }
                        catch (IOException iOException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_14, (JoinPoint.StaticPart)ajc$tjp_8);
                            IOException e4 = iOException;
                            JavaPlugin.log((Throwable)e4);
                        }
                        throw throwable;
                    }
                }
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    break block23;
                }
                catch (IOException iOException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_13, (JoinPoint.StaticPart)ajc$tjp_8);
                    IOException e5 = iOException;
                    JavaPlugin.log((Throwable)e5);
                }
                break block23;
            }
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_15, (JoinPoint.StaticPart)ajc$tjp_8);
                IOException e = iOException;
                JavaPlugin.log((Throwable)e);
            }
        }
    }

    protected Set getKeys() {
        return this.fHistory.keySet();
    }

    protected Collection getValues() {
        return this.fHistory.values();
    }

    protected abstract void setAttributes(Object var1, Element var2);

    protected abstract Object createFromElement(Element var1);

    protected abstract Object getKey(Object var1);

    private void rebuildPositions() {
        this.fPositions.clear();
        Collection values = this.fHistory.values();
        int pos = 0;
        for (Object element : values) {
            this.fPositions.put(this.getKey(element), new Integer(pos));
            ++pos;
        }
    }

    private void load(InputSource inputSource) throws CoreException {
        Element root;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            root = parser.parse(inputSource).getDocumentElement();
        }
        catch (SAXException sAXException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(sAXException, this, ajc$tjp_16, (JoinPoint.StaticPart)ajc$tjp_17);
            SAXException e = sAXException;
            throw History.createException(e, Messages.format((String)CorextMessages.History_error_read, (Object)this.fFileName));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(parserConfigurationException, this, ajc$tjp_18, (JoinPoint.StaticPart)ajc$tjp_17);
            ParserConfigurationException e = parserConfigurationException;
            throw History.createException(e, Messages.format((String)CorextMessages.History_error_read, (Object)this.fFileName));
        }
        catch (IOException iOException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_19, (JoinPoint.StaticPart)ajc$tjp_17);
            IOException e = iOException;
            throw History.createException(e, Messages.format((String)CorextMessages.History_error_read, (Object)this.fFileName));
        }
        if (root == null) {
            return;
        }
        if (!root.getNodeName().equalsIgnoreCase(this.fRootNodeName)) {
            return;
        }
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Object object;
            Element type;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (type = (Element)node).getNodeName().equalsIgnoreCase(this.fInfoNodeName) && (object = this.createFromElement(type)) != null) {
                this.fHistory.put(this.getKey(object), object);
            }
            ++i;
        }
        this.rebuildPositions();
    }

    private void save(OutputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(this.fRootNodeName);
            document.appendChild(rootElement);
            for (Object object : this.getValues()) {
                Element element = document.createElement(this.fInfoNodeName);
                this.setAttributes(object, element);
                rootElement.appendChild(element);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }
        catch (TransformerException transformerException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(transformerException, this, ajc$tjp_20, (JoinPoint.StaticPart)ajc$tjp_21);
            TransformerException e = transformerException;
            throw History.createException(e, Messages.format((String)CorextMessages.History_error_serialize, (Object)this.fFileName));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(parserConfigurationException, this, ajc$tjp_22, (JoinPoint.StaticPart)ajc$tjp_21);
            ParserConfigurationException e = parserConfigurationException;
            throw History.createException(e, Messages.format((String)CorextMessages.History_error_serialize, (Object)this.fFileName));
        }
    }

    static {
        Factory factory = new Factory("History.java", Class.forName("org.eclipse.ajdt.internal.corext.util.History"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "java.io.IOException:", "e:"), 163);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("21", "load", "org.eclipse.ajdt.internal.corext.util.History", "", "", "", "void"), 155);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "org.eclipse.core.runtime.CoreException:", "e:"), 187);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "java.io.IOException:", "e:"), 198);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "javax.xml.transform.TransformerFactoryConfigurationError:", "e:"), 189);
        ajc$tjp_13 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "java.io.IOException:", "e:"), 198);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "java.io.IOException:", "e:"), 198);
        ajc$tjp_15 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "java.io.IOException:", "e:"), 198);
        ajc$tjp_16 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "org.xml.sax.SAXException:", "e:"), 251);
        ajc$tjp_17 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "load", "org.eclipse.ajdt.internal.corext.util.History", "org.xml.sax.InputSource:", "inputSource:", "org.eclipse.core.runtime.CoreException:", "void"), 246);
        ajc$tjp_18 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "javax.xml.parsers.ParserConfigurationException:", "e:"), 253);
        ajc$tjp_19 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "java.io.IOException:", "e:"), 255);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "java.io.IOException:", "e:"), 171);
        ajc$tjp_20 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "javax.xml.transform.TransformerException:", "e:"), 305);
        ajc$tjp_21 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "save", "org.eclipse.ajdt.internal.corext.util.History", "java.io.OutputStream:", "stream:", "org.eclipse.core.runtime.CoreException:", "void"), 280);
        ajc$tjp_22 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "javax.xml.parsers.ParserConfigurationException:", "e:"), 307);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "org.eclipse.core.runtime.CoreException:", "e:"), 165);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "java.io.IOException:", "e:"), 171);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "java.io.IOException:", "e:"), 171);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "java.io.IOException:", "e:"), 171);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "java.io.IOException:", "e:"), 185);
        ajc$tjp_8 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("21", "save", "org.eclipse.ajdt.internal.corext.util.History", "", "", "", "void"), 178);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.corext.util.History", "java.io.IOException:", "e:"), 198);
    }

    private static final /* synthetic */ IPath getStateLocation_aroundBody0(History history, JavaPlugin javaPlugin) {
        return javaPlugin.getStateLocation();
    }

    private static final /* synthetic */ IPath getStateLocation_aroundBody1$advice(History ajc$this, JavaPlugin target, AJOpenType ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return AspectJUIPlugin.getDefault().getStateLocation();
    }

    private static final /* synthetic */ IPath getStateLocation_aroundBody2(History history, JavaPlugin javaPlugin) {
        return javaPlugin.getStateLocation();
    }

    private static final /* synthetic */ IPath getStateLocation_aroundBody3$advice(History ajc$this, JavaPlugin target, AJOpenType ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return AspectJUIPlugin.getDefault().getStateLocation();
    }
}

