/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import java.io.File;
import java.net.URI;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJFeatureExportJob;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJFeatureExportWizardPage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.build.RuntimeInstallJob;
import org.eclipse.pde.internal.ui.wizards.exports.AntGeneratingExportWizard;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.CrossPlatformExportPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AJFeatureExportWizard
extends AntGeneratingExportWizard {
    private static final String STORE_SECTION = "FeatureExportWizard";
    private CrossPlatformExportPage fPage2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public AJFeatureExportWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_FEATURE_EXPORT_WIZ);
    }

    public void addPages() {
        super.addPages();
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel model = manager.getDeltaPackFeature();
        if (model != null) {
            this.fPage2 = new CrossPlatformExportPage("environment", model);
            this.addPage((IWizardPage)this.fPage2);
        }
    }

    protected BaseExportWizardPage createPage1() {
        return new AJFeatureExportWizardPage(this.getSelection());
    }

    protected String getSettingsSectionName() {
        return STORE_SECTION;
    }

    protected void scheduleExportJob() {
        boolean installAfterExport;
        final FeatureExportInfo info = new FeatureExportInfo();
        info.toDirectory = ((AJFeatureExportWizardPage)this.fPage).doExportToDirectory();
        info.useJarFormat = ((AJFeatureExportWizardPage)this.fPage).useJARFormat();
        info.exportSource = ((AJFeatureExportWizardPage)this.fPage).doExportSource();
        info.exportSourceBundle = ((AJFeatureExportWizardPage)this.fPage).doExportSourceBundles();
        info.allowBinaryCycles = ((AJFeatureExportWizardPage)this.fPage).allowBinaryCycles();
        info.useWorkspaceCompiledClasses = ((AJFeatureExportWizardPage)this.fPage).useWorkspaceCompiledClasses();
        info.destinationDirectory = ((AJFeatureExportWizardPage)this.fPage).getDestination();
        info.zipFileName = ((AJFeatureExportWizardPage)this.fPage).getFileName();
        if (this.fPage2 != null && ((AJFeatureExportWizardPage)this.fPage).doMultiPlatform()) {
            info.targets = this.fPage2.getTargets();
        }
        info.exportMetadata = ((AJFeatureExportWizardPage)this.fPage).doExportMetadata();
        info.items = ((AJFeatureExportWizardPage)this.fPage).getSelectedItems();
        info.signingInfo = ((AJFeatureExportWizardPage)this.fPage).getSigningInfo();
        info.jnlpInfo = ((AJFeatureExportWizardPage)this.fPage).getJNLPInfo();
        info.qualifier = ((AJFeatureExportWizardPage)this.fPage).getQualifier();
        if (((AJFeatureExportWizardPage)this.fPage).getCategoryDefinition() != null) {
            info.categoryDefinition = URIUtil.toUnencodedString((URI)((AJFeatureExportWizardPage)this.fPage).getCategoryDefinition());
        }
        if (installAfterExport = ((AJFeatureExportWizardPage)this.fPage).doInstall()) {
            info.useJarFormat = true;
            info.exportMetadata = true;
            if (info.qualifier == null) {
                info.qualifier = QualifierReplacer.getDateQualifier();
            }
        }
        final AJFeatureExportJob job = new AJFeatureExportJob(info);
        job.setUser(true);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setProperty(IProgressConstants.ICON_PROPERTY, PDEPluginImages.DESC_FEATURE_OBJ);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (job.getOperation().hasAntErrors()) {
                    final File logLocation = new File(info.destinationDirectory, "logs.zip");
                    if (logLocation.exists()) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                AntGeneratingExportWizard.AntErrorDialog dialog = new AntGeneratingExportWizard.AntErrorDialog((AntGeneratingExportWizard)AJFeatureExportWizard.this, logLocation);
                                dialog.open();
                            }
                        });
                    }
                } else if (event.getResult().isOK() && installAfterExport) {
                    RuntimeInstallJob installJob = new RuntimeInstallJob(PDEUIMessages.PluginExportWizard_InstallJobName, info);
                    installJob.setUser(true);
                    installJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_FEATURE_OBJ);
                    installJob.schedule();
                }
            }
        });
        job.schedule();
    }

    protected Document generateAntTask() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().newDocument();
            Element root = doc.createElement("project");
            root.setAttribute("name", "build");
            root.setAttribute("default", "feature_export");
            doc.appendChild(root);
            Element target = doc.createElement("target");
            target.setAttribute("name", "feature_export");
            root.appendChild(target);
            Element export = doc.createElement("pde.exportFeatures");
            export.setAttribute("features", this.getFeatureIDs());
            export.setAttribute("destination", ((AJFeatureExportWizardPage)this.fPage).getDestination());
            String filename = ((AJFeatureExportWizardPage)this.fPage).getFileName();
            if (filename != null) {
                export.setAttribute("filename", filename);
            }
            export.setAttribute("exportType", this.getExportOperation());
            export.setAttribute("useJARFormat", Boolean.toString(((AJFeatureExportWizardPage)this.fPage).useJARFormat()));
            export.setAttribute("exportSource", Boolean.toString(((AJFeatureExportWizardPage)this.fPage).doExportSource()));
            String qualifier = ((AJFeatureExportWizardPage)this.fPage).getQualifier();
            if (qualifier != null) {
                export.setAttribute("qualifier", qualifier);
            }
            target.appendChild(export);
            return doc;
        }
        catch (DOMException dOMException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(dOMException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(factoryConfigurationError, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(parserConfigurationException, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        return null;
    }

    private String getFeatureIDs() {
        StringBuffer buffer = new StringBuffer();
        Object[] objects = ((AJFeatureExportWizardPage)this.fPage).getSelectedItems();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof IFeatureModel) {
                buffer.append(((IFeatureModel)object).getFeature().getId());
                if (i < objects.length - 1) {
                    buffer.append(",");
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    static {
        Factory factory = new Factory("AJFeatureExportWizard.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.exports.AJFeatureExportWizard"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJFeatureExportWizard", "org.w3c.dom.DOMException:", "<missing>:"), 171);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "generateAntTask", "org.eclipse.ajdt.internal.ui.wizards.exports.AJFeatureExportWizard", "", "", "", "org.w3c.dom.Document"), 144);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJFeatureExportWizard", "javax.xml.parsers.FactoryConfigurationError:", "<missing>:"), 172);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJFeatureExportWizard", "javax.xml.parsers.ParserConfigurationException:", "<missing>:"), 173);
    }
}

