/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.eclipse.equinox.service.weaving.CacheEntry;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.weaving.internal.caching.CacheItem;
import org.eclipse.equinox.weaving.internal.caching.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleCachingService
implements ICachingService {
    private static final int READ_BUFFER_SIZE = 8192;
    private final Bundle bundle;
    private File cacheDirectory;
    private final String cacheKey;
    private final BlockingQueue<CacheItem> cacheWriterQueue;

    public BundleCachingService(BundleContext bundleContext, Bundle bundle, String key, BlockingQueue<CacheItem> cacheWriterQueue) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Argument \"bundleContext\" must not be null!");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Argument \"bundle\" must not be null!");
        }
        if (key == null) {
            throw new IllegalArgumentException("Argument \"key\" must not be null!");
        }
        this.bundle = bundle;
        this.cacheKey = this.hashNamespace(key);
        this.cacheWriterQueue = cacheWriterQueue;
        File dataFile = bundleContext.getDataFile(this.cacheKey);
        if (dataFile != null) {
            String bundleCacheDir = String.valueOf(bundle.getBundleId()) + "-" + bundle.getLastModified();
            this.cacheDirectory = new File(dataFile, bundleCacheDir);
        } else {
            Log.error("Cannot initialize cache!", null);
        }
    }

    public boolean canCacheGeneratedClasses() {
        return true;
    }

    public CacheEntry findStoredClass(String namespace, URL sourceFileURL, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument \"name\" must not be null!");
        }
        byte[] storedClass = null;
        boolean isCached = false;
        if (this.cacheDirectory != null) {
            File cachedBytecodeFile = new File(this.cacheDirectory, name);
            storedClass = this.read(name, cachedBytecodeFile);
            boolean bl = isCached = storedClass != null;
        }
        if (Log.isDebugEnabled()) {
            Log.debug(MessageFormat.format("for [{0}]: {1} {2}", this.bundle.getSymbolicName(), storedClass != null ? "Found" : "Found NOT", name));
        }
        return new CacheEntry(isCached, storedClass);
    }

    public void stop() {
    }

    public boolean storeClass(String namespace, URL sourceFileURL, Class<?> clazz, byte[] classbytes) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument \"clazz\" must not be null!");
        }
        if (classbytes == null) {
            throw new IllegalArgumentException("Argument \"classbytes\" must not be null!");
        }
        if (this.cacheDirectory == null) {
            return false;
        }
        CacheItem item = new CacheItem(classbytes, this.cacheDirectory.getAbsolutePath(), clazz.getName());
        return this.cacheWriterQueue.offer(item);
    }

    public boolean storeClassAndGeneratedClasses(String namespace, URL sourceFileUrl, Class<?> clazz, byte[] classbytes, Map<String, byte[]> generatedClasses) {
        CacheItem item = new CacheItem(classbytes, this.cacheDirectory.getAbsolutePath(), clazz.getName(), generatedClasses);
        return this.cacheWriterQueue.offer(item);
    }

    private String hashNamespace(String namespace) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] bytes = md.digest(namespace.getBytes());
        StringBuffer result = new StringBuffer();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            int b = byArray[n2];
            int num = b < 0 ? b + 256 : b;
            String s = Integer.toHexString(num);
            while (s.length() < 2) {
                s = "0" + s;
            }
            result.append(s);
            ++n2;
        }
        return new String(result);
    }

    /*
     * Loose catch block
     */
    private byte[] read(String name, File file) {
        byte[] byArray;
        InputStream in;
        block20: {
            byte[] oldbytes;
            int length = (int)file.length();
            in = null;
            byte[] classbytes = new byte[length];
            int bytesread = 0;
            in = new FileInputStream(file);
            if (length > 0) {
                classbytes = new byte[length];
                while (bytesread < length) {
                    int readcount = in.read(classbytes, bytesread, length - bytesread);
                    if (readcount > 0) {
                        bytesread += readcount;
                        continue;
                    }
                    break;
                }
            } else {
                length = 8192;
                classbytes = new byte[length];
                while (true) {
                    if (bytesread < length) {
                        int readcount = in.read(classbytes, bytesread, length - bytesread);
                        if (readcount > 0) {
                            bytesread += readcount;
                            continue;
                        }
                        break;
                    }
                    oldbytes = classbytes;
                    classbytes = new byte[length += 8192];
                    System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
                }
            }
            if (classbytes.length > bytesread) {
                oldbytes = classbytes;
                classbytes = new byte[bytesread];
                System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
            }
            byArray = classbytes;
            if (in == null) break block20;
            try {
                in.close();
            }
            catch (IOException e) {
                Log.error(MessageFormat.format("for [{0}]: Cannot close cache file for [1]!", this.bundle.getSymbolicName(), name), e);
            }
        }
        return byArray;
        catch (IOException iOException) {
            block21: {
                try {
                    Log.debug(MessageFormat.format("for [{0}]: Cannot read [1] from cache!", this.bundle.getSymbolicName(), name));
                    if (in == null) break block21;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            Log.error(MessageFormat.format("for [{0}]: Cannot close cache file for [1]!", this.bundle.getSymbolicName(), name), e);
                        }
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    Log.error(MessageFormat.format("for [{0}]: Cannot close cache file for [1]!", this.bundle.getSymbolicName(), name), e);
                }
            }
            return null;
        }
    }
}

