/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.ajde.core.AjCompiler;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.ajdt.internal.core.builder.IncrementalStateManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IProject;

public final class AJWorldFacade {
    private final AjBuildManager manager;
    private final World world;
    private Map cachedMungers;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;

    public AJWorldFacade(IProject project) {
        AjCompiler compiler = AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(project);
        AjState state = IncrementalStateManager.retrieveStateFor((String)compiler.getId());
        if (state != null) {
            this.manager = state.getAjBuildManager();
            this.world = this.manager.getWorld();
        } else {
            this.manager = null;
            this.world = null;
        }
    }

    private void cacheMunger(char[] typeName, List mungers) {
        if (this.cachedMungers == null) {
            this.cachedMungers = new HashMap();
        }
        this.cachedMungers.put(typeName, mungers);
    }

    public ITDInfo findITDInfoIfExists(char[] targetTypeSignature, char[] name) {
        List itds;
        if (this.world == null || targetTypeSignature == null) {
            return null;
        }
        String nameStr = new String(name);
        if (this.cachedMungers != null && this.cachedMungers.containsKey(targetTypeSignature)) {
            itds = (List)this.cachedMungers.get(targetTypeSignature);
            if (itds == null) {
                return null;
            }
        } else {
            ResolvedType type = null;
            try {
                String sig = this.createSignature(targetTypeSignature);
                type = this.world.getCoreType(UnresolvedType.forSignature((String)sig));
            }
            catch (Exception exception) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                return null;
            }
            if (type == null || type.isMissing()) {
                this.cacheMunger(targetTypeSignature, null);
                return null;
            }
            itds = type.getInterTypeMungersIncludingSupers();
            this.cacheMunger(targetTypeSignature, itds);
        }
        for (ConcreteTypeMunger cMunger : itds) {
            ResolvedTypeMunger munger = cMunger.getMunger();
            if (munger == null) continue;
            if (munger.getKind() == ResolvedTypeMunger.Field && munger.getSignature().getName().equals(nameStr)) {
                return ITDInfo.create(cMunger);
            }
            if (munger.getKind() != ResolvedTypeMunger.Method || !munger.getSignature().getName().equals(nameStr)) continue;
            return ITDInfo.create(cMunger);
        }
        return null;
    }

    private String createSignature(char[] targetTypeSignature) {
        char[] copy = new char[targetTypeSignature.length];
        System.arraycopy(targetTypeSignature, 0, copy, 0, copy.length);
        boolean isGeneric = false;
        int i = 0;
        while (i < copy.length) {
            if (copy[i] == '<') {
                isGeneric = true;
            }
            ++i;
        }
        if (isGeneric) {
            copy[0] = 80;
        }
        String sig = new String(copy);
        sig = sig.replace('.', '/');
        return sig;
    }

    public ErasedTypeSignature getTypeParameters(String typeSignature, IProgramElement elt) {
        if (this.world == null) {
            return null;
        }
        ResolvedType type = this.world.resolve(UnresolvedType.forSignature((String)typeSignature));
        if (type == null || type.isMissing()) {
            return null;
        }
        List itds = type.getInterTypeMungersIncludingSupers();
        ConcreteTypeMunger myMunger = null;
        for (ConcreteTypeMunger munger : itds) {
            if (!this.equalSignatures(elt, munger)) continue;
            myMunger = munger;
            break;
        }
        if (myMunger == null) {
            return null;
        }
        String returnType = myMunger.getSignature().getReturnType().getErasureSignature();
        returnType = returnType.replaceAll("/", "\\.");
        returnType = org.eclipse.jdt.core.Signature.toString((String)returnType);
        UnresolvedType[] parameterTypes = myMunger.getSignature().getParameterTypes();
        String[] parameterTypesStr = new String[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypesStr[i] = parameterTypes[i].getErasureSignature();
            parameterTypesStr[i] = parameterTypesStr[i].replaceAll("/", "\\.");
            parameterTypesStr[i] = org.eclipse.jdt.core.Signature.toString((String)parameterTypesStr[i]);
            ++i;
        }
        return new ErasedTypeSignature(returnType, parameterTypesStr);
    }

    private boolean equalSignatures(IProgramElement elt, ConcreteTypeMunger munger) {
        try {
            return this.equalNames(elt, munger) && this.equalParams(elt, munger);
        }
        catch (NullPointerException nullPointerException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(nullPointerException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            return false;
        }
    }

    private boolean equalNames(IProgramElement elt, ConcreteTypeMunger munger) {
        ResolvedMember signature = munger.getSignature();
        return signature != null && this.qualifiedElementName(signature).equals(this.qualifiedElementName(elt));
    }

    private String qualifiedElementName(ResolvedMember signature) {
        return String.valueOf(signature.getDeclaringType().getBaseName()) + "." + signature.getName();
    }

    private String qualifiedElementName(IProgramElement elt) {
        String packageName = elt.getPackageName();
        if (packageName != null && packageName.length() > 0) {
            return String.valueOf(elt.getPackageName()) + "." + elt.getName();
        }
        return elt.getName();
    }

    private boolean equalParams(IProgramElement elt, ConcreteTypeMunger munger) {
        int eltTypesLength;
        UnresolvedType[] unresolvedTypes = munger.getSignature().getParameterTypes();
        List eltTypes = elt.getParameterTypes();
        int unresolvedTypesLength = unresolvedTypes == null ? 0 : unresolvedTypes.length;
        int n = eltTypesLength = eltTypes == null ? 0 : eltTypes.size();
        if (unresolvedTypesLength != eltTypesLength) {
            return false;
        }
        int i = 0;
        while (i < unresolvedTypesLength) {
            String unresolvedTypeName;
            String eltParamType = new String((char[])eltTypes.get(i));
            int genericStart = eltParamType.indexOf(60);
            if (genericStart > -1) {
                eltParamType = eltParamType.substring(0, genericStart);
            }
            if ((genericStart = (unresolvedTypeName = unresolvedTypes[i].getName()).indexOf(60)) > -1) {
                unresolvedTypeName = unresolvedTypeName.substring(0, genericStart);
            }
            if (!unresolvedTypeName.equals(eltParamType)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        Factory factory = new Factory("AJWorldFacade.java", Class.forName("org.eclipse.ajdt.core.model.AJWorldFacade"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.model.AJWorldFacade", "java.lang.Exception:", "<missing>:"), 123);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "findITDInfoIfExists", "org.eclipse.ajdt.core.model.AJWorldFacade", "[C:[C:", "targetTypeSignature:name:", "", "org.eclipse.ajdt.core.model.AJWorldFacade$ITDInfo"), 107);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.model.AJWorldFacade", "java.lang.NullPointerException:", "<missing>:"), 216);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "equalSignatures", "org.eclipse.ajdt.core.model.AJWorldFacade", "org.aspectj.asm.IProgramElement:org.aspectj.weaver.ConcreteTypeMunger:", "elt:munger:", "", "boolean"), 213);
    }

    public static class ErasedTypeSignature {
        public final String returnType;
        public final String[] paramTypes;

        public ErasedTypeSignature(String returnType, String[] paramTypes) {
            this.returnType = returnType;
            this.paramTypes = paramTypes;
        }
    }

    public static class ITDInfo {
        public final IProgramElement.Accessibility accessibility;
        public final String packageDeclaredIn;
        public final String topLevelAspectName;

        static ITDInfo create(ConcreteTypeMunger cMunger) {
            ResolvedType aspectType = cMunger.getAspectType();
            if (aspectType != null) {
                ResolvedMember sig = cMunger.getSignature();
                IProgramElement.Accessibility a = sig != null ? ProgramElement.genAccessibility((int)sig.getModifiers()) : IProgramElement.Accessibility.PUBLIC;
                String packageDeclaredIn = aspectType.getPackageName();
                String topLevelAspectName = aspectType.getOutermostType().getClassName();
                return new ITDInfo(a, packageDeclaredIn, topLevelAspectName);
            }
            return null;
        }

        public ITDInfo(IProgramElement.Accessibility accessibility, String packageDeclaredIn, String topLevelAspectName) {
            this.accessibility = accessibility;
            this.packageDeclaredIn = packageDeclaredIn;
            this.topLevelAspectName = topLevelAspectName;
        }
    }
}

