/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.parserbridge;

import java.util.ArrayList;
import java.util.Map;
import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.DeclareDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeConstructorDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeFieldDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.asm.IProgramElement;
import org.aspectj.org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitInfo;
import org.eclipse.ajdt.core.javaelements.AdviceElement;
import org.eclipse.ajdt.core.javaelements.AdviceElementInfo;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.javaelements.AspectElementInfo;
import org.eclipse.ajdt.core.javaelements.AspectJMemberElement;
import org.eclipse.ajdt.core.javaelements.AspectJMemberElementInfo;
import org.eclipse.ajdt.core.javaelements.CompilationUnitTools;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.DeclareElementInfo;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElementInfo;
import org.eclipse.ajdt.core.javaelements.PointcutElement;
import org.eclipse.ajdt.core.javaelements.PointcutElementInfo;
import org.eclipse.ajdt.internal.core.parserbridge.IAspectSourceElementRequestor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.CompilationUnitStructureRequestor;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.NamedMember;
import org.eclipse.jdt.internal.core.PackageDeclaration;
import org.eclipse.jdt.internal.core.SourceRefElement;

public class AJCompilationUnitStructureRequestor
extends CompilationUnitStructureRequestor
implements IAspectSourceElementRequestor {
    private static final char[] VOID = new char[]{'v', 'o', 'i', 'd'};
    protected static final JavaElement[] NO_ELEMENTS = new JavaElement[0];

    public AJCompilationUnitStructureRequestor(ICompilationUnit unit, AJCompilationUnitInfo unitInfo, Map newElements) {
        super(unit, (CompilationUnitElementInfo)unitInfo, newElements);
    }

    public void setParser(Parser parser) {
        CompilerOptions options = new CompilerOptions();
        ProblemReporter probrep = new ProblemReporter(null, options, null);
        org.eclipse.jdt.internal.compiler.parser.Parser otherParser = new org.eclipse.jdt.internal.compiler.parser.Parser(probrep, false);
        this.setJDTParser(otherParser);
    }

    private void setJDTParser(org.eclipse.jdt.internal.compiler.parser.Parser parser) {
        this.parser = parser;
    }

    public void setSource(char[] source) {
        this.parser.scanner.source = source;
    }

    public void exitCompilationUnit(int declarationEnd) {
        super.exitCompilationUnit(declarationEnd);
        this.unitInfo.annotationNumber = 0;
    }

    public void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes, boolean isConstructor, boolean isAnnotation, ISourceElementRequestor.TypeParameterInfo[] typeParameters, AbstractMethodDeclaration methodDeclaration) {
        if (methodDeclaration instanceof AdviceDeclaration) {
            this.enterAdvice(declarationStart, modifiers, returnType, name, nameSourceStart, nameSourceEnd, parameterTypes, parameterNames, exceptionTypes, (AdviceDeclaration)methodDeclaration);
            return;
        }
        if (methodDeclaration instanceof PointcutDeclaration) {
            this.enterPointcut(declarationStart, modifiers, returnType, name, nameSourceStart, nameSourceEnd, parameterTypes, parameterNames, exceptionTypes, (PointcutDeclaration)methodDeclaration);
            return;
        }
        if (methodDeclaration instanceof DeclareDeclaration) {
            this.enterDeclare(declarationStart, modifiers, returnType, name, nameSourceStart, nameSourceEnd, parameterTypes, parameterNames, exceptionTypes, (DeclareDeclaration)methodDeclaration);
            return;
        }
        if (methodDeclaration instanceof InterTypeDeclaration) {
            this.enterInterTypeDeclaration(declarationStart, modifiers, returnType, name, nameSourceStart, nameSourceEnd, parameterTypes, parameterNames, exceptionTypes, (InterTypeDeclaration)methodDeclaration);
            return;
        }
        ISourceElementRequestor.MethodInfo mi = new ISourceElementRequestor.MethodInfo();
        mi.declarationStart = declarationStart;
        mi.modifiers = modifiers;
        mi.name = name;
        mi.nameSourceStart = nameSourceStart;
        mi.nameSourceEnd = nameSourceEnd;
        mi.parameterNames = parameterNames;
        mi.parameterTypes = parameterTypes;
        mi.exceptionTypes = exceptionTypes;
        mi.returnType = returnType;
        mi.isConstructor = isConstructor;
        mi.isAnnotation = isAnnotation;
        mi.typeParameters = this.convertToJDTTypeParameters(typeParameters);
        super.enterMethod(mi);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo mi) {
        this.enterMethod(mi.declarationStart, mi.modifiers, mi.returnType, mi.name, mi.nameSourceStart, mi.nameSourceEnd, mi.parameterTypes, mi.parameterNames, mi.exceptionTypes, mi.isConstructor, mi.isAnnotation, this.convertToAJTypeParameters(mi.typeParameters), null);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo mi) {
        this.enterMethod(mi.declarationStart, mi.modifiers, mi.returnType, mi.name, mi.nameSourceStart, mi.nameSourceEnd, mi.parameterTypes, mi.parameterNames, mi.exceptionTypes, mi.isConstructor, mi.isAnnotation, mi.typeParameters, null);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo mi, AbstractMethodDeclaration mdecl) {
        this.enterMethod(mi.declarationStart, mi.modifiers, mi.returnType, mi.name, mi.nameSourceStart, mi.nameSourceEnd, mi.parameterTypes, mi.parameterNames, mi.exceptionTypes, mi.isConstructor, mi.isAnnotation, this.convertToAJTypeParameters(mi.typeParameters), mdecl);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo mi, AbstractMethodDeclaration mdecl) {
        this.enterMethod(mi.declarationStart, mi.modifiers, mi.returnType, mi.name, mi.nameSourceStart, mi.nameSourceEnd, mi.parameterTypes, mi.parameterNames, mi.exceptionTypes, mi.isConstructor, mi.isAnnotation, mi.typeParameters, mdecl);
    }

    static String[] convertTypeNamesToSigsCopy(char[][] typeNames) {
        if (typeNames == null) {
            return CharOperation.NO_STRINGS;
        }
        int n = typeNames.length;
        if (n == 0) {
            return CharOperation.NO_STRINGS;
        }
        String[] typeSigs = new String[n];
        int i = 0;
        while (i < n) {
            typeSigs[i] = Signature.createTypeSignature((char[])typeNames[i], (boolean)false);
            ++i;
        }
        return typeSigs;
    }

    public void enterAdvice(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes, AdviceDeclaration decl) {
        Object parentInfo = this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        AdviceElement handle = null;
        if (parameterTypes == null) {
            parameterTypes = CharOperation.NO_CHAR_CHAR;
        }
        if (parameterNames == null) {
            parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        if (exceptionTypes == null) {
            exceptionTypes = CharOperation.NO_CHAR_CHAR;
        }
        String nameString = decl.kind.getName();
        String[] parameterTypeSigs = AJCompilationUnitStructureRequestor.convertTypeNamesToSigsCopy(parameterTypes);
        handle = new AdviceElement(parentHandle, nameString, parameterTypeSigs);
        this.resolveDuplicates((SourceRefElement)handle);
        AdviceElementInfo info = new AdviceElementInfo();
        info.setAJKind(IProgramElement.Kind.ADVICE);
        IProgramElement.ExtraInformation extraInfo = new IProgramElement.ExtraInformation();
        info.setAJExtraInfo(extraInfo);
        extraInfo.setExtraAdviceInformation(decl.kind.getName());
        info.setSourceRangeStart(declarationStart);
        int flags = modifiers;
        info.setName(nameString.toCharArray());
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setFlags(flags);
        info.setArgumentNames(parameterNames);
        info.setReturnType(returnType == null ? VOID : returnType);
        info.setExceptionTypeNames(exceptionTypes);
        this.addToChildren(parentInfo, (JavaElement)handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void enterInterTypeDeclaration(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes, InterTypeDeclaration decl) {
        nameSourceEnd = nameSourceStart + decl.getDeclaredSelector().length - 1;
        Object parentInfo = this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        IntertypeElement handle = null;
        if (parameterTypes == null) {
            parameterTypes = CharOperation.NO_CHAR_CHAR;
        }
        if (parameterNames == null) {
            parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        if (exceptionTypes == null) {
            exceptionTypes = CharOperation.NO_CHAR_CHAR;
        }
        String nameString = String.valueOf(this.concat(decl.getOnType().getTypeName())) + "." + new String(decl.getDeclaredSelector());
        String[] parameterTypeSigs = AJCompilationUnitStructureRequestor.convertTypeNamesToSigsCopy(parameterTypes);
        handle = IntertypeElement.create(IntertypeElement.getJemDelimter(decl), parentHandle, nameString, parameterTypeSigs);
        this.resolveDuplicates((SourceRefElement)handle);
        IntertypeElementInfo info = new IntertypeElementInfo();
        if (decl instanceof InterTypeFieldDeclaration) {
            info.setAJKind(IProgramElement.Kind.INTER_TYPE_FIELD);
        } else if (decl instanceof InterTypeMethodDeclaration) {
            info.setAJKind(IProgramElement.Kind.INTER_TYPE_METHOD);
        } else if (decl instanceof InterTypeConstructorDeclaration) {
            info.setAJKind(IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR);
        } else {
            info.setAJKind(IProgramElement.Kind.INTER_TYPE_PARENT);
        }
        info.setAJAccessibility(CompilationUnitTools.getAccessibilityFromModifierCode(decl.declaredModifiers));
        info.setAJModifiers(CompilationUnitTools.getModifiersFromModifierCode(decl.declaredModifiers));
        info.setSourceRangeStart(declarationStart);
        int flags = modifiers;
        info.setName(nameString.toCharArray());
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        if (decl.getOnType() != null) {
            info.setTargetTypeStart(decl.getOnType().sourceStart);
            info.setTargetTypeEnd(decl.getOnType().sourceEnd + 1);
        }
        info.setTargetType(this.concat(decl.getOnType().getTypeName()).toCharArray());
        info.setFlags(flags);
        info.setDeclaredModifiers(decl.declaredModifiers);
        info.setArgumentNames(parameterNames);
        info.setReturnType(returnType == null ? VOID : returnType);
        info.setExceptionTypeNames(exceptionTypes);
        this.addToChildren(parentInfo, (JavaElement)handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    private String concat(char[][] declName) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < declName.length) {
            String namePart = new String(declName[i]);
            sb.append(namePart);
            if (i < declName.length - 1) {
                sb.append(".");
            }
            ++i;
        }
        return sb.toString();
    }

    public void enterDeclare(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes, DeclareDeclaration decl) {
        nameSourceEnd = nameSourceStart += 8;
        Object parentInfo = this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        DeclareElement handle = null;
        DeclareElementInfo info = new DeclareElementInfo();
        if (decl.declareDecl instanceof DeclareErrorOrWarning) {
            String cfr_ignored_0 = ": \"" + ((DeclareErrorOrWarning)decl.declareDecl).getMessage() + "\"";
            if (((DeclareErrorOrWarning)decl.declareDecl).isError()) {
                info.setAJKind(IProgramElement.Kind.DECLARE_ERROR);
                nameSourceEnd += 4;
            } else {
                info.setAJKind(IProgramElement.Kind.DECLARE_WARNING);
                nameSourceEnd += 6;
            }
        } else if (decl.declareDecl instanceof DeclareParents) {
            info.setAJKind(IProgramElement.Kind.DECLARE_PARENTS);
            nameSourceEnd += 6;
        } else if (decl.declareDecl instanceof DeclarePrecedence) {
            info.setAJKind(IProgramElement.Kind.DECLARE_PRECEDENCE);
            nameSourceEnd += 9;
        } else if (decl.declareDecl instanceof DeclareAnnotation) {
            DeclareAnnotation anno = (DeclareAnnotation)decl.declareDecl;
            if (anno.isDeclareAtConstuctor()) {
                info.setAJKind(IProgramElement.Kind.DECLARE_ANNOTATION_AT_CONSTRUCTOR);
                nameSourceEnd += "@constructor".length() - 1;
            } else if (anno.isDeclareAtField()) {
                info.setAJKind(IProgramElement.Kind.DECLARE_ANNOTATION_AT_FIELD);
                nameSourceEnd += "@field".length() - 1;
            } else if (anno.isDeclareAtMethod()) {
                info.setAJKind(IProgramElement.Kind.DECLARE_ANNOTATION_AT_METHOD);
                nameSourceEnd += "@method".length() - 1;
            } else if (anno.isDeclareAtType()) {
                info.setAJKind(IProgramElement.Kind.DECLARE_ANNOTATION_AT_TYPE);
                nameSourceEnd += "@type".length() - 1;
            }
        } else {
            info.setAJKind(IProgramElement.Kind.DECLARE_SOFT);
            nameSourceEnd += 3;
        }
        String nameString = info.getAJKind().toString();
        if (parameterTypes == null) {
            parameterTypes = CharOperation.NO_CHAR_CHAR;
        }
        if (parameterNames == null) {
            parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        if (exceptionTypes == null) {
            exceptionTypes = CharOperation.NO_CHAR_CHAR;
        }
        String[] parameterTypeSigs = AJCompilationUnitStructureRequestor.convertTypeNamesToSigsCopy(parameterTypes);
        handle = new DeclareElement(parentHandle, nameString, parameterTypeSigs);
        this.resolveDuplicates((SourceRefElement)handle);
        info.setSourceRangeStart(declarationStart);
        int flags = modifiers;
        info.setName(nameString.toCharArray());
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setFlags(flags);
        info.setArgumentNames(parameterNames);
        info.setReturnType(returnType == null ? VOID : returnType);
        info.setExceptionTypeNames(exceptionTypes);
        this.addToChildren(parentInfo, (JavaElement)handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void enterPointcut(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes, PointcutDeclaration decl) {
        Object parentInfo = this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        PointcutElement handle = null;
        if (parameterTypes == null) {
            parameterTypes = CharOperation.NO_CHAR_CHAR;
        }
        if (parameterNames == null) {
            parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        if (exceptionTypes == null) {
            exceptionTypes = CharOperation.NO_CHAR_CHAR;
        }
        String[] parameterTypeSigs = AJCompilationUnitStructureRequestor.convertTypeNamesToSigsCopy(parameterTypes);
        handle = new PointcutElement(parentHandle, new String(name), parameterTypeSigs);
        this.resolveDuplicates((SourceRefElement)handle);
        PointcutElementInfo info = new PointcutElementInfo();
        info.setAJKind(IProgramElement.Kind.POINTCUT);
        info.setAJAccessibility(CompilationUnitTools.getAccessibilityFromModifierCode(decl.modifiers));
        info.setAJModifiers(CompilationUnitTools.getModifiersFromModifierCode(decl.modifiers));
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(decl.sourceEnd + 1);
        int flags = modifiers;
        info.setName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setFlags(flags);
        info.setArgumentNames(parameterNames);
        info.setReturnType(returnType == null ? VOID : returnType);
        info.setExceptionTypeNames(exceptionTypes);
        this.addToChildren(parentInfo, (JavaElement)handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void acceptProblem(CategorizedProblem problem) {
        if ((problem.getID() & 0x40000000) != 0) {
            this.hasSyntaxErrors = true;
        }
    }

    private void addToChildren(Object parentInfo, JavaElement handle) {
        ArrayList<JavaElement> childrenList = (ArrayList<JavaElement>)this.children.get(parentInfo);
        if (childrenList == null) {
            childrenList = new ArrayList<JavaElement>();
            this.children.put(parentInfo, childrenList);
        }
        childrenList.add(handle);
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        ISourceElementRequestor.MethodInfo mi = new ISourceElementRequestor.MethodInfo();
        mi.declarationStart = methodInfo.declarationStart;
        mi.modifiers = methodInfo.modifiers;
        mi.name = methodInfo.name;
        mi.nameSourceStart = methodInfo.nameSourceStart;
        mi.nameSourceEnd = methodInfo.nameSourceEnd;
        mi.parameterNames = methodInfo.parameterNames;
        mi.parameterTypes = methodInfo.parameterTypes;
        mi.exceptionTypes = methodInfo.exceptionTypes;
        mi.isConstructor = true;
        this.enterConstructor(mi);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        ISourceElementRequestor.FieldInfo fi = new ISourceElementRequestor.FieldInfo();
        fi.declarationStart = fieldInfo.declarationStart;
        fi.modifiers = fieldInfo.modifiers;
        fi.type = fieldInfo.type;
        fi.name = fieldInfo.name;
        fi.nameSourceStart = fieldInfo.nameSourceStart;
        fi.nameSourceEnd = fieldInfo.nameSourceEnd;
        this.enterField(fi);
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo, boolean isAspect, boolean isPrivilegedAspect) {
        this.enterType(typeInfo.declarationStart, typeInfo.modifiers, typeInfo.name, typeInfo.nameSourceStart, typeInfo.nameSourceEnd, typeInfo.superclass, typeInfo.superinterfaces, this.convertToJDTTypeParameters(typeInfo.typeParameters), isAspect, isPrivilegedAspect);
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        this.enterType(typeInfo.declarationStart, typeInfo.modifiers, typeInfo.name, typeInfo.nameSourceStart, typeInfo.nameSourceEnd, typeInfo.superclass, typeInfo.superinterfaces, this.convertToJDTTypeParameters(typeInfo.typeParameters), false, false);
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo, boolean isAspect, boolean isPrivilegedAspect) {
        this.enterType(typeInfo.declarationStart, typeInfo.modifiers, typeInfo.name, typeInfo.nameSourceStart, typeInfo.nameSourceEnd, typeInfo.superclass, typeInfo.superinterfaces, typeInfo.typeParameters, isAspect, isPrivilegedAspect);
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        this.enterType(typeInfo.declarationStart, typeInfo.modifiers, typeInfo.name, typeInfo.nameSourceStart, typeInfo.nameSourceEnd, typeInfo.superclass, typeInfo.superinterfaces, typeInfo.typeParameters, false, false);
    }

    protected void enterType(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclass, char[][] superinterfaces, ISourceElementRequestor.TypeParameterInfo[] tpInfo, boolean isAspect, boolean isPrivilegedAspect) {
        IAspectSourceElementRequestor.AspectTypeInfo typeInfo = new IAspectSourceElementRequestor.AspectTypeInfo();
        typeInfo.declarationStart = declarationStart;
        typeInfo.modifiers = modifiers;
        typeInfo.name = name;
        typeInfo.nameSourceStart = nameSourceStart;
        typeInfo.nameSourceEnd = nameSourceEnd;
        typeInfo.superclass = superclass;
        typeInfo.superinterfaces = superinterfaces;
        typeInfo.typeParameters = tpInfo;
        typeInfo.isAspect = isAspect;
        typeInfo.isPrivilegedAspect = isPrivilegedAspect;
        if (!isAspect) {
            super.enterType((ISourceElementRequestor.TypeInfo)typeInfo);
        } else {
            JavaElement parentHandle = (JavaElement)this.handleStack.peek();
            Object parentInfo = this.infoStack.peek();
            String nameString = new String(name);
            AspectElement handle = new AspectElement(parentHandle, nameString);
            this.resolveDuplicates((SourceRefElement)handle);
            this.infoStack.push(typeInfo);
            this.handleStack.push(handle);
            if (parentHandle.getElementType() == 7) {
                ((ISourceElementRequestor.TypeInfo)parentInfo).childrenCategories.put(handle, typeInfo.categories);
            }
            this.addToChildren(parentInfo, (JavaElement)handle);
        }
    }

    public void exitType(int declarationEnd) {
        Object handle = this.handleStack.peek();
        if (handle instanceof AspectElement) {
            AspectElement aspectHandle = (AspectElement)handle;
            IAspectSourceElementRequestor.AspectTypeInfo typeInfo = (IAspectSourceElementRequestor.AspectTypeInfo)((Object)this.infoStack.peek());
            AspectElementInfo info = this.createAspectElementInfo(typeInfo, aspectHandle);
            info.setSourceRangeEnd(declarationEnd);
            info.setChildren(this.getChildren((Object)typeInfo));
            this.handleStack.pop();
            this.infoStack.pop();
        } else {
            super.exitType(declarationEnd);
        }
    }

    private AspectElementInfo createAspectElementInfo(IAspectSourceElementRequestor.AspectTypeInfo typeInfo, AspectElement handle) {
        AspectElementInfo info = typeInfo.anonymousMember ? new AspectElementInfo(){

            public boolean isAnonymousMember() {
                return true;
            }
        } : new AspectElementInfo();
        info.setAJKind(IProgramElement.Kind.ASPECT);
        info.setAJAccessibility(CompilationUnitTools.getAccessibilityFromModifierCode(typeInfo.modifiers));
        info.setAJModifiers(CompilationUnitTools.getModifiersFromModifierCode(typeInfo.modifiers));
        info.setPrivileged(typeInfo.isPrivilegedAspect);
        info.setHandle((IType)handle);
        info.setSourceRangeStart(typeInfo.declarationStart);
        info.setFlags(typeInfo.modifiers);
        info.setNameSourceStart(typeInfo.nameSourceStart);
        info.setNameSourceEnd(typeInfo.nameSourceEnd);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        char[] superclass = typeInfo.superclass;
        info.setSuperclassName(superclass == null ? null : manager.intern(superclass));
        char[][] superinterfaces = typeInfo.superinterfaces;
        int i = 0;
        int length = superinterfaces == null ? 0 : superinterfaces.length;
        while (i < length) {
            superinterfaces[i] = manager.intern(superinterfaces[i]);
            ++i;
        }
        info.setSuperInterfaceNames(superinterfaces);
        info.addCategories((IJavaElement)handle, typeInfo.categories);
        this.newElements.put(handle, info);
        if (typeInfo.typeParameters != null) {
            i = 0;
            length = typeInfo.typeParameters.length;
            while (i < length) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = typeInfo.typeParameters[i];
                this.acceptTypeParameter(typeParameterInfo, (JavaElementInfo)info);
                ++i;
            }
        }
        if (typeInfo.annotations != null) {
            int length2 = typeInfo.annotations.length;
            this.unitInfo.annotationNumber += length2;
            int i2 = 0;
            while (i2 < length2) {
                Annotation annotation = typeInfo.annotations[i2];
                this.acceptAnnotation(annotation, (AnnotatableInfo)info, (JavaElement)handle);
                ++i2;
            }
        }
        if (typeInfo.childrenCategories != null) {
            for (Map.Entry entry : typeInfo.childrenCategories.entrySet()) {
                info.addCategories((IJavaElement)entry.getKey(), (char[][])entry.getValue());
            }
        }
        return info;
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand, int modifiers) {
        super.acceptImport(declarationStart, declarationEnd, CharOperation.splitOn((char)'.', (char[])name), onDemand, modifiers);
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        PackageDeclaration handle = null;
        if (parentHandle.getElementType() == 5) {
            handle = this.createPackageDeclaration(parentHandle, new String(name));
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates((SourceRefElement)handle);
        class AJAnnotatableInfo
        extends AnnotatableInfo {
            AJAnnotatableInfo() {
            }

            protected void setSourceRangeStart(int start) {
                super.setSourceRangeStart(start);
            }

            protected void setSourceRangeEnd(int end) {
                super.setSourceRangeEnd(end);
            }
        }
        AJAnnotatableInfo info = new AJAnnotatableInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        this.addToChildren(parentInfo, (JavaElement)handle);
        this.newElements.put(handle, info);
    }

    public void exitMethod(int declarationEnd, int defaultValueStart, int defaultValueEnd) {
        NamedMember handle = (NamedMember)this.handleStack.peek();
        if (!(handle instanceof AspectJMemberElement)) {
            super.exitMethod(declarationEnd, null);
            return;
        }
        this.handleStack.pop();
        AspectJMemberElementInfo info = (AspectJMemberElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        info.setChildren(this.getChildren(info));
    }

    private IJavaElement[] getChildren(Object info) {
        ArrayList childrenList = (ArrayList)this.children.get(info);
        if (childrenList != null) {
            return childrenList.toArray(new IJavaElement[childrenList.size()]);
        }
        return NO_ELEMENTS;
    }

    public void acceptPackage(org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference ir) {
        ImportReference dup = new ImportReference(ir.tokens, ir.sourcePositions, (ir.bits & 0x20000) != 0, ir.modifiers);
        dup.declarationSourceStart = ir.declarationSourceStart;
        dup.declarationSourceEnd = ir.declarationSourceEnd;
        super.acceptPackage(dup);
    }

    private ISourceElementRequestor.TypeParameterInfo[] convertToJDTTypeParameters(ISourceElementRequestor.TypeParameterInfo[] ajTypeParams) {
        ISourceElementRequestor.TypeParameterInfo[] jdtTypeParams = new ISourceElementRequestor.TypeParameterInfo[ajTypeParams == null ? 0 : ajTypeParams.length];
        int i = 0;
        while (i < jdtTypeParams.length) {
            jdtTypeParams[i] = new ISourceElementRequestor.TypeParameterInfo();
            jdtTypeParams[i].declarationStart = ajTypeParams[i].declarationStart;
            jdtTypeParams[i].declarationEnd = ajTypeParams[i].declarationEnd;
            jdtTypeParams[i].name = ajTypeParams[i].name;
            jdtTypeParams[i].nameSourceStart = ajTypeParams[i].nameSourceStart;
            jdtTypeParams[i].nameSourceEnd = ajTypeParams[i].nameSourceEnd;
            jdtTypeParams[i].bounds = ajTypeParams[i].bounds;
            ++i;
        }
        return jdtTypeParams;
    }

    private ISourceElementRequestor.TypeParameterInfo[] convertToAJTypeParameters(ISourceElementRequestor.TypeParameterInfo[] jdtTypeParams) {
        ISourceElementRequestor.TypeParameterInfo[] ajTypeParams = new ISourceElementRequestor.TypeParameterInfo[jdtTypeParams == null ? 0 : jdtTypeParams.length];
        int i = 0;
        while (i < ajTypeParams.length) {
            ajTypeParams[i] = new ISourceElementRequestor.TypeParameterInfo();
            ajTypeParams[i].declarationStart = jdtTypeParams[i].declarationStart;
            ajTypeParams[i].declarationEnd = jdtTypeParams[i].declarationEnd;
            ajTypeParams[i].name = jdtTypeParams[i].name;
            ajTypeParams[i].nameSourceStart = jdtTypeParams[i].nameSourceStart;
            ajTypeParams[i].nameSourceEnd = jdtTypeParams[i].nameSourceEnd;
            ajTypeParams[i].bounds = jdtTypeParams[i].bounds;
            ++i;
        }
        return ajTypeParams;
    }
}

