/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.text;

import java.util.ArrayList;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.codeconversion.AspectsConvertingParser;
import org.eclipse.ajdt.core.codeconversion.ConversionOptions;
import org.eclipse.ajdt.core.codeconversion.ITDAwareNameEnvironment;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.text.ITDAwareSelectionRequestor;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class ITDCodeSelection {
    private final org.eclipse.jdt.core.ICompilationUnit unit;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public ITDCodeSelection(org.eclipse.jdt.core.ICompilationUnit unit) {
        this.unit = unit;
    }

    public IJavaElement[] findJavaElement(IRegion wordRegion) throws JavaModelException {
        JavaProject javaProject = (JavaProject)this.unit.getJavaProject();
        ITDAwareNameEnvironment environment = new ITDAwareNameEnvironment(javaProject, this.unit.getOwner(), null);
        ITDAwareSelectionRequestor requestor = new ITDAwareSelectionRequestor(AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)javaProject), this.unit);
        SelectionEngine engine = new SelectionEngine((SearchableEnvironment)environment, (ISelectionRequestor)requestor, javaProject.getOptions(true), this.unit.getOwner());
        final AspectsConvertingParser converter = new AspectsConvertingParser(((CompilationUnit)this.unit).getContents());
        converter.setUnit(this.unit);
        ArrayList<AspectsConvertingParser.Replacement> replacements = converter.convert(ConversionOptions.CODE_COMPLETION);
        CompilationUnit wrappedUnit = new CompilationUnit((PackageFragment)this.unit.getParent(), this.unit.getElementName(), this.unit.getOwner()){

            public char[] getContents() {
                return converter.content;
            }
        };
        int transformedStart = AspectsConvertingParser.translatePositionToAfterChanges(wordRegion.getOffset(), replacements);
        int transformedEnd = AspectsConvertingParser.translatePositionToAfterChanges(wordRegion.getOffset() + wordRegion.getLength(), replacements) - 1;
        requestor.setReplacements(replacements);
        engine.select((ICompilationUnit)wrappedUnit, transformedStart, transformedEnd);
        IntertypeElement itd = this.itdOrNull(this.unit, wordRegion.getOffset());
        if (itd != null && (itd.getAJKind() == IProgramElement.Kind.INTER_TYPE_METHOD || itd.getAJKind() == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR)) {
            char[] targetType = itd.getTargetType();
            final AspectsConvertingParser converter2 = new AspectsConvertingParser(((CompilationUnit)this.unit).getContents());
            converter2.setUnit(this.unit);
            ArrayList<AspectsConvertingParser.Replacement> replacements2 = converter2.convert(ConversionOptions.getCodeCompletionOptionWithContextSwitch(wordRegion.getOffset(), targetType));
            wrappedUnit = new CompilationUnit((PackageFragment)this.unit.getParent(), this.unit.getElementName(), this.unit.getOwner()){

                public char[] getContents() {
                    return converter2.content;
                }
            };
            transformedStart = AspectsConvertingParser.translatePositionToAfterChanges(wordRegion.getOffset(), replacements2);
            transformedEnd = AspectsConvertingParser.translatePositionToAfterChanges(wordRegion.getOffset() + wordRegion.getLength(), replacements2) - 1;
            requestor.setReplacements(replacements2);
            SelectionEngine engine2 = new SelectionEngine((SearchableEnvironment)environment, (ISelectionRequestor)requestor, javaProject.getOptions(true), this.unit.getOwner());
            engine2.select((ICompilationUnit)wrappedUnit, transformedStart, transformedEnd);
        }
        IJavaElement[] elements = requestor.getElements();
        if (itd != null && elements.length == 0) {
            IType targetType;
            ISourceRange targetNameRange;
            ISourceRange nameRange = itd.getNameRange();
            if (nameRange.getOffset() <= wordRegion.getOffset() && nameRange.getOffset() + nameRange.getLength() >= wordRegion.getOffset() + wordRegion.getLength()) {
                elements = new IJavaElement[]{itd};
            }
            if ((targetNameRange = itd.getTargetTypeSourceRange()).getOffset() <= wordRegion.getOffset() && targetNameRange.getOffset() + targetNameRange.getLength() >= wordRegion.getOffset() + wordRegion.getLength() && (targetType = itd.findTargetType()) != null) {
                elements = new IJavaElement[]{targetType};
            }
        }
        return elements;
    }

    private IntertypeElement itdOrNull(org.eclipse.jdt.core.ICompilationUnit unit, int pos) throws JavaModelException {
        IJavaElement elt;
        if (unit instanceof AJCompilationUnit && (elt = unit.getElementAt(pos)) instanceof IntertypeElement) {
            IntertypeElement itd = (IntertypeElement)elt;
            return itd;
        }
        return null;
    }

    public IJavaElement[] shortCutCodeSelection(Region wordRegion) {
        try {
            IType type;
            IntertypeElement itd;
            ISourceRange range;
            IJavaElement elt = this.unit.getElementAt(wordRegion.getOffset());
            if (elt instanceof IntertypeElement && (range = (itd = (IntertypeElement)elt).getTargetTypeSourceRange()) != null && range.getOffset() <= wordRegion.getOffset() && range.getOffset() + range.getLength() >= wordRegion.getOffset() + wordRegion.getLength() && (type = itd.findTargetType()) != null) {
                return new IJavaElement[]{type};
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        return null;
    }

    static {
        Factory factory = new Factory("ITDCodeSelection.java", Class.forName("org.eclipse.ajdt.core.text.ITDCodeSelection"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.text.ITDCodeSelection", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 157);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "shortCutCodeSelection", "org.eclipse.ajdt.core.text.ITDCodeSelection", "org.eclipse.jface.text.Region:", "wordRegion:", "", "[Lorg.eclipse.jdt.core.IJavaElement;"), 143);
    }
}

