/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.javaelements.PointcutUtilities;
import org.eclipse.ajdt.core.text.CoreMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class AspectRenameParticipant
extends RenameParticipant {
    private IType fType;
    private String qualifiedName;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange finalChange = new CompositeChange(CoreMessages.renameTypeReferences);
        String oldName = this.fType.getElementName();
        String newName = this.getArguments().getNewName();
        IProject project = this.fType.getResource().getProject();
        AJLog.log("Rename type references in aspects from " + oldName + " to " + newName);
        AJLog.log("qualified name: " + this.fType.getFullyQualifiedName());
        List<AJCompilationUnit> ajs = AJCompilationUnitManager.INSTANCE.getCachedCUs(project);
        pm.beginTask(CoreMessages.renameTypeReferences, ajs.size());
        for (AJCompilationUnit ajcu : ajs) {
            if (!this.targetTypeIsAccessible(ajcu)) continue;
            AJLog.log("Looking for type references for " + oldName + " in " + ajcu.getElementName());
            TextEdit[] edits = this.renameAspectSpecificReferences(ajcu, newName);
            if (edits.length > 0) {
                CompilationUnitChange change = this.findOrCreateChange(ajcu, finalChange);
                TextEditChangeGroup[] groups = change.getTextEditChangeGroups();
                TextEdit[] textEditArray = edits;
                int n = edits.length;
                int n2 = 0;
                while (n2 < n) {
                    block7: {
                        TextEdit typeRenameEdit = textEditArray[n2];
                        TextEditChangeGroup[] textEditChangeGroupArray = groups;
                        int n3 = groups.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TextEditChangeGroup group = textEditChangeGroupArray[n4];
                            TextEdit[] textEditArray2 = group.getTextEdits();
                            int n5 = textEditArray2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                TextEdit existingEdit = textEditArray2[n6];
                                if (!existingEdit.covers(typeRenameEdit)) {
                                    ++n6;
                                    continue;
                                }
                                break block7;
                            }
                            ++n4;
                        }
                        change.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)change, new TextEditGroup("Update type reference in aspect", typeRenameEdit)));
                        change.addEdit(typeRenameEdit);
                    }
                    ++n2;
                }
            }
            pm.worked(1);
        }
        pm.done();
        if (finalChange.getChildren().length == 0) {
            return null;
        }
        return finalChange;
    }

    private CompilationUnitChange findOrCreateChange(AJCompilationUnit ajcu, CompositeChange finalChange) {
        CompilationUnitChange existingChange = null;
        TextChange textChange = this.getTextChange(ajcu);
        if (textChange instanceof CompilationUnitChange) {
            existingChange = (CompilationUnitChange)textChange;
        } else {
            Change[] children;
            Change[] changeArray = children = finalChange.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Change change = changeArray[n2];
                if (change instanceof CompilationUnitChange && ((CompilationUnitChange)change).getCompilationUnit().equals(ajcu)) {
                    existingChange = (CompilationUnitChange)change;
                    break;
                }
                ++n2;
            }
        }
        if (existingChange == null) {
            existingChange = new CompilationUnitChange("ITD accessor renamings for " + ajcu.getElementName(), (ICompilationUnit)ajcu);
            existingChange.setEdit((TextEdit)new MultiTextEdit());
            finalChange.add((Change)existingChange);
        }
        return existingChange;
    }

    private TextEdit[] renameAspectSpecificReferences(AJCompilationUnit ajcu, String newName) throws JavaModelException {
        ArrayList editList = new ArrayList();
        String name = this.fType.getElementName();
        IType[] types = ajcu.getTypes();
        int i = 0;
        while (i < types.length) {
            ReplaceEdit[] aspectChanges;
            if (types[i] instanceof AspectElement && (aspectChanges = this.searchForReferenceInPointcut((AspectElement)types[i], name, newName)).length != 0) {
                editList.addAll(Arrays.asList(aspectChanges));
            }
            ++i;
        }
        return editList.toArray(new TextEdit[editList.size()]);
    }

    private ReplaceEdit[] searchForReferenceInPointcut(AspectElement aspect, String name, String newName) throws JavaModelException {
        IAspectJElement[] elementsToSearch;
        AJCompilationUnit ajcu = (AJCompilationUnit)aspect.getCompilationUnit();
        ArrayList<ReplaceEdit> replaceEdits = new ArrayList<ReplaceEdit>();
        IAspectJElement[] iAspectJElementArray = elementsToSearch = aspect.getAllAspectMemberElements();
        int n = elementsToSearch.length;
        int n2 = 0;
        while (n2 < n) {
            IAspectJElement element = iAspectJElementArray[n2];
            if (element instanceof ISourceReference) {
                Map<String, List<Integer>> map;
                ajcu.requestOriginalContentMode();
                String src = element.getSource();
                int elementStart = element.getSourceRange().getOffset();
                ajcu.discardOriginalContentMode();
                if (src != null && (map = PointcutUtilities.findAllIdentifiers(src)) != null) {
                    for (Map.Entry<String, List<Integer>> entry : map.entrySet()) {
                        if (!entry.getKey().equals(name)) continue;
                        for (Integer offset : entry.getValue()) {
                            AJLog.log("  found reference at offset " + offset);
                            replaceEdits.add(new ReplaceEdit(elementStart + offset, name.length(), newName));
                        }
                    }
                }
            }
            ++n2;
        }
        return replaceEdits.toArray(new ReplaceEdit[0]);
    }

    private boolean targetTypeIsAccessible(AJCompilationUnit ajcu) {
        if (this.inSamePackage(ajcu)) {
            return true;
        }
        IImportDeclaration imp = ajcu.getImport(this.qualifiedName);
        return imp.exists();
    }

    private boolean inSamePackage(AJCompilationUnit ajcu) {
        String ajPackage = CharOperation.toString((char[][])ajcu.getPackageName());
        return ajPackage.equals(this.removeTypeName(this.qualifiedName));
    }

    private String removeTypeName(String qualifiedName) {
        int ind = qualifiedName.lastIndexOf(46);
        if (ind == -1) {
            return "";
        }
        return qualifiedName.substring(0, ind);
    }

    public String getName() {
        return "Rename type references in Aspects";
    }

    protected boolean initialize(Object element) {
        if (element instanceof IType) {
            this.fType = (IType)element;
            if (AspectJPlugin.isAJProject(this.fType.getJavaProject().getProject())) {
                this.qualifiedName = this.fType.getFullyQualifiedName();
                return true;
            }
        }
        return false;
    }

    static class AspectChange {
        IAspectJElement element;
        List<Integer> offsets;

        AspectChange() {
        }
    }
}

