/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.renderers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.contribution.visualiser.palettes.PatternVisualiserPalette;
import org.eclipse.contribution.visualiser.renderers.ClassicVisualiserRenderer;
import org.eclipse.contribution.visualiser.utils.ColorConstants;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class PatternVisualiserRenderer
extends ClassicVisualiserRenderer {
    private static PatternVisualiserRenderer pvr;
    PatternVisualiserPalette palette = new PatternVisualiserPalette();
    private static int nextAvailablePattern;
    private Map patternMemory = new HashMap();

    static {
        nextAvailablePattern = 0;
    }

    private PatternVisualiserRenderer() {
    }

    public static PatternVisualiserRenderer getPatternRenderer() {
        if (pvr == null) {
            pvr = new PatternVisualiserRenderer();
        }
        return pvr;
    }

    protected byte[][] getNextPattern() {
        byte[][][] pats = this.palette.getPaletteContents();
        if (nextAvailablePattern < pats.length) {
            byte[][] patternData = pats[nextAvailablePattern++];
            return patternData;
        }
        byte[][] patternData = this.palette.getRandomPattern();
        return patternData;
    }

    private Pattern createPattern(byte[][] patternData) {
        Image patternImg = new Image((Device)Display.getCurrent(), 8, 8);
        GC gc = new GC((Drawable)patternImg);
        int i = 0;
        while (i < patternData.length) {
            byte[] b = patternData[i];
            gc.setForeground(ColorConstants.black);
            if (b[1] == b[3] && b[2] == b[4]) {
                gc.drawPoint((int)b[1], (int)b[2]);
            } else {
                gc.drawLine((int)b[1], (int)b[2], (int)b[3], (int)b[4]);
            }
            ++i;
        }
        Pattern pattern = new Pattern((Device)Display.getCurrent(), patternImg);
        gc.dispose();
        patternImg.dispose();
        return pattern;
    }

    private byte[][] getPatternForColour(RGB rgb, boolean isPrefDialog) {
        byte[][] stripePatternData = null;
        if (this.patternMemory.containsKey(rgb)) {
            stripePatternData = (byte[][])this.patternMemory.get(rgb);
        } else {
            stripePatternData = this.getNextPattern();
            this.patternMemory.put(rgb, stripePatternData);
        }
        return stripePatternData;
    }

    public void setDitherPattern(GC gc, RGB rgb) {
        gc.setBackgroundPattern(this.createPattern(this.getPatternForColour(rgb, false)));
    }
}

