/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.asm.IRelationship;
import org.eclipse.ajdt.core.AspectJCore;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationship;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;

public class AJModel {
    private static AJModel instance = new AJModel();

    public static AJModel getInstance() {
        return instance;
    }

    public List getAllRelationships(IProject proj, AJRelationshipType[] relTypes) {
        AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForProject(proj);
        if (model.hasModel()) {
            List<IRelationship> allRels = model.getRelationshipsForProject(relTypes);
            ArrayList<AJRelationship> ajRels = new ArrayList<AJRelationship>(allRels.size());
            for (IRelationship rel : allRels) {
                IJavaElement source = model.programElementToJavaElement(rel.getSourceHandle());
                if (!(source instanceof IntertypeElement)) continue;
                for (String target : rel.getTargets()) {
                    IJavaElement elt = model.programElementToJavaElement(target);
                    if ((elt = JavaCore.create((String)AspectJCore.convertToJavaCUHandle(elt.getHandleIdentifier(), elt))) == null) continue;
                    AJRelationship ajRel = new AJRelationship(source, AJRelationshipManager.toRelationshipType(rel.getName()), elt, rel.hasRuntimeTest());
                    ajRels.add(ajRel);
                }
            }
            return ajRels;
        }
        return Collections.EMPTY_LIST;
    }
}

