/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.jdt.cuprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.contribution.jdt.JDTWeavingPlugin;
import org.eclipse.contribution.jdt.cuprovider.ICompilationUnitProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class CompilationUnitProviderRegistry {
    public static String CUPROVIDERS_EXTENSION_POINT = "org.eclipse.contribution.weaving.jdt.cuprovider";
    private static final CompilationUnitProviderRegistry INSTANCE = new CompilationUnitProviderRegistry();
    private Map<String, ICompilationUnitProvider> registry;

    public static CompilationUnitProviderRegistry getInstance() {
        return INSTANCE;
    }

    private CompilationUnitProviderRegistry() {
    }

    void registerCompilationUnitProvider(String key, ICompilationUnitProvider provider) {
        this.registry.put(key, provider);
    }

    ICompilationUnitProvider getProvider(String key) {
        if (!this.isRegistered()) {
            this.registerProviders();
        }
        return this.registry.get(key);
    }

    public boolean isRegistered() {
        return this.registry != null;
    }

    public void registerProviders() {
        this.registry = new HashMap<String, ICompilationUnitProvider>();
        IExtensionPoint exP = Platform.getExtensionRegistry().getExtensionPoint(CUPROVIDERS_EXTENSION_POINT);
        if (exP != null) {
            IExtension[] exs = exP.getExtensions();
            int i = 0;
            while (i < exs.length) {
                IConfigurationElement[] configs = exs[i].getConfigurationElements();
                int j = 0;
                while (j < configs.length) {
                    try {
                        IConfigurationElement config = configs[j];
                        if (config.isValid()) {
                            ICompilationUnitProvider provider = (ICompilationUnitProvider)config.createExecutableExtension("class");
                            this.registerCompilationUnitProvider(config.getAttribute("file_extension"), provider);
                        }
                    }
                    catch (CoreException e) {
                        JDTWeavingPlugin.logException(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

