/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.ajc;

import org.aspectj.ajdt.ajc.BuildArgParser;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.ICommand;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.org.eclipse.jdt.internal.core.builder.MissingSourceFileException;
import org.aspectj.weaver.Dump;

public class AjdtCommand
implements ICommand {
    public static final String ABORT_MESSAGE = "ABORT";
    AjBuildManager buildManager = null;
    String[] savedArgs = null;

    public boolean runCommand(String[] args, IMessageHandler handler) {
        this.buildManager = new AjBuildManager(handler);
        this.savedArgs = new String[args.length];
        System.arraycopy(args, 0, this.savedArgs, 0, this.savedArgs.length);
        return this.doCommand(handler, false);
    }

    public boolean repeatCommand(IMessageHandler handler) {
        if (null == this.buildManager) {
            MessageUtil.abort((IMessageHandler)handler, (String)"repeatCommand called before runCommand");
            return false;
        }
        return this.doCommand(handler, true);
    }

    protected boolean doCommand(IMessageHandler handler, boolean repeat) {
        try {
            CountingMessageHandler counter;
            if (handler instanceof IMessageHolder) {
                Dump.saveMessageHolder((IMessageHolder)((IMessageHolder)handler));
            }
            if ((counter = new CountingMessageHandler(handler)).hasErrors()) {
                return false;
            }
            AjBuildConfig config = AjdtCommand.genBuildConfig(this.savedArgs, counter);
            if (!config.shouldProceed()) {
                return true;
            }
            if (!config.hasSources()) {
                MessageUtil.error((IMessageHandler)counter, (String)"no sources specified");
            }
            if (counter.hasErrors()) {
                return false;
            }
            boolean result = (repeat ? this.buildManager.incrementalBuild(config, handler) : this.buildManager.batchBuild(config, handler)) && !counter.hasErrors();
            Dump.dumpOnExit();
            return result;
        }
        catch (AbortException ae) {
            if (ae.isSilent()) {
                throw ae;
            }
            MessageUtil.abort((IMessageHandler)handler, (String)ABORT_MESSAGE, (Throwable)ae);
        }
        catch (MissingSourceFileException t) {
            MessageUtil.error((IMessageHandler)handler, (String)t.getMessage());
        }
        catch (Throwable t) {
            MessageUtil.abort((IMessageHandler)handler, (String)ABORT_MESSAGE, (Throwable)t);
            Dump.dumpWithException((Throwable)t);
        }
        return false;
    }

    public static AjBuildConfig genBuildConfig(String[] args, CountingMessageHandler handler) {
        String message;
        BuildArgParser parser = new BuildArgParser((IMessageHandler)handler);
        AjBuildConfig config = parser.genBuildConfig(args);
        SourceLocation location = null;
        if (config.getConfigFile() != null) {
            location = new SourceLocation(config.getConfigFile(), 0);
        }
        if (null != (message = parser.getOtherMessages(true))) {
            IMessage.Kind kind = AjdtCommand.inferKind(message);
            Message m = new Message(message, kind, null, (ISourceLocation)location);
            handler.handleMessage((IMessage)m);
        }
        return config;
    }

    protected static IMessage.Kind inferKind(String message) {
        if (message.contains("[error]")) {
            return IMessage.ERROR;
        }
        if (message.contains("[warning]")) {
            return IMessage.WARNING;
        }
        if (AjdtCommand.containsAll(message, "Usage: <options>", "AspectJ-specific options:", "Classpath options:") || AjdtCommand.containsAll(message, "Warning options:", "-nowarn", "localHiding", "uselessTypeCheck") || AjdtCommand.containsAll(message, "AspectJ-specific non-standard options:", "-XnoInline", "-Xjoinpoints:")) {
            return IMessage.USAGE;
        }
        return IMessage.INFO;
    }

    private static boolean containsAll(String message, String ... searchStrings) {
        for (String searchString : searchStrings) {
            if (message.contains(searchString)) continue;
            return false;
        }
        return true;
    }
}

