/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.KnownMessageSend;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeScope;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.NewConstructorTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;

public class InterTypeConstructorDeclaration
extends InterTypeDeclaration {
    private static final String SUPPRESSAJWARNINGS = "Lorg/aspectj/lang/annotation/SuppressAjWarnings;";
    private static final String NOEXPLICITCONSTRUCTORCALL = "noExplicitConstructorCall";
    private MethodDeclaration preMethod;
    private ExplicitConstructorCall explicitConstructorCall = null;

    public InterTypeConstructorDeclaration(CompilationResult result, TypeReference onType) {
        super(result, onType);
    }

    @Override
    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        parser.parse(this, unit);
    }

    @Override
    protected char[] getPrefix() {
        return "ajc$interType$interConstructor$".toCharArray();
    }

    @Override
    public void resolve(ClassScope upperScope) {
        if (this.munger == null || this.binding == null) {
            this.ignoreFurtherInvestigation = true;
        }
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        this.explicitConstructorCall = null;
        if (this.statements != null && this.statements.length > 0 && this.statements[0] instanceof ExplicitConstructorCall) {
            this.explicitConstructorCall = (ExplicitConstructorCall)this.statements[0];
            this.statements = AstUtil.remove(0, this.statements);
        }
        this.preMethod = this.makePreMethod(upperScope, this.explicitConstructorCall);
        this.binding.parameters = AstUtil.insert(this.onTypeBinding, this.binding.parameters);
        this.arguments = AstUtil.insert(AstUtil.makeFinalArgument("ajc$this_".toCharArray(), this.onTypeBinding), this.arguments);
        super.resolve(upperScope);
        if (this.explicitConstructorCall == null) {
            this.raiseNoFieldInitializersWarning();
        }
    }

    private void raiseNoFieldInitializersWarning() {
        if (this.suppressingNoExplicitConstructorCall()) {
            return;
        }
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        EclipseSourceLocation location = new EclipseSourceLocation(this.scope.problemReporter().referenceContext.compilationResult(), this.sourceStart(), this.sourceEnd());
        world.getWorld().getLint().noExplicitConstructorCall.signal(null, (ISourceLocation)location);
    }

    private boolean suppressingNoExplicitConstructorCall() {
        if (this.annotations == null) {
            return false;
        }
        for (Annotation annotation : this.annotations) {
            if (!new String(annotation.resolvedType.signature()).equals(SUPPRESSAJWARNINGS)) continue;
            if (annotation instanceof MarkerAnnotation) {
                return true;
            }
            if (!(annotation instanceof SingleMemberAnnotation)) continue;
            SingleMemberAnnotation sma = (SingleMemberAnnotation)annotation;
            if (!(sma.memberValue instanceof ArrayInitializer)) continue;
            ArrayInitializer memberValue = (ArrayInitializer)sma.memberValue;
            for (int j = 0; j < memberValue.expressions.length; ++j) {
                StringLiteral val;
                if (!(memberValue.expressions[j] instanceof StringLiteral) || !new String((val = (StringLiteral)memberValue.expressions[j]).source()).equals(NOEXPLICITCONSTRUCTORCALL)) continue;
                return true;
            }
        }
        return false;
    }

    private MethodDeclaration makePreMethod(ClassScope scope, ExplicitConstructorCall explicitConstructorCall) {
        int i;
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(scope);
        UnresolvedType aspectTypeX = world.fromBinding(this.binding.declaringClass);
        UnresolvedType targetTypeX = world.fromBinding(this.onTypeBinding);
        ArrayBinding objectArrayBinding = scope.createArrayType(scope.getJavaLangObject(), 1);
        MethodDeclaration pre = new MethodDeclaration(this.compilationResult);
        pre.modifiers = 9;
        pre.returnType = AstUtil.makeTypeReference(objectArrayBinding);
        pre.selector = NameMangler.postIntroducedConstructor((UnresolvedType)aspectTypeX, (UnresolvedType)targetTypeX).toCharArray();
        pre.arguments = AstUtil.copyArguments(this.arguments);
        pre.scope = new MethodScope(scope, pre, true);
        ResolvedMemberImpl preIntroducedConstructorRM = world.makeResolvedMember(this.binding);
        preIntroducedConstructorRM.resetName(NameMangler.preIntroducedConstructor((UnresolvedType)aspectTypeX, (UnresolvedType)targetTypeX));
        preIntroducedConstructorRM.resetModifiers(25);
        preIntroducedConstructorRM.resetReturnTypeToObjectArray();
        pre.binding = world.makeMethodBinding((ResolvedMember)preIntroducedConstructorRM);
        pre.bindArguments();
        pre.bindThrownExceptions();
        pre.statements = explicitConstructorCall == null ? new Statement[0] : new Statement[]{explicitConstructorCall};
        InterTypeScope newParent = new InterTypeScope((Scope)scope, this.onTypeBinding);
        pre.scope.setParent(newParent);
        pre.resolveStatements();
        int nParams = pre.arguments.length;
        MethodBinding explicitConstructor = null;
        if (explicitConstructorCall != null && (explicitConstructor = explicitConstructorCall.binding) != null && explicitConstructor.alwaysNeedsAccessMethod()) {
            explicitConstructor = explicitConstructor.getAccessMethod(true);
        }
        int nExprs = explicitConstructor == null ? 0 : explicitConstructor.parameters.length;
        ArrayInitializer init = new ArrayInitializer();
        init.expressions = new Expression[nExprs + nParams];
        int index = 0;
        for (i = 0; i < nExprs; ++i) {
            if (i >= (explicitConstructorCall.arguments == null ? 0 : explicitConstructorCall.arguments.length)) {
                init.expressions[index++] = new NullLiteral(0, 0);
                continue;
            }
            Expression arg = explicitConstructorCall.arguments[i];
            ResolvedMember conversionMethod = AjcMemberMaker.toObjectConversionMethod((UnresolvedType)world.fromBinding(explicitConstructorCall.binding.parameters[i]));
            if (conversionMethod != null) {
                arg = new KnownMessageSend(world.makeMethodBindingForCall((Member)conversionMethod), new CastExpression(new NullLiteral(0, 0), AstUtil.makeTypeReference(world.makeTypeBinding(AjcMemberMaker.CONVERSIONS_TYPE))), new Expression[]{arg});
            }
            init.expressions[index++] = arg;
        }
        for (i = 0; i < nParams; ++i) {
            LocalVariableBinding binding = pre.arguments[i].binding;
            Expression arg = AstUtil.makeResolvedLocalVariableReference(binding);
            ResolvedMember conversionMethod = AjcMemberMaker.toObjectConversionMethod((UnresolvedType)world.fromBinding(binding.type));
            if (conversionMethod != null) {
                arg = new KnownMessageSend(world.makeMethodBindingForCall((Member)conversionMethod), new CastExpression(new NullLiteral(0, 0), AstUtil.makeTypeReference(world.makeTypeBinding(AjcMemberMaker.CONVERSIONS_TYPE))), new Expression[]{arg});
            }
            init.expressions[index++] = arg;
        }
        init.binding = objectArrayBinding;
        ArrayAllocationExpression newArray = new ArrayAllocationExpression();
        newArray.initializer = init;
        newArray.type = AstUtil.makeTypeReference(scope.getJavaLangObject());
        newArray.dimensions = new Expression[1];
        newArray.constant = Constant.NotAConstant;
        pre.statements = new Statement[]{new ReturnStatement(newArray, 0, 0)};
        return pre;
    }

    @Override
    public EclipseTypeMunger build(ClassScope classScope) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(classScope);
        this.resolveOnType(classScope);
        if (this.ignoreFurtherInvestigation) {
            return null;
        }
        this.binding = classScope.referenceContext.binding.resolveTypesFor(this.binding);
        if (this.isTargetAnnotation(classScope, "constructor")) {
            return null;
        }
        if (this.isTargetEnum(classScope, "constructor")) {
            return null;
        }
        if (this.onTypeBinding.isInterface()) {
            classScope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "can't define constructors on interfaces");
            this.ignoreFurtherInvestigation = true;
            return null;
        }
        if (this.onTypeBinding.isNestedType()) {
            classScope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "can't define constructors on nested types (compiler limitation)");
            this.ignoreFurtherInvestigation = true;
            return null;
        }
        ResolvedType declaringTypeX = world.fromEclipse(this.onTypeBinding);
        ResolvedType aspectType = world.fromEclipse(classScope.referenceContext.binding);
        if (this.interTypeScope == null) {
            return null;
        }
        ResolvedMemberImpl signature = world.makeResolvedMemberForITD(this.binding, this.onTypeBinding, this.interTypeScope.getRecoveryAliases());
        signature.resetKind(Member.CONSTRUCTOR);
        signature.resetName("<init>");
        int resetModifiers = this.declaredModifiers;
        if (this.binding.isVarargs()) {
            resetModifiers |= 0x80;
        }
        signature.resetModifiers(resetModifiers);
        ResolvedMember syntheticInterMember = AjcMemberMaker.interConstructor((ResolvedType)declaringTypeX, (ResolvedMember)signature, (UnresolvedType)aspectType);
        NewConstructorTypeMunger myMunger = new NewConstructorTypeMunger((ResolvedMember)signature, syntheticInterMember, null, null, this.typeVariableAliases);
        this.setMunger((ResolvedTypeMunger)myMunger);
        myMunger.check(world.getWorld());
        this.binding.selector = NameMangler.postIntroducedConstructor((UnresolvedType)world.fromBinding(this.binding.declaringClass), (UnresolvedType)declaringTypeX).toCharArray();
        this.selector = this.binding.selector;
        return new EclipseTypeMunger(world, (ResolvedTypeMunger)myMunger, aspectType, this);
    }

    private AjAttribute makeAttribute(EclipseFactory world) {
        if (this.explicitConstructorCall != null && this.explicitConstructorCall.binding != null && !(this.explicitConstructorCall.binding instanceof ProblemMethodBinding)) {
            MethodBinding explicitConstructor = this.explicitConstructorCall.binding;
            if (explicitConstructor.alwaysNeedsAccessMethod()) {
                explicitConstructor = explicitConstructor.getAccessMethod(true);
            }
            if (explicitConstructor instanceof ParameterizedMethodBinding) {
                explicitConstructor = explicitConstructor.original();
            }
            ((NewConstructorTypeMunger)this.munger).setExplicitConstructor((ResolvedMember)world.makeResolvedMember(explicitConstructor));
        } else {
            ((NewConstructorTypeMunger)this.munger).setExplicitConstructor((ResolvedMember)new ResolvedMemberImpl(Member.CONSTRUCTOR, world.fromBinding(this.onTypeBinding.superclass()), 0, UnresolvedType.VOID, "<init>", UnresolvedType.NONE));
        }
        return new AjAttribute.TypeMunger(this.munger);
    }

    @Override
    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(classScope);
        classFile.extraAttributes.add(new EclipseAttributeAdapter(this.makeAttribute(world)));
        super.generateCode(classScope, classFile);
        this.preMethod.generateCode(classScope, classFile);
    }

    @Override
    protected Shadow.Kind getShadowKindForBody() {
        return Shadow.ConstructorExecution;
    }
}

