/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.aspectj.ajdt.internal.compiler.IOutputClassFileNameProvider;
import org.aspectj.asm.internal.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.ExactTypePattern;
import org.aspectj.weaver.patterns.TypePattern;

public class PushinCollector {
    private static final String OPTION_SUFFIX = "suffix";
    private static final String OPTION_DIR = "dir";
    private static final String OPTION_PKGDIRS = "packageDirs";
    private static final String OPTION_DEBUG = "debug";
    private static final String OPTION_LINENUMS = "lineNums";
    private static final String OPTION_DUMPUNCHANGED = "dumpUnchanged";
    private World world;
    private boolean debug = false;
    private boolean dumpUnchanged = false;
    private IOutputClassFileNameProvider outputFileNameProvider;
    private String specifiedOutputDirectory;
    private boolean includePackageDirs;
    private boolean includeLineNumberComments;
    private String suffix;
    private Map<AbstractMethodDeclaration, RepresentationAndLocation> codeRepresentation = new HashMap<AbstractMethodDeclaration, RepresentationAndLocation>();
    private Map<SourceTypeBinding, List<String>> additionalAnnotations = new HashMap<SourceTypeBinding, List<String>>();
    private Map<SourceTypeBinding, List<ExactTypePattern>> additionalParents = new HashMap<SourceTypeBinding, List<ExactTypePattern>>();
    private Map<SourceTypeBinding, List<AbstractMethodDeclaration>> newDeclarations = new HashMap<SourceTypeBinding, List<AbstractMethodDeclaration>>();

    private PushinCollector(World world, Properties configuration) {
        this.world = world;
        this.specifiedOutputDirectory = configuration.getProperty(OPTION_DIR);
        this.includePackageDirs = configuration.getProperty(OPTION_PKGDIRS, "true").equalsIgnoreCase("true");
        this.includeLineNumberComments = configuration.getProperty(OPTION_LINENUMS, "false").equalsIgnoreCase("true");
        this.debug = configuration.getProperty(OPTION_DEBUG, "false").equalsIgnoreCase("true");
        this.dumpUnchanged = configuration.getProperty(OPTION_DUMPUNCHANGED, "false").equalsIgnoreCase("true");
        String specifiedSuffix = configuration.getProperty(OPTION_SUFFIX, "pushedin");
        if (specifiedSuffix.length() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(".").append(specifiedSuffix);
            this.suffix = sb.toString();
        } else {
            this.suffix = "";
        }
        if (this.debug) {
            System.out.println("Configured to create pushin side files:" + configuration);
            System.out.println("dumpUnchanged=" + this.dumpUnchanged + "\nincludePackageDirs=" + this.includePackageDirs);
        }
    }

    private String getName(CompilationUnitDeclaration cud) {
        if (cud == null) {
            return "UNKNOWN";
        }
        if (cud.scope == null) {
            return "UNKNOWN";
        }
        if (cud.scope.referenceContext == null) {
            return "UNKNOWN";
        }
        return new String(cud.scope.referenceContext.getFileName());
    }

    private boolean hasChanged(SourceTypeBinding stb) {
        return this.newDeclarations.get(stb) != null || this.additionalParents.get(stb) != null || this.additionalAnnotations.get(stb) != null;
    }

    public void dump(CompilationUnitDeclaration compilationUnitDeclaration, String outputFileLocation) {
        if (compilationUnitDeclaration.scope.topLevelTypes == null || compilationUnitDeclaration.scope.topLevelTypes.length == 0) {
            return;
        }
        SourceTypeBinding[] types = compilationUnitDeclaration.scope.topLevelTypes;
        if (types == null || types.length == 0) {
            return;
        }
        StringBuilder sourceContents = new StringBuilder();
        boolean changed = false;
        sourceContents.append(compilationUnitDeclaration.compilationResult.compilationUnit.getContents());
        for (int t = types.length - 1; t >= 0; --t) {
            List<String> annos;
            SourceTypeBinding sourceTypeBinding = compilationUnitDeclaration.scope.topLevelTypes[t];
            if (!this.hasChanged(sourceTypeBinding)) {
                if (!this.debug) continue;
                System.out.println(this.getName(compilationUnitDeclaration) + " has nothing applied");
                continue;
            }
            changed = true;
            int bodyEnd = sourceTypeBinding.scope.referenceContext.bodyEnd;
            List<AbstractMethodDeclaration> declarations = this.newDeclarations.get(sourceTypeBinding);
            if (declarations != null) {
                for (AbstractMethodDeclaration md : declarations) {
                    RepresentationAndLocation ral = this.codeRepresentation.get(md);
                    if (ral == null) continue;
                    String s = ral.textualRepresentation;
                    sourceContents.insert(bodyEnd, "\n" + s + "\n");
                    if (!this.includeLineNumberComments || ral.linenumber == -1) continue;
                    sourceContents.insert(bodyEnd, "\n    // " + ral.linenumber);
                }
            }
            TypeReference sr = sourceTypeBinding.scope.referenceContext.superclass;
            TypeReference[] trs = sourceTypeBinding.scope.referenceContext.superInterfaces;
            List<ExactTypePattern> newParents = this.additionalParents.get(sourceTypeBinding);
            StringBuilder extendsString = new StringBuilder();
            StringBuilder implementsString = new StringBuilder();
            if (newParents != null && newParents.size() > 0) {
                for (ExactTypePattern newParent : newParents) {
                    ResolvedType newParentType = newParent.getExactType().resolve(this.world);
                    if (newParentType.isInterface()) {
                        if (implementsString.length() > 0) {
                            implementsString.append(",");
                        }
                        implementsString.append(newParentType.getName());
                        continue;
                    }
                    extendsString.append(newParentType.getName());
                }
                if (trs == null && sr == null) {
                    int beforeOpeningCurly = sourceTypeBinding.scope.referenceContext.bodyStart - 1;
                    if (implementsString.length() != 0) {
                        implementsString.insert(0, "implements ");
                        implementsString.append(" ");
                        sourceContents.insert(beforeOpeningCurly, implementsString);
                    }
                    if (extendsString.length() != 0) {
                        extendsString.insert(0, "extends ");
                        extendsString.append(" ");
                        sourceContents.insert(beforeOpeningCurly, extendsString);
                    }
                }
            }
            if ((annos = this.additionalAnnotations.get(sourceTypeBinding)) == null || annos.size() <= 0) continue;
            for (String anno : annos) {
                sourceContents.insert(sourceTypeBinding.scope.referenceContext.declarationSourceStart, anno + " ");
            }
        }
        if (changed || !changed && this.dumpUnchanged) {
            try {
                if (this.debug) {
                    System.out.println("Pushed in output file being written to " + outputFileLocation);
                    System.out.println(sourceContents);
                }
                FileWriter fos = new FileWriter(new File(outputFileLocation));
                fos.write(sourceContents.toString());
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void recordInterTypeMethodDeclarationCode(AbstractMethodDeclaration md, String s, int line) {
        this.codeRepresentation.put(md, new RepresentationAndLocation(s, line));
    }

    public void recordInterTypeFieldDeclarationCode(AbstractMethodDeclaration md, String s, int line) {
        this.codeRepresentation.put(md, new RepresentationAndLocation(s, line));
    }

    public void recordInterTypeConstructorDeclarationCode(AbstractMethodDeclaration md, String s, int line) {
        this.codeRepresentation.put(md, new RepresentationAndLocation(s, line));
    }

    public void tagAsMunged(SourceTypeBinding sourceType, AbstractMethodDeclaration sourceMethod) {
        if (sourceMethod == null) {
            return;
        }
        List amds = this.newDeclarations.computeIfAbsent(sourceType, k -> new ArrayList());
        amds.add(sourceMethod);
    }

    public void tagAsMunged(SourceTypeBinding sourceType, String annotationString) {
        List annos = this.additionalAnnotations.computeIfAbsent(sourceType, k -> new ArrayList());
        annos.add(annotationString);
    }

    public void dump(CompilationUnitDeclaration unit) {
        String outputFile = this.getOutputFileFor(unit);
        if (this.debug) {
            System.out.println("Output location is " + outputFile + " for " + new String(unit.scope.referenceContext.getFileName()));
        }
        this.dump(unit, outputFile);
    }

    private String getOutputFileFor(CompilationUnitDeclaration unit) {
        char[][] packageName;
        StringBuilder sb = new StringBuilder();
        if (this.specifiedOutputDirectory != null) {
            sb.append(this.specifiedOutputDirectory).append(File.separator);
        } else {
            String sss = this.outputFileNameProvider.getOutputClassFileName("A".toCharArray(), unit.compilationResult);
            sb.append(sss, 0, sss.length() - 7);
        }
        if (this.includePackageDirs && (packageName = unit.compilationResult.packageName) != null) {
            sb.append(CharOperation.concatWith((char[][])unit.compilationResult.packageName, (char)File.separatorChar));
            sb.append(File.separator);
        }
        new File(sb.toString()).mkdirs();
        String filename = new String(unit.getFileName());
        int index = filename.lastIndexOf(47);
        int index2 = filename.lastIndexOf(92);
        if (index > index2) {
            sb.append(filename.substring(index + 1));
        } else if (index2 > index) {
            sb.append(filename.substring(index2 + 1));
        } else {
            sb.append(filename);
        }
        sb.append(this.suffix);
        return sb.toString();
    }

    public void tagAsMunged(SourceTypeBinding sourceType, TypePattern typePattern) {
        if (typePattern instanceof ExactTypePattern) {
            List annos = this.additionalParents.computeIfAbsent(sourceType, k -> new ArrayList());
            annos.add((ExactTypePattern)typePattern);
        }
    }

    public static PushinCollector createInstance(World world) {
        try {
            String property = System.getProperty("aspectj.pushin");
            if (property == null) {
                return null;
            }
            Properties configuration = new Properties();
            StringTokenizer tokenizer = new StringTokenizer(property, ",");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                if (token.equalsIgnoreCase("true")) continue;
                int positionOfEquals = token.indexOf("=");
                if (positionOfEquals != -1) {
                    String optionName = token.substring(0, positionOfEquals);
                    String optionValue = token.substring(positionOfEquals + 1);
                    configuration.put(optionName, optionValue);
                    continue;
                }
                configuration.put(token, "true");
            }
            return new PushinCollector(world, configuration);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setOutputFileNameProvider(IOutputClassFileNameProvider outputFileNameProvider) {
        this.outputFileNameProvider = outputFileNameProvider;
    }

    private static class RepresentationAndLocation {
        String textualRepresentation;
        int linenumber;

        public RepresentationAndLocation(String textualRepresentation, int linenumber) {
            this.textualRepresentation = textualRepresentation;
            this.linenumber = linenumber;
        }
    }
}

