/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IProgressListener;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.weaver.LintMessage;
import org.aspectj.weaver.World;

public class EclipseAdapterUtils {
    public static String makeLocationContext(ICompilationUnit compilationUnit, IProblem problem) {
        int i;
        char c;
        int begin;
        int endPosition;
        int startPosition = problem.getSourceStart();
        if (startPosition > (endPosition = problem.getSourceEnd()) || startPosition <= 0 && endPosition <= 0 || compilationUnit == null) {
            return "(no source information available)";
        }
        int SPACE = 32;
        int MARK = 94;
        int TAB = 9;
        char[] source = compilationUnit.getContents();
        int n = begin = startPosition >= source.length ? source.length - 1 : startPosition;
        if (begin == -1) {
            return "(no source information available)";
        }
        int relativeStart = 0;
        int end = endPosition >= source.length ? source.length - 1 : endPosition;
        int relativeEnd = 0;
        relativeStart = 0;
        while (begin != 0 && source[begin - 1] != '\n' && source[begin - 1] != '\r') {
            --begin;
            ++relativeStart;
        }
        relativeEnd = 0;
        while (end + 1 < source.length && source[end + 1] != '\r' && source[end + 1] != '\n') {
            ++end;
            ++relativeEnd;
        }
        char[] extract = new char[end - begin + 1];
        System.arraycopy(source, begin, extract, 0, extract.length);
        int trimLeftIndex = 0;
        while (((c = extract[trimLeftIndex++]) == '\t' || c == ' ') && trimLeftIndex < extract.length) {
        }
        if (trimLeftIndex >= extract.length) {
            return new String(extract) + "\n";
        }
        char[] cArray = extract;
        extract = new char[extract.length - trimLeftIndex + 1];
        System.arraycopy(cArray, trimLeftIndex - 1, extract, 0, extract.length);
        relativeStart -= trimLeftIndex;
        int pos = 0;
        char[] underneath = new char[extract.length];
        for (i = 0; i <= relativeStart; ++i) {
            underneath[pos++] = extract[i] == '\t' ? 9 : 32;
        }
        for (i = startPosition + trimLeftIndex; i <= (endPosition >= source.length ? source.length - 1 : endPosition); ++i) {
            underneath[pos++] = 94;
        }
        char[] cArray2 = underneath;
        underneath = new char[pos];
        System.arraycopy(cArray2, 0, underneath, 0, pos);
        return new String(extract) + "\n" + new String(underneath);
    }

    public static ISourceLocation makeSourceLocation(ICompilationUnit unit, IProblem problem, IProgressListener progressListener) {
        int line = problem.getSourceLineNumber();
        File file = new File(new String(problem.getOriginatingFileName()));
        if (progressListener != null) {
            return new SourceLocation(file, line, line, 0, null);
        }
        String context = EclipseAdapterUtils.makeLocationContext(unit, problem);
        return new SourceLocation(file, line, line, 0, context);
    }

    public static IMessage makeMessage(ICompilationUnit unit, IProblem problem, World world, IProgressListener progressListener) {
        ISourceLocation sourceLocation = EclipseAdapterUtils.makeSourceLocation(unit, problem, progressListener);
        IProblem[] seeAlso = problem.seeAlso();
        int validPlaces = 0;
        for (IProblem value : seeAlso) {
            if (value.getSourceLineNumber() < 0) continue;
            ++validPlaces;
        }
        ISourceLocation[] seeAlsoLocations = new ISourceLocation[validPlaces];
        int pos = 0;
        for (IProblem iProblem : seeAlso) {
            if (iProblem.getSourceLineNumber() < 0) continue;
            seeAlsoLocations[pos++] = new SourceLocation(new File(new String(iProblem.getOriginatingFileName())), iProblem.getSourceLineNumber());
        }
        String extraDetails = problem.getSupplementaryMessageInfo();
        boolean declared = false;
        boolean isLintMessage = false;
        String lintkey = null;
        if (extraDetails != null && extraDetails.endsWith("[deow=true]")) {
            declared = true;
            extraDetails = extraDetails.substring(0, extraDetails.length() - "[deow=true]".length());
        }
        if (extraDetails != null && extraDetails.contains("[Xlint:")) {
            isLintMessage = true;
            lintkey = extraDetails.substring(extraDetails.indexOf("[Xlint:"));
            lintkey = lintkey.substring("[Xlint:".length());
            lintkey = lintkey.substring(0, lintkey.indexOf("]"));
        }
        IMessage.Kind kind = problem.getID() == 536871362 ? IMessage.TASKTAG : (problem.isError() ? IMessage.ERROR : IMessage.WARNING);
        Object msg = null;
        msg = isLintMessage ? new LintMessage(problem.getMessage(), extraDetails, world.getLint().fromKey(lintkey), kind, sourceLocation, null, seeAlsoLocations, declared, problem.getID(), problem.getSourceStart(), problem.getSourceEnd()) : new Message(problem.getMessage(), extraDetails, kind, sourceLocation, null, seeAlsoLocations, declared, problem.getID(), problem.getSourceStart(), problem.getSourceEnd());
        return msg;
    }

    public static IMessage makeErrorMessage(ICompilationUnit unit, String text, Exception ex) {
        SourceLocation loc = new SourceLocation(new File(new String(unit.getFileName())), 0, 0, 0, "");
        Message msg = new Message(text, IMessage.ERROR, (Throwable)ex, (ISourceLocation)loc);
        return msg;
    }

    public static IMessage makeErrorMessage(String srcFile, String text, Exception ex) {
        SourceLocation loc = new SourceLocation(new File(srcFile), 0, 0, 0, "");
        Message msg = new Message(text, IMessage.ERROR, (Throwable)ex, (ISourceLocation)loc);
        return msg;
    }

    private EclipseAdapterUtils() {
    }
}

