/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.util;

import java.util.Collection;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.CharArrayHashMap;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.CharArrayMap;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.CharArrayMapper;

public class CharDelegateMap<P>
implements CharArrayMapper<P> {
    private static final int SMAL_BIG_THRESHOLD = 5;
    CharArrayMap<P> smallDelegate;
    CharArrayHashMap<P> bigDelegate;

    public CharDelegateMap() {
        this(0);
    }

    private CharArrayMapper<P> getDelegate() {
        return this.smallDelegate == null ? this.bigDelegate : this.smallDelegate;
    }

    public CharDelegateMap(int estimatedSize) {
        if (estimatedSize > 5) {
            this.bigDelegate = new CharArrayHashMap(estimatedSize);
        } else {
            this.smallDelegate = new CharArrayMap(estimatedSize);
        }
    }

    @Override
    public Collection<P> values() {
        return this.getDelegate().values();
    }

    @Override
    public boolean containsKey(char[] key) {
        return this.getDelegate().containsKey(key);
    }

    @Override
    public P get(char[] key) {
        if (this.smallDelegate != null) {
            return this.smallDelegate.get(key);
        }
        return this.bigDelegate.get(key);
    }

    @Override
    public P put(char[] key, P value) {
        if (this.smallDelegate != null) {
            P v = this.smallDelegate.put(key, value);
            if (this.smallDelegate.size() > 5) {
                this.toBigMap();
            }
            return v;
        }
        return this.bigDelegate.put(key, value);
    }

    private void toBigMap() {
        this.bigDelegate = new CharArrayHashMap(this.smallDelegate.size());
        this.smallDelegate.transferTo(this.bigDelegate);
        this.smallDelegate = null;
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    public String toString() {
        return CharArrayMapper.toString(this);
    }

    @Override
    public Collection<char[]> keys() {
        return this.getDelegate().keys();
    }
}

