/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.codeconversion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.aspectj.asm.IProgramElement;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.TerminalTokens;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.codeconversion.ConversionOptions;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.internal.core.ras.NoFFDC;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;

public class AspectsConvertingParser
implements TerminalTokens,
NoFFDC {
    private static final String IMPLEMENTS = "implements";
    private static final String EXTENDS = "extends";
    private static final char[] throwing = "throwing".toCharArray();
    private static final char[] returning = "returning".toCharArray();
    private static final char[] percflow = "percflow".toCharArray();
    private static final char[] percflowbelow = "percflowbelow".toCharArray();
    private static final char[] perthis = "perthis".toCharArray();
    private static final char[] pertarget = "pertarget".toCharArray();
    private static final char[] issingleton = "issingleton".toCharArray();
    private static final char[] pertypewithin = "pertypewithin".toCharArray();
    private static final char[] classs = "class ".toCharArray();
    private static final char[] privileged = "          ".toCharArray();
    public static final String ITD_INSERTED_IDENTIFIER = "___ITD_INSERTED_IDENTIFIER___";
    private static final char[] intt = "int    ".toCharArray();
    private static final char[] tjpRefs2 = "\n\torg.aspectj.lang.JoinPoint thisJoinPoint;\n\torg.aspectj.lang.JoinPoint.StaticPart thisJoinPointStaticPart;\n\torg.aspectj.lang.JoinPoint.StaticPart thisEnclosingJoinPointStaticPart;\n".toCharArray();
    private static final char[] endThrow = new char[]{'(', ':'};
    public char[] content;
    private Set<String> typeReferences;
    private Set<String> usedIdentifiers;
    private ConversionOptions options;
    private ICompilationUnit unit;
    private ArrayList<Replacement> replacements;
    protected Scanner scanner;
    private boolean inPointcutDesignator;
    private boolean inAspect;
    private boolean inAspectDeclaration;
    private boolean inClassDeclaration;
    private boolean inInterfaceDeclaration;
    private boolean inEnumDeclaration;
    private Set<String> knownTypeParameters;
    private boolean inRHS;
    private int posColon;

    public AspectsConvertingParser(char[] content) {
        this.content = content;
        this.typeReferences = new HashSet<String>();
        this.usedIdentifiers = new HashSet<String>();
        this.replacements = new ArrayList(5);
    }

    public void setUnit(ICompilationUnit unit) {
        this.unit = unit;
    }

    public ArrayList<Replacement> convert(ConversionOptions options) {
        this.options = options;
        boolean insertIntertypeDeclarations = options.isThisJoinPointReferencesEnabled();
        boolean addReferencesForOrganizeImports = options.isDummyTypeReferencesForOrganizeImportsEnabled();
        boolean isSimulateContextSwitchNecessary = options.getTargetType() != null;
        Stack<Boolean> inAspectBodyStack = new Stack<Boolean>();
        Stack<Boolean> inTypeBodyStack = new Stack<Boolean>();
        this.scanner = new Scanner();
        this.scanner.setSource(this.content);
        this.inPointcutDesignator = false;
        this.inAspect = false;
        this.inAspectDeclaration = false;
        this.inClassDeclaration = false;
        this.inInterfaceDeclaration = false;
        this.inEnumDeclaration = false;
        this.inRHS = false;
        int questionMarkCount = 0;
        int parenLevel = 0;
        boolean inFor = false;
        boolean inCase = false;
        boolean inPackageDecl = false;
        boolean afterDot = false;
        int typeParamDepth = 0;
        boolean afterOpenParen = false;
        boolean afterComma = false;
        char[] currentTypeName = null;
        this.replacements.clear();
        this.typeReferences.clear();
        this.usedIdentifiers.clear();
        int tok = 1;
        int prevTok = -1;
        int typeDeclStart = 0;
        char[] text = null;
        char[] prevText = null;
        while (true) {
            prevTok = tok;
            prevText = text;
            try {
                tok = this.scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                continue;
            }
            if (tok == 73) break;
            text = this.scanner.getCurrentIdentifierSource();
            switch (tok) {
                case 12: {
                    if (!this.inAspect && !this.inTypeDeclaration()) break;
                    char[] name = text;
                    if (this.inTypeDeclaration() && !this.inPointcutDesignator) {
                        if (this.inAspectDeclaration && !insertIntertypeDeclarations) {
                            if (CharOperation.equals((char[])percflow, (char[])name)) {
                                this.startPointcutDesignator();
                            } else if (CharOperation.equals((char[])percflowbelow, (char[])name)) {
                                this.startPointcutDesignator();
                            } else if (CharOperation.equals((char[])perthis, (char[])name)) {
                                this.startPointcutDesignator();
                            } else if (CharOperation.equals((char[])pertarget, (char[])name)) {
                                this.startPointcutDesignator();
                            } else if (CharOperation.equals((char[])issingleton, (char[])name)) {
                                this.startPointcutDesignator();
                            } else if (CharOperation.equals((char[])pertypewithin, (char[])name)) {
                                this.startPointcutDesignator();
                            }
                        }
                        if (currentTypeName == null) {
                            currentTypeName = name;
                        }
                    }
                    if (!afterComma && !afterOpenParen && (CharOperation.equals((char[])throwing, (char[])name) || CharOperation.equals((char[])returning, (char[])name))) {
                        this.consumeRetOrThrow();
                    } else if (this.inPointcutDesignator && Character.isUpperCase(name[0]) && this.content[this.scanner.getCurrentTokenStartPosition() - 1] != '.' && this.content[this.scanner.getCurrentTokenStartPosition() - 1] != '*') {
                        this.typeReferences.add(String.valueOf(name));
                    }
                    if (!isSimulateContextSwitchNecessary) break;
                    this.usedIdentifiers.add(new String(name));
                    break;
                }
                case 90: {
                    inFor = true;
                    break;
                }
                case 14: {
                    ++parenLevel;
                    inCase = false;
                    afterOpenParen = true;
                    break;
                }
                case 39: {
                    afterComma = true;
                    break;
                }
                case 28: {
                    inFor = false;
                    inCase = false;
                    --parenLevel;
                    typeParamDepth = 0;
                    break;
                }
                case 70: {
                    if (inFor) break;
                    if (questionMarkCount > 0) {
                        --questionMarkCount;
                        break;
                    }
                    if (inCase) {
                        inCase = false;
                        break;
                    }
                    this.startPointcutDesignator();
                    break;
                }
                case 78: {
                    if (parenLevel != 0) break;
                    this.inRHS = true;
                    break;
                }
                case 36: {
                    if (typeParamDepth != 0) break;
                    ++questionMarkCount;
                    break;
                }
                case 26: {
                    if (this.inPointcutDesignator) {
                        this.endPointcutDesignator();
                        if (options.isKeepPointcuts()) {
                            this.addReplacement(this.scanner.getCurrentTokenStartPosition(), 1, new char[]{'}'});
                        }
                    }
                    this.inRHS = false;
                    inPackageDecl = false;
                    break;
                }
                case 95: 
                case 100: {
                    inCase = true;
                    break;
                }
                case 1: {
                    afterDot = true;
                    if (!this.inAspect || this.inPointcutDesignator || parenLevel > 0 || this.inRHS || inAspectBodyStack.empty() || inAspectBodyStack.peek() != Boolean.TRUE) break;
                    this.processPotentialIntertypeDeclaration();
                    break;
                }
                case 58: {
                    if (this.inPointcutDesignator && parenLevel == 0) {
                        this.endPointcutDesignator();
                        if (options.isKeepPointcuts()) {
                            this.addReplacement(this.scanner.getCurrentTokenStartPosition(), 1, new char[]{' '});
                        }
                        if (insertIntertypeDeclarations && !this.inTypeDeclaration()) {
                            this.addReplacement(this.scanner.getCurrentTokenStartPosition() + 1, 0, tjpRefs2);
                        }
                    }
                    if (insertIntertypeDeclarations && this.inTypeDeclaration()) {
                        char[] implementsExtends = this.createImplementExtendsITDs(currentTypeName);
                        if (implementsExtends != null) {
                            this.addReplacement(typeDeclStart, this.scanner.getCurrentTokenStartPosition() - typeDeclStart, implementsExtends);
                        } else if (this.hasWordAtPosition("aspect", typeDeclStart)) {
                            this.addReplacement(typeDeclStart, classs.length, classs);
                        }
                        char[] interTypeDecls = this.getInterTypeDecls(currentTypeName);
                        if (interTypeDecls.length > 0) {
                            this.addReplacement(this.scanner.getCurrentTokenStartPosition() + 1, 0, interTypeDecls);
                        }
                    }
                    if (addReferencesForOrganizeImports) {
                        this.storeTypeParameters(currentTypeName);
                    }
                    if (this.inTypeDeclaration()) {
                        inTypeBodyStack.push(Boolean.TRUE);
                    } else {
                        inTypeBodyStack.push(Boolean.FALSE);
                    }
                    if (this.inAspectDeclaration) {
                        this.inAspectDeclaration = false;
                        inAspectBodyStack.push(Boolean.TRUE);
                    } else {
                        inAspectBodyStack.push(Boolean.FALSE);
                    }
                    inCase = false;
                    this.inClassDeclaration = false;
                    this.inInterfaceDeclaration = false;
                    this.inEnumDeclaration = false;
                    currentTypeName = null;
                    break;
                }
                case 31: {
                    if (inTypeBodyStack.isEmpty() || !((Boolean)inTypeBodyStack.peek()).booleanValue()) break;
                    this.addReplacement(this.scanner.getCurrentTokenStartPosition(), "after".length(), "int a".toCharArray());
                    break;
                }
                case 30: {
                    if (inTypeBodyStack.isEmpty() || !((Boolean)inTypeBodyStack.peek()).booleanValue()) break;
                    this.addReplacement(this.scanner.getCurrentTokenStartPosition(), "before".length(), "void b".toCharArray());
                    break;
                }
                case 41: {
                    if (this.inPointcutDesignator && parenLevel == 0) {
                        this.endPointcutDesignator();
                    }
                    if (!inAspectBodyStack.empty()) {
                        inAspectBodyStack.pop();
                    }
                    if (!inTypeBodyStack.empty()) {
                        inTypeBodyStack.pop();
                    }
                    inCase = false;
                    break;
                }
                case 24: {
                    int pos;
                    if (inPackageDecl) break;
                    this.inAspect = true;
                    this.inAspectDeclaration = true;
                    typeDeclStart = pos = this.scanner.getCurrentTokenStartPosition();
                    if (insertIntertypeDeclarations) break;
                    this.addReplacement(pos, classs.length, classs);
                    break;
                }
                case 32: {
                    if (!addReferencesForOrganizeImports || inAspectBodyStack.isEmpty() || !((Boolean)inAspectBodyStack.peek()).equals(Boolean.TRUE)) break;
                    this.addReplacement(this.scanner.getCurrentTokenStartPosition(), intt.length, intt);
                    break;
                }
                case 75: {
                    int pos;
                    if (afterDot) break;
                    typeDeclStart = pos = this.scanner.getCurrentTokenStartPosition();
                    this.inClassDeclaration = true;
                    break;
                }
                case 79: {
                    int pos;
                    typeDeclStart = pos = this.scanner.getCurrentTokenStartPosition();
                    this.inInterfaceDeclaration = true;
                    break;
                }
                case 82: {
                    int pos;
                    typeDeclStart = pos = this.scanner.getCurrentTokenStartPosition();
                    this.inEnumDeclaration = true;
                    break;
                }
                case 27: {
                    int pos = this.scanner.getCurrentTokenStartPosition();
                    this.addReplacement(pos, privileged.length, privileged);
                    break;
                }
                case 94: {
                    inPackageDecl = true;
                    break;
                }
                case 7: {
                    if ((inTypeBodyStack.isEmpty() || inTypeBodyStack.peek() != Boolean.TRUE) && !this.tokenLooksLikeTypeName(prevTok, prevText)) break;
                    ++typeParamDepth;
                    break;
                }
                case 15: {
                    if (typeParamDepth <= 0) break;
                    --typeParamDepth;
                    break;
                }
                case 13: {
                    if (typeParamDepth <= 0) break;
                    typeParamDepth -= 2;
                    break;
                }
                case 16: {
                    if (typeParamDepth <= 0) break;
                    typeParamDepth -= 3;
                    break;
                }
                case 40: {
                    int pos = this.scanner.getCurrentTokenStartPosition();
                    if (!this.isDeclareAnnotationStart(pos)) break;
                    this.addReplacement(pos, 1, "$".toCharArray());
                }
            }
            if (tok != 1) {
                afterDot = false;
            }
            if (tok != 14) {
                afterOpenParen = false;
            }
            if (tok == 39) continue;
            afterComma = false;
        }
        if (this.inPointcutDesignator) {
            this.endPointcutDesignator();
        }
        if (addReferencesForOrganizeImports) {
            this.addReferences();
        }
        if (isSimulateContextSwitchNecessary) {
            this.simulateContextSwitch(options.getCodeCompletePosition(), options.getTargetType());
        }
        this.applyReplacements();
        return this.replacements;
    }

    private boolean isDeclareAnnotationStart(int i) {
        if (this.content[i] != '@') {
            return false;
        }
        switch (this.content[++i]) {
            case 't': {
                return this.content.length >= i + "type".length() && this.content[++i] == 'y' && this.content[++i] == 'p' && this.content[++i] == 'e';
            }
            case 'f': {
                return this.content.length >= i + "field".length() && this.content[++i] == 'i' && this.content[++i] == 'e' && this.content[++i] == 'l' && this.content[++i] == 'd';
            }
            case 'm': {
                return this.content.length >= i + "method".length() && this.content[++i] == 'e' && this.content[++i] == 't' && this.content[++i] == 'h' && this.content[++i] == 'o' && this.content[++i] == 'd';
            }
            case 'c': {
                return this.content.length >= i + "constructor".length() && this.content[++i] == 'o' && this.content[++i] == 'n' && this.content[++i] == 's' && this.content[++i] == 't' && this.content[++i] == 'r' && this.content[++i] == 'u' && this.content[++i] == 'c' && this.content[++i] == 't' && this.content[++i] == 'o' && this.content[++i] == 'r';
            }
        }
        return false;
    }

    private void storeTypeParameters(char[] typeName) {
        IType type;
        if (this.unit != null && typeName != null && typeName.length > 0 && (type = this.getHandle(String.valueOf(typeName))).exists() && type instanceof AspectElement) {
            try {
                ITypeParameter[] typeParameters = type.getTypeParameters();
                if (typeParameters != null && typeParameters.length > 0) {
                    if (this.knownTypeParameters == null) {
                        this.knownTypeParameters = new HashSet<String>();
                    }
                    ITypeParameter[] iTypeParameterArray = typeParameters;
                    int n = typeParameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypeParameter parameter = iTypeParameterArray[n2];
                        this.knownTypeParameters.add(parameter.getElementName());
                        ++n2;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private boolean tokenLooksLikeTypeName(int token, char[] text) {
        return token == 12 && text != null && text.length > 0 && Character.isUpperCase(text[0]);
    }

    public char[] createImplementExtendsITDs(char[] typeName) {
        IType type;
        if (this.unit != null && typeName != null && typeName.length > 0 && (type = this.getHandle(String.valueOf(typeName))).exists()) {
            List<String>[] declares = this.getDeclareExtendsImplements(type);
            if (declares[0].size() == 0 && declares[1].size() == 0) {
                return null;
            }
            try {
                StringBuffer sb = new StringBuffer();
                sb.append(type.isInterface() ? "interface " : "class ");
                sb.append(typeName);
                ITypeParameter[] tParams = type.getTypeParameters();
                if (tParams != null && tParams.length > 0) {
                    sb.append(" <");
                    int i = 0;
                    while (i < tParams.length) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(tParams[i].getSource());
                        ++i;
                    }
                    sb.append("> ");
                }
                List<String> declareExtends = declares[0];
                List<String> declareImplements = declares[1];
                if (type.isClass()) {
                    String superClass = type.getSuperclassName();
                    if (declareExtends.size() > 0) {
                        superClass = declareExtends.get(0);
                        superClass = superClass.replace('$', '.');
                    }
                    if (superClass != null) {
                        sb.append(" extends " + superClass);
                    }
                }
                String[] superInterfaces = type.getSuperInterfaceNames();
                List<String> interfaceParents = type.isClass() ? declareImplements : declareExtends;
                int i = 0;
                while (i < superInterfaces.length) {
                    interfaceParents.add(superInterfaces[i]);
                    ++i;
                }
                if (interfaceParents.size() > 0) {
                    if (type.isClass()) {
                        sb.append(" implements");
                    } else {
                        sb.append(" extends");
                    }
                    Iterator<String> interfaceIter = interfaceParents.iterator();
                    while (interfaceIter.hasNext()) {
                        String interName = interfaceIter.next();
                        interName = interName.replace('$', '.');
                        sb.append(" " + interName);
                        if (!interfaceIter.hasNext()) continue;
                        sb.append(",");
                    }
                }
                sb.append(" ");
                return sb.toString().toCharArray();
            }
            catch (JavaModelException e) {
                AspectJPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ajdt.core", e.getMessage(), (Throwable)e));
                return null;
            }
        }
        return null;
    }

    private IType getHandle(String typeName) {
        try {
            IType type = this.getHandleFromChild(typeName, (IParent)this.unit);
            if (type != null) {
                return type;
            }
        }
        catch (JavaModelException javaModelException) {}
        return this.unit.getType(new String(typeName));
    }

    private IType getHandleFromChild(String typeName, IParent parent) throws JavaModelException {
        IJavaElement[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getElementType() == 7 && typeName.equals(children[i].getElementName())) {
                return (IType)children[i];
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            IType type;
            if (children[i].getElementType() == 7 && (type = this.getHandleFromChild(typeName, (IParent)children[i])) != null) {
                return type;
            }
            ++i;
        }
        return null;
    }

    protected List<String>[] getDeclareExtendsImplements(IType type) {
        AJProjectModelFacade model;
        ArrayList<String> declareExtends = new ArrayList<String>();
        ArrayList<String> declareImplements = new ArrayList<String>();
        if (type != null && type.exists() && (model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)type)).hasModel()) {
            List<IJavaElement> rels = model.getRelationshipsForElement((IJavaElement)type, AJRelationshipManager.ASPECT_DECLARATIONS);
            for (IJavaElement je : rels) {
                Map parents;
                IProgramElement pe = model.javaElementToProgramElement(je);
                List parentTypes = null;
                if (pe.getKind() == IProgramElement.Kind.DECLARE_PARENTS) {
                    parentTypes = pe.getParentTypes();
                } else if (pe.getKind() == IProgramElement.Kind.ASPECT && (parents = pe.getDeclareParentsMap()) != null) {
                    parentTypes = (List)parents.get(type.getFullyQualifiedName());
                }
                if (parentTypes == null) continue;
                IJavaProject project = type.getJavaProject();
                for (String parentType : parentTypes) {
                    boolean typeIsClass;
                    boolean parentIsClass;
                    IType parentTypeElt;
                    try {
                        parentTypeElt = project.findType(parentType);
                    }
                    catch (JavaModelException javaModelException) {
                        parentTypeElt = null;
                    }
                    try {
                        parentIsClass = parentTypeElt == null || parentTypeElt.isClass();
                        typeIsClass = type.isClass();
                    }
                    catch (JavaModelException javaModelException) {
                        parentIsClass = true;
                        typeIsClass = true;
                    }
                    if (parentIsClass && typeIsClass) {
                        declareExtends.add(parentType);
                        continue;
                    }
                    if (!parentIsClass && typeIsClass) {
                        declareImplements.add(parentType);
                        continue;
                    }
                    if (!parentIsClass && !typeIsClass) {
                        declareExtends.add(parentType);
                        continue;
                    }
                    if (!parentIsClass || typeIsClass) continue;
                    declareExtends.add(parentType);
                }
            }
        }
        return new List[]{declareExtends, declareImplements};
    }

    protected char[] getInterTypeDecls(char[] currentTypeName) {
        IType type;
        AJProjectModelFacade model;
        if (this.unit != null && currentTypeName != null && currentTypeName.length > 0 && (model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)this.unit)).hasModel() && (type = this.getHandle(new String(currentTypeName))).exists()) {
            List<IJavaElement> rels = model.getRelationshipsForElement((IJavaElement)type, AJRelationshipManager.ASPECT_DECLARATIONS);
            StringBuffer sb = new StringBuffer("\n\t");
            for (IJavaElement je : rels) {
                IProgramElement declareElt = model.javaElementToProgramElement(je);
                if (declareElt != null && declareElt.getParent() != null && declareElt.getKind().isInterTypeMember()) {
                    int lastDot = declareElt.getName().lastIndexOf(46);
                    String name = declareElt.getName().substring(lastDot + 1);
                    if (declareElt.getKind() == IProgramElement.Kind.INTER_TYPE_FIELD) {
                        this.createITDFieldText(sb, declareElt, name);
                        continue;
                    }
                    if (declareElt.getKind() != IProgramElement.Kind.INTER_TYPE_METHOD && declareElt.getKind() != IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) continue;
                    this.createITDMethodText(currentTypeName, sb, declareElt, name);
                    continue;
                }
                if (declareElt.getKind() != IProgramElement.Kind.CLASS) continue;
                this.createITITText(sb, declareElt);
            }
            return sb.toString().toCharArray();
        }
        return new char[0];
    }

    protected void createITITText(StringBuffer sb, IProgramElement declareElt) {
        sb.append("\n\tstatic class ").append(declareElt.getName()).append(" {\n");
        List children = declareElt.getChildren();
        for (IProgramElement child : children) {
            sb.append("\t\tpublic static ");
            sb.append(String.valueOf(child.getCorrespondingType(true)) + " ");
            sb.append(child.getName());
            if (child.getKind() == IProgramElement.Kind.FIELD) {
                sb.append(";\n");
                continue;
            }
            sb.append("(");
            List names = child.getParameterNames();
            List types = child.getParameterTypes();
            if (types != null && names != null) {
                Iterator typeIter = types.iterator();
                Iterator nameIter = names.iterator();
                while (typeIter.hasNext()) {
                    String paramType = String.valueOf((char[])typeIter.next());
                    String paramName = (String)nameIter.next();
                    sb.append(String.valueOf(paramType) + " " + paramName);
                    if (!typeIter.hasNext()) continue;
                    sb.append(", ");
                }
            }
            sb.append(") { }\n");
        }
        sb.append("\t}\n");
    }

    protected void createITDMethodText(char[] currentTypeName, StringBuffer sb, IProgramElement declareElt, String name) {
        sb.append(this.getAccessibilityString(declareElt));
        for (IProgramElement.Modifiers modifier : declareElt.getModifiers()) {
            sb.append(modifier + " ");
        }
        if (declareElt.getKind() == IProgramElement.Kind.INTER_TYPE_METHOD) {
            sb.append(String.valueOf(declareElt.getCorrespondingType(true)) + " " + name);
        } else {
            sb.append(currentTypeName);
        }
        sb.append("(");
        List names = declareElt.getParameterNames();
        List types = declareElt.getParameterTypes();
        if (types != null && names != null) {
            Iterator typeIter = types.iterator();
            Iterator nameIter = names.iterator();
            while (typeIter.hasNext()) {
                String paramType = String.valueOf((char[])typeIter.next());
                String paramName = (String)nameIter.next();
                sb.append(String.valueOf(paramType) + " " + paramName);
                if (!typeIter.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(") { }\n");
    }

    protected void createITDFieldText(StringBuffer sb, IProgramElement declareElt, String name) {
        for (IProgramElement.Modifiers modifier : declareElt.getModifiers()) {
            sb.append(modifier + " ");
        }
        sb.append(String.valueOf(declareElt.getCorrespondingType(true)) + " " + name + ";\n\t");
    }

    private String getAccessibilityString(IProgramElement declareElt) {
        return String.valueOf(declareElt.getAccessibility() != IProgramElement.Accessibility.PACKAGE ? declareElt.getAccessibility().toString() : "") + " ";
    }

    private boolean inTypeDeclaration() {
        return this.inAspectDeclaration || this.inClassDeclaration || this.inInterfaceDeclaration || this.inEnumDeclaration;
    }

    private void simulateContextSwitch(int position, char[] targetType) {
        int pos = this.findInsertionPosition(position - 1) + 1;
        int len = 0;
        boolean dotRequired = true;
        if (this.content[pos] == 't' && this.content[pos + 1] == 'h' && this.content[pos + 2] == 'i' && this.content[pos + 3] == 's' && !Character.isJavaIdentifierPart(this.content[pos + 4])) {
            len = 4;
            dotRequired = false;
        }
        String contextSwitchIdentifier = this.findFreeIdentifier();
        char[] toInsert = (String.valueOf(new String(targetType)) + ' ' + contextSwitchIdentifier + "; " + contextSwitchIdentifier + (dotRequired ? "." : "")).toCharArray();
        this.addReplacement(pos, len, toInsert);
    }

    private String findFreeIdentifier() {
        int i = 0;
        String ident = ITD_INSERTED_IDENTIFIER + i;
        while (this.usedIdentifiers.contains(ident)) {
            ident = ITD_INSERTED_IDENTIFIER + ++i;
        }
        this.usedIdentifiers.add(ident);
        return ident;
    }

    private int findInsertionPosition(int pos) {
        char ch = this.content[pos];
        int currentPos = pos--;
        if (Character.isWhitespace(ch)) {
            currentPos = this.findPreviousNonSpace(pos);
            if (currentPos == -1) {
                return pos;
            }
            ch = this.content[currentPos];
            if (ch == '.') {
                return this.findInsertionPosition(--currentPos);
            }
            return pos;
        }
        if (Character.isJavaIdentifierPart(ch)) {
            while (Character.isJavaIdentifierPart(ch)) {
                ch = this.content[--currentPos];
            }
            return this.findInsertionPosition(currentPos);
        }
        if (ch == '.') {
            return this.findInsertionPosition(pos);
        }
        if (ch == ')') {
            --currentPos;
            int bracketCounter = 1;
            while (currentPos >= 0) {
                ch = this.content[currentPos];
                if (bracketCounter == 0) break;
                if (ch == ')') {
                    ++bracketCounter;
                }
                if (ch == '(' && --bracketCounter < 0) {
                    return -1;
                }
                --currentPos;
            }
            return this.findInsertionPosition(currentPos);
        }
        return pos;
    }

    private void applyReplacements() {
        ListIterator<Replacement> iter = this.replacements.listIterator();
        int offset = 0;
        while (iter.hasNext()) {
            Replacement ins = (Replacement)iter.next();
            ins.posAfter = ins.posBefore + offset;
            this.replace(ins.posAfter, ins.length, ins.text);
            offset += ins.lengthAdded;
        }
    }

    private void replace(int pos, int origLength, char[] text) {
        if (origLength != text.length) {
            int lengthDiff = text.length - origLength;
            int oldEnd = pos + origLength;
            int newEnd = pos + text.length;
            char[] temp = new char[this.content.length + lengthDiff];
            System.arraycopy(this.content, 0, temp, 0, pos);
            System.arraycopy(this.content, oldEnd, temp, newEnd, this.content.length - oldEnd);
            this.content = temp;
        }
        System.arraycopy(text, 0, this.content, pos, text.length);
    }

    private void startPointcutDesignator() {
        if (this.inPointcutDesignator) {
            return;
        }
        this.inPointcutDesignator = true;
        this.posColon = this.scanner.getCurrentTokenStartPosition();
    }

    private void endPointcutDesignator() {
        this.inPointcutDesignator = false;
        if (this.options.isKeepPointcuts()) {
            this.addReplacement(this.posColon, 1, new char[]{'{'});
        } else {
            int posSemi = this.scanner.getCurrentTokenStartPosition();
            int len = posSemi - this.posColon;
            char[] empty = new char[len];
            int i = 0;
            while (i < empty.length) {
                empty[i] = 32;
                ++i;
            }
            this.addReplacement(this.posColon, len, empty);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processPotentialIntertypeDeclaration() {
        iter = pos = this.scanner.getCurrentTokenStartPosition();
        --iter;
        while (iter >= 0) {
            if (this.content[iter] == '>') {
                genericsDepth = 1;
                --iter;
                while (iter >= 0 && genericsDepth > 0) {
                    if (this.content[iter] == '>') {
                        ++genericsDepth;
                    } else if (this.content[iter] == '<') {
                        --genericsDepth;
                    }
                    --iter;
                }
            } else if (this.content[iter] == '<') {
                return;
            }
            if (Character.isWhitespace(this.content[iter])) {
                --iter;
                continue;
            }
            if (Character.isJavaIdentifierPart(this.content[iter])) break;
            return;
        }
        if (iter >= 0) ** GOTO lbl27
        return;
        while (Character.isJavaIdentifierPart(this.content[iter])) {
            --iter;
lbl27:
            // 2 sources

            if (iter >= 0) continue;
        }
        if (iter < 0 || !Character.isUpperCase(this.content[iter + 1])) {
            return;
        }
        nameStart = iter + 1;
        block3: while (true) {
            if (iter >= 0) {
                if (Character.isWhitespace(this.content[iter])) {
                    --iter;
                    continue;
                }
                if (this.content[iter] != '.') break;
                nameStart = iter;
            }
            --iter;
            while (iter >= 0) {
                if (Character.isWhitespace(this.content[iter])) {
                    --iter;
                    continue;
                }
                if (!Character.isJavaIdentifierPart(this.content[iter])) break block3;
                nameStart = iter;
                break;
            }
            --iter;
            while (true) {
                if (iter < 0) continue block3;
                if (!Character.isJavaIdentifierPart(this.content[iter])) break;
                --iter;
            }
            nameStart = iter + 1;
        }
        nameEnd = pos + 1;
        while (nameEnd < this.content.length) {
            if (!Character.isWhitespace(this.content[nameEnd])) break;
            ++nameEnd;
        }
        itdName = new char[nameEnd - nameStart];
        System.arraycopy(this.content, nameStart, itdName, 0, itdName.length);
        splits = CharOperation.splitOn((char)'.', (char[])itdName);
        if (splits.length == 2) {
            this.typeReferences.add(String.valueOf(splits[0]));
        }
        i = 0;
        while (i < itdName.length) {
            if (!Character.isJavaIdentifierPart(itdName[i])) {
                itdName[i] = 36;
            }
            ++i;
        }
        if (this.options.isAddAjcTagToIntertypesEnabled()) {
            this.addReplacement(nameStart, 0, "ajc$".toCharArray());
        }
        this.addReplacement(nameStart, itdName.length, itdName);
    }

    private boolean hasWordAtPosition(String string, int pos) {
        char[] word = string.toCharArray();
        int i = 0;
        while (i < word.length) {
            if (word[i] != this.content[pos + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int findPrevious(char ch, int pos) {
        while (pos >= 0) {
            if (this.content[pos] == ch) {
                return pos;
            }
            --pos;
        }
        return -1;
    }

    public int findPreviousWhitespaceOr(char ch, int pos) {
        while (pos >= 0) {
            if (this.content[pos] == ch || Character.isWhitespace(this.content[pos])) {
                return pos;
            }
            --pos;
        }
        return -1;
    }

    public int findPrevious(char[] chs, int pos) {
        while (pos >= 0) {
            int i = 0;
            while (i < chs.length) {
                if (this.content[pos] == chs[i]) {
                    return pos;
                }
                ++i;
            }
            --pos;
        }
        return -1;
    }

    public int findPreviousSpace(int pos) {
        while (pos >= 0) {
            if (Character.isWhitespace(this.content[pos])) {
                return pos;
            }
            --pos;
        }
        return -1;
    }

    public int findPreviousNonSpace(int pos) {
        while (pos >= 0) {
            if (!Character.isWhitespace(this.content[pos])) {
                return pos;
            }
            --pos;
        }
        return -1;
    }

    public int findNextNonSpace(int pos) {
        while (pos < this.content.length) {
            if (!Character.isWhitespace(this.content[pos])) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public int findNext(char[] chs, int pos) {
        while (pos < this.content.length) {
            int i = 0;
            while (i < chs.length) {
                if (this.content[pos] == chs[i]) {
                    return pos;
                }
                ++i;
            }
            ++pos;
        }
        return -1;
    }

    private void consumeRetOrThrow() {
        int pos = this.scanner.getCurrentTokenStartPosition();
        char[] content = this.scanner.source;
        int end = this.findNext(endThrow, pos);
        if (end == -1) {
            return;
        }
        char[] temp = null;
        if (content[end] == endThrow[0]) {
            if ((pos = this.findPrevious(')', pos)) == -1) {
                return;
            }
            int advicebracket = this.findPrevious('(', pos);
            if (advicebracket == -1) {
                return;
            }
            temp = new char[end - pos + 1];
            temp[0] = this.bracketsContainSomething(advicebracket) && this.bracketsContainSomething(end) ? 44 : 32;
            int i = 1;
            while (i < temp.length) {
                temp[i] = 32;
                ++i;
            }
        } else {
            temp = new char[end - pos];
            int i = 0;
            while (i < temp.length) {
                temp[i] = 32;
                ++i;
            }
        }
        this.addReplacement(pos, temp.length, temp);
    }

    private boolean bracketsContainSomething(int start) {
        while (++start < this.content.length) {
            if (this.content[start] == ')') {
                return false;
            }
            if (!Character.isJavaIdentifierPart(this.content[start])) continue;
            return true;
        }
        return false;
    }

    private int findLast(char ch) {
        int pos = this.content.length;
        while (--pos >= 0) {
            if (this.content[pos] == ch) break;
        }
        return pos;
    }

    private void addReferences() {
        if (this.typeReferences == null) {
            return;
        }
        int pos = this.findLast('}');
        if (pos < 0) {
            return;
        }
        StringBuffer temp = new StringBuffer(this.typeReferences.size() * 10);
        for (String ref : this.typeReferences) {
            if (this.knownTypeParameters != null && this.knownTypeParameters.contains(ref)) continue;
            temp.append(ref).append(" ").append(this.findFreeIdentifier());
            temp.append(";\n");
        }
        char[] decls = new char[temp.length()];
        temp.getChars(0, decls.length, decls, 0);
        this.addReplacement(pos, 0, decls);
    }

    private void addReplacement(int pos, int length, char[] text) {
        int last = this.replacements.size() - 1;
        while (last >= 0) {
            if (this.replacements.get((int)last).posBefore < pos) break;
            --last;
        }
        this.replacements.add(last + 1, new Replacement(pos, length, text));
    }

    public static boolean conflictsWithAJEdit(int offset, int length, ArrayList<Replacement> replacements) {
        int i = 0;
        while (i < replacements.size()) {
            Replacement ins = replacements.get(i);
            if (offset >= ins.posAfter && offset < ins.posAfter + ins.length) {
                return true;
            }
            if (offset < ins.posAfter && offset + length > ins.posAfter) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int translatePositionToBeforeChanges(int posAfter, ArrayList<Replacement> replacements) {
        Replacement ins;
        int offset = 0;
        int i = 0;
        while (i < replacements.size()) {
            ins = replacements.get(i);
            if (ins.posAfter > posAfter) break;
            offset += ins.lengthAdded;
            ++i;
        }
        if (i > 0) {
            int diff;
            ins = replacements.get(i - 1);
            if (ins.posAfter + ins.text.length > posAfter && (diff = posAfter - ins.posAfter) > ins.length) {
                offset += diff - ins.length;
            }
        }
        return Math.max(posAfter - offset, 0);
    }

    public static int translatePositionToAfterChanges(int posBefore, ArrayList<Replacement> replacements) {
        int i = 0;
        while (i < replacements.size()) {
            Replacement ins = replacements.get(i);
            if (ins.posAfter <= posBefore) {
                posBefore += ins.lengthAdded;
            } else {
                return posBefore;
            }
            ++i;
        }
        return posBefore;
    }

    public static class Replacement {
        public int posBefore;
        public int posAfter;
        public int length;
        public char[] text;
        public int lengthAdded;

        public Replacement(int pos, int length, char[] text) {
            this.posBefore = pos;
            this.posAfter = -1;
            this.length = length;
            this.text = text;
            this.lengthAdded = text.length - length;
        }
    }
}

