/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.refactoring.pullout;

import java.util.Arrays;
import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.CUPositionCompletionProcessor;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;

public class AspectInputContentAssistProcessor
extends CUPositionCompletionProcessor {
    public static final String DUMMY_CLASS_NAME = "$$__$$";
    public static final String DUMMY_CU_NAME = "$$__$$.java";
    private static TypeCompletionRequestor requestor;
    private IJavaProject javaProject;

    public AspectInputContentAssistProcessor(IJavaProject project) throws JavaModelException {
        requestor = new TypeCompletionRequestor(false, false, true);
        super((CUPositionCompletionProcessor.CUPositionCompletionRequestor)requestor);
        requestor.setProject(project);
        this.setPackageFragment(project.getPackageFragmentRoots()[0].getPackageFragment(""));
        this.javaProject = project;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public void setPackageFragment(IPackageFragment packageFragment) {
        if (packageFragment == null) {
            this.setCompletionContext(null, null, null);
        } else {
            String before = "public class $$__$$ { ";
            String after = " }";
            this.setCompletionContext(packageFragment.getCompilationUnit(DUMMY_CU_NAME), before, after);
        }
    }

    public void setExtendsCompletionContext(IJavaElement javaElement) {
        if (javaElement instanceof IPackageFragment) {
            IPackageFragment packageFragment = (IPackageFragment)javaElement;
            ICompilationUnit cu = packageFragment.getCompilationUnit(DUMMY_CU_NAME);
            this.setCompletionContext(cu, "public class $$__$$ extends ", " {}");
        } else if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            String before = "public class " + type.getElementName() + " extends ";
            String after = " {}";
            IJavaElement parent = type.getParent();
            while (parent instanceof IType) {
                type = (IType)parent;
                before = String.valueOf(before) + "public class " + type.getElementName() + " {";
                after = String.valueOf(after) + "}";
                parent = type.getParent();
            }
            ICompilationUnit cu = type.getCompilationUnit();
            this.setCompletionContext(cu, before, after);
        } else {
            this.setCompletionContext(null, null, null);
        }
    }

    protected static class TypeCompletionRequestor
    extends CUPositionCompletionProcessor.CUPositionCompletionRequestor {
        private static final String VOID = "void";
        private static final List BASE_TYPES;
        private boolean fEnableBaseTypes;
        private boolean fEnableVoid;
        private final boolean fFullyQualify;
        private IJavaProject javaProject;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

        static {
            TypeCompletionRequestor.ajc$preClinit();
            BASE_TYPES = Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short");
        }

        public TypeCompletionRequestor(boolean enableBaseTypes, boolean enableVoid, boolean fullyQualify) {
            this.fFullyQualify = fullyQualify;
            this.fEnableBaseTypes = enableBaseTypes;
            this.fEnableVoid = enableVoid;
            this.setIgnored(1, true);
            this.setIgnored(27, true);
            this.setIgnored(2, true);
            this.setIgnored(25, true);
            this.setIgnored(4, true);
            this.setIgnored(5, true);
            this.setIgnored(7, true);
            this.setIgnored(6, true);
            this.setIgnored(26, true);
            this.setIgnored(24, true);
            this.setIgnored(10, true);
            this.setIgnored(11, true);
            this.setIgnored(12, true);
        }

        public void setProject(IJavaProject project) {
            this.javaProject = project;
        }

        public void accept(CompletionProposal proposal) {
            switch (proposal.getKind()) {
                case 8: {
                    char[] packageName = proposal.getDeclarationSignature();
                    if (TypeFilter.isFiltered((char[])packageName)) {
                        return;
                    }
                    this.addAdjustedCompletion(new String(packageName), new String(proposal.getCompletion()), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance(), JavaPluginImages.DESC_OBJS_PACKAGE);
                    return;
                }
                case 9: {
                    ImageDescriptor typeImageDescriptor;
                    char[] signature = proposal.getSignature();
                    char[] fullName = org.eclipse.jdt.core.Signature.toCharArray((char[])signature);
                    if (TypeFilter.isFiltered((char[])fullName)) {
                        return;
                    }
                    try {
                        IType type = this.javaProject.findType(new String(proposal.getCompletion()));
                        if (!(type instanceof AspectElement)) {
                            return;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                        return;
                    }
                    StringBuffer buf = new StringBuffer();
                    buf.append(org.eclipse.jdt.core.Signature.getSimpleName((char[])fullName));
                    if (buf.length() == 0) {
                        return;
                    }
                    char[] typeQualifier = org.eclipse.jdt.core.Signature.getQualifier((char[])fullName);
                    if (typeQualifier.length > 0) {
                        buf.append(JavaElementLabels.CONCAT_STRING);
                        buf.append(typeQualifier);
                    }
                    String name = buf.toString();
                    boolean fullyQualify = this.fFullyQualify && CharOperation.equals((char[])proposal.getDeclarationSignature(), (char[])typeQualifier);
                    switch (org.eclipse.jdt.core.Signature.getTypeSignatureKind((char[])signature)) {
                        case 3: {
                            typeImageDescriptor = JavaPluginImages.DESC_OBJS_TYPEVARIABLE;
                            break;
                        }
                        case 1: {
                            typeImageDescriptor = AspectJImages.instance().getIcon(IProgramElement.Kind.ASPECT).getImageDescriptor();
                            break;
                        }
                        default: {
                            typeImageDescriptor = null;
                        }
                    }
                    this.addAdjustedTypeCompletion(name, new String(proposal.getCompletion()), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance(), typeImageDescriptor, fullyQualify ? new String(fullName) : null);
                    return;
                }
                case 3: {
                    if (!this.fEnableBaseTypes) {
                        return;
                    }
                    String keyword = new String(proposal.getName());
                    if (this.fEnableVoid && VOID.equals(keyword) || this.fEnableBaseTypes && BASE_TYPES.contains(keyword)) {
                        this.addAdjustedCompletion(keyword, new String(proposal.getCompletion()), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance(), null);
                    }
                    return;
                }
            }
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("AspectInputContentAssistProcessor.java", TypeCompletionRequestor.class);
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.AspectInputContentAssistProcessor$TypeCompletionRequestor", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 168);
            ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "accept", "org.eclipse.ajdt.internal.ui.refactoring.pullout.AspectInputContentAssistProcessor$TypeCompletionRequestor", "org.eclipse.jdt.core.CompletionProposal", "proposal", "", VOID), 143);
        }
    }
}

