/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.builder.AJBuildJob;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class AspectJProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    protected NewJavaProjectWizardPageOne fFirstPage;
    protected NewJavaProjectWizardPageTwo fSecondPage;
    private IConfigurationElement fConfigElement;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public AspectJProjectWizard() {
        this.setDefaultPageImageDescriptor(AspectJImages.W_NEW_AJ_PRJ.getImageDescriptor());
        this.setDialogSettings(AspectJUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(UIMessages.NewAspectjProjectCreationWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new NewJavaProjectWizardPageOne();
        this.addPage((IWizardPage)this.fFirstPage);
        this.fFirstPage.setTitle(UIMessages.NewAspectJProject_CreateAnAspectJProject);
        this.fFirstPage.setDescription(UIMessages.NewAspectJProject_CreateAnAspectJProjectDescription);
        this.fSecondPage = new NewJavaProjectWizardPageTwo(this.fFirstPage);
        this.fSecondPage.setTitle(UIMessages.NewAspectJProject_BuildSettings);
        this.fSecondPage.setDescription(UIMessages.NewAspectJProject_BuildSettingsDescription);
        this.addPage((IWizardPage)this.fSecondPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            boolean completed;
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            IProject project = this.fSecondPage.getJavaProject().getProject();
            this.selectAndReveal((IResource)project);
            res = completed = this.finalizeNewProject(project);
        }
        return res;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = NewWizardMessages.JavaProjectWizard_op_error_title;
        String message = NewWizardMessages.JavaProjectWizard_op_error_create_message;
        ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
    }

    private boolean finalizeNewProject(IProject project) {
        IProject thisProject = project;
        try {
            AJDTUtils.addAspectJNature(project, true);
            AJBuildJob job = new AJBuildJob(project, 6);
            job.schedule();
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        project = thisProject;
        this.selectAndReveal((IResource)project);
        AJLog.log((String)("New project created: " + project.getName()));
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public IJavaElement getCreatedElement() {
        return this.fSecondPage.getJavaProject();
    }

    static {
        AspectJProjectWizard.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AspectJProjectWizard.java", AspectJProjectWizard.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.AspectJProjectWizard", "org.eclipse.core.runtime.CoreException", "<missing>"), 119);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "finalizeNewProject", "org.eclipse.ajdt.internal.ui.wizards.AspectJProjectWizard", "org.eclipse.core.resources.IProject", "project", "", "boolean"), 106);
    }
}

