/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.jsoncdb.freescale.internal.builtins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.jsoncdb.core.IParserPreferences;
import org.eclipse.cdt.jsoncdb.core.IParserPreferencesAccess;
import org.eclipse.cdt.jsoncdb.core.participant.IRawSourceFileInfo;
import org.eclipse.cdt.jsoncdb.core.participant.IRawSourceFileInfoCollector;
import org.eclipse.cdt.jsoncdb.core.participant.builtins.IBuiltinsOutputProcessor;
import org.eclipse.cdt.jsoncdb.core.participant.builtins.OutputSniffer;
import org.eclipse.cdt.jsoncdb.freescale.internal.Plugin;
import org.eclipse.cdt.jsoncdb.freescale.internal.builtins.Messages;
import org.eclipse.cdt.jsoncdb.freescale.internal.builtins.RawSourceFileInfo;
import org.eclipse.cdt.jsoncdb.freescale.participant.builtins.IBuiltinsDetectionBehaviorFilebased;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class FreescaleBuiltinsDetector {
    public static final String MARKER_ID = "org.eclipse.cdt.jsoncdb.freescaleFreescaleBuiltinsDetectorMarker";
    private final String sourceFileExtension;
    private final String command;
    private final List<String> builtinsDetectionArgs;
    private final IBuiltinsDetectionBehaviorFilebased builtinsDetectionBehavior;
    private IProject project;
    private java.nio.file.Path buildDirectory;

    public FreescaleBuiltinsDetector(IBuiltinsDetectionBehaviorFilebased builtinsDetectionBehavior, String command, List<String> builtinsDetectionArgs, String sourceFileExtension) {
        this.sourceFileExtension = Objects.requireNonNull(sourceFileExtension, "sourceFileExtension");
        this.builtinsDetectionBehavior = Objects.requireNonNull(builtinsDetectionBehavior, "builtinsDetectionBehavior");
        this.command = Objects.requireNonNull(command, "command");
        this.builtinsDetectionArgs = Objects.requireNonNull(builtinsDetectionArgs, "builtinsDetectionArgs");
    }

    public IRawSourceFileInfo detectBuiltins(IProject project, java.nio.file.Path buildDirectory, ICommandLauncher launcher, IConsole console, IProgressMonitor monitor) throws CoreException {
        this.project = Objects.requireNonNull(project, "project");
        this.buildDirectory = Objects.requireNonNull(buildDirectory, "buildDirectory");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        RawSourceFileInfo result = new RawSourceFileInfo();
        List<String> argList = this.getCompilerArguments();
        argList.addAll(this.builtinsDetectionArgs);
        console = this.startOutputConsole(console);
        launcher.setProject(project);
        launcher.showCommand(console != null);
        Process proc = launcher.execute((IPath)new Path(this.command), argList.toArray(new String[argList.size()]), this.getEnvp(), (IPath)new Path(this.buildDirectory.toString()), monitor);
        if (proc != null) {
            String errMsg2;
            try {
                proc.getInputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IBuiltinsOutputProcessor bopOut = this.builtinsDetectionBehavior.createCompilerOutputProcessor();
            IBuiltinsOutputProcessor bopErr = this.builtinsDetectionBehavior.createCompilerOutputProcessor();
            long start = System.currentTimeMillis();
            int state = launcher.waitAndRead((OutputStream)new OutputSniffer(bopOut, (OutputStream)(console == null ? null : console.getOutputStream()), (IRawSourceFileInfoCollector)result), (OutputStream)new OutputSniffer(bopErr, (OutputStream)(console == null ? null : console.getErrorStream()), (IRawSourceFileInfoCollector)result), monitor);
            IBuiltinsOutputProcessor bopFile = this.builtinsDetectionBehavior.createCompilerOutputProcessor();
            try {
                File file = this.builtinsDetectionBehavior.getFile();
                if (file.isFile()) {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(file.getAbsolutePath()));
                    while ((line = reader.readLine()) != null) {
                        bopFile.processLine(line, (IRawSourceFileInfoCollector)result);
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                errMsg2 = String.format(Messages.CompilerBuiltinsDetector_errmsg_file_parsing_failed, e.getMessage());
                this.createMarker(errMsg2);
            }
            if (console != null) {
                ConsoleOutputStream cis = console.getInfoStream();
                try {
                    cis.write(String.format(Messages.CompilerBuiltinsDetector_msg_detection_finished, System.currentTimeMillis() - start).getBytes());
                    cis.write("\n".getBytes());
                }
                catch (IOException errMsg2) {
                    // empty catch block
                }
            }
            if (state != 1) {
                try {
                    int exitValue = proc.exitValue();
                    if (exitValue != 0 && !this.builtinsDetectionBehavior.suppressErrormessage()) {
                        errMsg2 = String.format(Messages.CompilerBuiltinsDetector_errmsg_command_failed, this.command, exitValue);
                        this.createMarker(errMsg2);
                    }
                }
                catch (IllegalThreadStateException e) {
                    String warnMsg = String.format(Messages.CompilerBuiltinsDetector_msg_unexpectedly_still_running, this.command);
                    if (console != null) {
                        ConsoleOutputStream cis = console.getInfoStream();
                        try {
                            cis.write(warnMsg.getBytes());
                            cis.write("\n".getBytes());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.createMarker(warnMsg);
                    Plugin.getDefault().getLog().log((IStatus)Status.warning((String)warnMsg, (Throwable)e));
                }
            }
        } else {
            this.createMarker(launcher.getErrorMessage());
        }
        return result;
    }

    private List<String> getCompilerArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.builtinsDetectionBehavior.getBuiltinsOutputEnablingArgs());
        String inputFile = this.getInputFile();
        if (inputFile != null) {
            args.add(inputFile);
        }
        return args;
    }

    private String[] getEnvp() {
        String[] strings = new String[]{"LANGUAGE=en", "LC_ALL=C.UTF-8"};
        return strings;
    }

    private String getInputFile() {
        String specFileName = "detect_compiler_builtins." + this.sourceFileExtension;
        java.nio.file.Path specFile = this.buildDirectory.resolve(specFileName);
        if (!Files.exists(specFile, new LinkOption[0])) {
            try {
                Files.createDirectories(specFile.getParent(), new FileAttribute[0]);
                Files.createFile(specFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                Plugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.jsoncdb.freescale", "getInputFile()", (Throwable)e));
            }
        }
        return specFile.toString();
    }

    private void createMarker(String message) throws CoreException {
        IMarker marker = this.project.createMarker(MARKER_ID);
        marker.setAttribute("severity", 0);
        marker.setAttribute("message", (Object)message);
    }

    private IConsole startOutputConsole(IConsole console) throws CoreException {
        IParserPreferences prefs = ((IParserPreferencesAccess)EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext()).get(IParserPreferencesAccess.class)).getWorkspacePreferences();
        if (console != null && prefs.getAllocateConsole()) {
            console.start(this.project);
            try {
                ConsoleOutputStream cis = console.getInfoStream();
                String msg = String.format(Messages.CompilerBuiltinsDetector_msg_detection_start, SimpleDateFormat.getTimeInstance().format(new Date()), this.project.getName());
                cis.write(msg.getBytes());
                cis.write("\n".getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return console;
        }
        return null;
    }
}

