/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.llvm.dsf.lldb.core.internal.service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_4;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.llvm.dsf.lldb.core.internal.service.Messages;
import org.eclipse.core.runtime.CoreException;

public class LLDBProcesses
extends GDBProcesses_7_4 {
    private Map<Integer, String> fProcessNames = new HashMap<Integer, String>();

    public LLDBProcesses(DsfSession session) {
        super(session);
    }

    public void getRunningProcesses(IDMContext dmc, DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        IGDBBackend backend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        if (backend.getSessionType() == SessionType.LOCAL) {
            IProcessList list = null;
            try {
                list = CCorePlugin.getDefault().getProcessList();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (list == null) {
                this.fProcessNames.clear();
                rm.setData(null);
            } else {
                IProcessInfo[] procInfos;
                this.fProcessNames.clear();
                IProcessInfo[] iProcessInfoArray = procInfos = list.getProcessList();
                int n = procInfos.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcessInfo procInfo = iProcessInfoArray[n2];
                    this.fProcessNames.put(procInfo.getPid(), procInfo.getName());
                    ++n2;
                }
                rm.setData((Object)this.makeProcessDMCs(controlDmc, procInfos));
            }
            rm.done();
        } else {
            this.fProcessNames.clear();
            rm.setData((Object)new IProcesses.IProcessDMContext[0]);
            rm.done();
        }
    }

    private IProcesses.IProcessDMContext[] makeProcessDMCs(ICommandControlService.ICommandControlDMContext controlDmc, IProcessInfo[] processes) {
        IMIProcessDMContext[] procDmcs = new IMIProcessDMContext[processes.length];
        int i = 0;
        while (i < procDmcs.length) {
            procDmcs[i] = this.createProcessContext(controlDmc, Integer.toString(processes[i].getPid()));
            ++i;
        }
        return procDmcs;
    }

    public void getExecutionData(IProcesses.IThreadDMContext dmc, final DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (!(dmc instanceof IMIProcessDMContext)) {
            super.getExecutionData(dmc, rm);
            return;
        }
        final String pidStr = ((IMIProcessDMContext)dmc).getProcId();
        int pid = -1;
        try {
            pid = Integer.parseInt(pidStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        final int pid2 = pid;
        if (this.fProcessNames.isEmpty()) {
            this.getRunningProcesses((IDMContext)dmc, new DataRequestMonitor<IProcesses.IProcessDMContext[]>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)new LLDBMIThreadDMData(LLDBProcesses.this.getProcessName(pid2), pidStr));
                    super.handleSuccess();
                }
            });
        } else {
            rm.setData((Object)new LLDBMIThreadDMData(this.getProcessName(pid2), pidStr));
            rm.done();
        }
    }

    private String getProcessName(int pid) {
        String name = this.fProcessNames.get(pid);
        return name != null ? name : Messages.LLDBProcesses_unknown_process_name;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (e.getDMContext() instanceof IMIContainerDMContext && this.getNumConnected() == 0) {
            return;
        }
        super.eventDispatched(e);
    }

    private static class LLDBMIThreadDMData
    implements IProcesses.IThreadDMData {
        final String fName;
        final String fId;

        public LLDBMIThreadDMData(String name, String id) {
            this.fName = name;
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return true;
        }
    }
}

