/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IMultiDetach;
import org.eclipse.cdt.dsf.debug.service.IMultiTerminate;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.DebugNewProcessSequence_7_2;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_0;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_1;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.gdb.service.Messages;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadGroupAddedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIAddInferiorInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GDBProcesses_7_2
extends GDBProcesses_7_1
implements IMultiTerminate,
IMultiDetach {
    public static final String INITIAL_THREAD_GROUP_ID = "i1";
    protected static final String TRACE_VISUALIZATION_THREAD_ID = "1";
    private CommandFactory fCommandFactory;
    private IGDBControl fCommandControl;
    private IGDBBackend fBackend;
    private boolean fNeedToReconnect;
    private Set<IRunControl.IContainerDMContext> fProcRestarting = new HashSet<IRunControl.IContainerDMContext>();
    private boolean fTraceVisualization;

    public GDBProcesses_7_2(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBProcesses_7_2.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{IMultiDetach.class.getName(), IMultiTerminate.class.getName()}, new Hashtable());
        this.fCommandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        IMIContainerDMContext initialContainer = this.createContainerContextFromGroupId(this.fCommandControl.getContext(), INITIAL_THREAD_GROUP_ID);
        this.getSession().dispatchEvent((Object)new ContainerCreatedDMEvent(initialContainer), this.getProperties());
        requestMonitor.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        super.shutdown(requestMonitor);
    }

    protected boolean getTraceVisualization() {
        return this.fTraceVisualization;
    }

    protected void setTraceVisualization(boolean visualizing) {
        this.fTraceVisualization = visualizing;
    }

    @Override
    public IMIContainerDMContext createContainerContextFromGroupId(ICommandControlService.ICommandControlDMContext controlDmc, String groupId) {
        String pid = this.getGroupToPidMap().get(groupId);
        if (pid == null) {
            pid = "";
        }
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(controlDmc, pid);
        return this.createContainerContext(processDmc, groupId);
    }

    @Override
    protected boolean doIsDebuggerAttachSupported() {
        if (this.fBackend.getSessionType() == SessionType.CORE) {
            return false;
        }
        if (this.fBackend.getSessionType() == SessionType.REMOTE && !this.fBackend.getIsAttachSession()) {
            return false;
        }
        IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
        if (runControl != null && runControl.getRunMode() == IMIRunControl.MIRunMode.ALL_STOP) {
            return this.getNumConnected() == 0;
        }
        return true;
    }

    @Override
    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, DataRequestMonitor<IDMContext> rm) {
        this.attachDebuggerToProcess(procCtx, null, rm);
    }

    @Override
    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, String binaryPath, DataRequestMonitor<IDMContext> dataRm) {
        if (procCtx instanceof IMIProcessDMContext) {
            if (!this.doIsDebuggerAttachSupported()) {
                dataRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Attach not supported.", null));
                dataRm.done();
                return;
            }
            ImmediateExecutor.getInstance().execute((Runnable)new Sequence(this.getExecutor(), (RequestMonitor)dataRm, binaryPath, procCtx, (DataRequestMonitor)dataRm){
                private IMIContainerDMContext fContainerDmc;
                private Sequence.Step[] steps;
                {
                    this.steps = new Sequence.Step[]{new Sequence.Step(){

                        public void execute(final RequestMonitor rm) {
                            IMIProcessDMContext ctx;
                            if (iProcessDMContext instanceof IMIProcessDMContext && "".equals((ctx = (IMIProcessDMContext)iProcessDMContext).getProcId())) {
                                rm.done();
                                return;
                            }
                            GDBProcesses_7_2.this.getProcessesBeingDebugged((IDMContext)iProcessDMContext, (DataRequestMonitor<IDMContext[]>)new ImmediateDataRequestMonitor<IDMContext[]>(rm){

                                protected void handleSuccess() {
                                    if (!$assertionsDisabled && this.getData() == null) {
                                        throw new AssertionError();
                                    }
                                    boolean found = false;
                                    IDMContext[] iDMContextArray = (IDMContext[])this.getData();
                                    int n = iDMContextArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IDMContext dmc = iDMContextArray[n2];
                                        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IProcesses.IProcessDMContext.class);
                                        if (iProcessDMContext.equals(procDmc)) {
                                            found = true;
                                        }
                                        ++n2;
                                    }
                                    if (found) {
                                        Status failedStatus = new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MessageFormat.format(Messages.Already_connected_process_err, ((IMIProcessDMContext)iProcessDMContext).getProcId()), null);
                                        rm.done((IStatus)failedStatus);
                                        return;
                                    }
                                    super.handleSuccess();
                                }
                            });
                        }
                    }, new Sequence.Step(){

                        public void execute(final RequestMonitor rm) {
                            if (GDBProcesses_7_2.this.isInitialProcess()) {
                                fContainerDmc = GDBProcesses_7_2.this.createContainerContext(iProcessDMContext, GDBProcesses_7_2.INITIAL_THREAD_GROUP_ID);
                                rm.done();
                                return;
                            }
                            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)iProcessDMContext, ICommandControlService.ICommandControlDMContext.class);
                            (this).GDBProcesses_7_2.this.fCommandControl.queueCommand((this).GDBProcesses_7_2.this.fCommandFactory.createMIAddInferior(controlDmc), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIAddInferiorInfo>(rm){

                                protected void handleSuccess() {
                                    String groupId = ((MIAddInferiorInfo)this.getData()).getGroupId();
                                    if (groupId == null || groupId.trim().length() == 0) {
                                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid gdb group id.", null));
                                    } else {
                                        fContainerDmc = GDBProcesses_7_2.this.createContainerContext(iProcessDMContext, groupId);
                                    }
                                    rm.done();
                                }
                            });
                        }
                    }, new Sequence.Step(){

                        public void execute(final RequestMonitor rm) {
                            if (GDBProcesses_7_2.this.needFixForGDB72Bug352998() && (this).GDBProcesses_7_2.this.fBackend.getSessionType() == SessionType.REMOTE) {
                                if (!$assertionsDisabled && !(this).GDBProcesses_7_2.this.fBackend.getIsAttachSession()) {
                                    throw new AssertionError();
                                }
                                if (!$assertionsDisabled && string == null) {
                                    throw new AssertionError();
                                }
                                if (GDBProcesses_7_2.this.isInitialProcess()) {
                                    ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)iProcessDMContext, ICommandControlService.ICommandControlDMContext.class);
                                    (this).GDBProcesses_7_2.this.fCommandControl.queueCommand((this).GDBProcesses_7_2.this.fCommandFactory.createMITargetDisconnect(controlDmc), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

                                        protected void handleSuccess() {
                                            ((this).this).GDBProcesses_7_2.this.fNeedToReconnect = true;
                                            rm.done();
                                        }
                                    });
                                    return;
                                }
                            }
                            rm.done();
                        }
                    }, new Sequence.Step(){

                        public void execute(final RequestMonitor rm) {
                            if (string != null) {
                                (this).GDBProcesses_7_2.this.fCommandControl.queueCommand((this).GDBProcesses_7_2.this.fCommandFactory.createMIFileExecAndSymbols(fContainerDmc, string), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

                                    protected void handleCompleted() {
                                        if (((this).this).GDBProcesses_7_2.this.fNeedToReconnect) {
                                            ((this).this).GDBProcesses_7_2.this.fNeedToReconnect = false;
                                            rm.setStatus(this.getStatus());
                                            GDBProcesses_7_2.this.connectToTarget(iProcessDMContext, rm);
                                        } else {
                                            super.handleCompleted();
                                        }
                                    }
                                });
                                return;
                            }
                            if (!$assertionsDisabled && (this).GDBProcesses_7_2.this.fNeedToReconnect) {
                                throw new AssertionError();
                            }
                            rm.done();
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            if ((this).GDBProcesses_7_2.this.fBackend.getSessionType() == SessionType.REMOTE && GDBProcesses_7_2.this.isInitialProcess()) {
                                rm.done();
                                return;
                            }
                            boolean shouldInterrupt = true;
                            IMIRunControl runControl = (IMIRunControl)GDBProcesses_7_2.this.getServicesTracker().getService(IMIRunControl.class);
                            if (runControl != null && runControl.getRunMode() == IMIRunControl.MIRunMode.NON_STOP) {
                                shouldInterrupt = false;
                            }
                            boolean extraNewline = GDBProcesses_7_2.this.targetAttachRequiresTrailingNewline();
                            ICommand<MIInfo> miTargetAttach = (this).GDBProcesses_7_2.this.fCommandFactory.createMITargetAttach(fContainerDmc, ((IMIProcessDMContext)iProcessDMContext).getProcId(), shouldInterrupt, extraNewline);
                            (this).GDBProcesses_7_2.this.fCommandControl.queueCommand(miTargetAttach, (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            IGDBMemory memory = (IGDBMemory)GDBProcesses_7_2.this.getServicesTracker().getService(IGDBMemory.class);
                            IMemory.IMemoryDMContext memContext = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)fContainerDmc, IMemory.IMemoryDMContext.class);
                            if (memory == null || memContext == null) {
                                rm.done();
                                return;
                            }
                            memory.initializeMemoryData(memContext, rm);
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            MIBreakpointsManager bpmService = (MIBreakpointsManager)((Object)GDBProcesses_7_2.this.getServicesTracker().getService(MIBreakpointsManager.class));
                            bpmService.startTrackingBpForProcess(fContainerDmc, rm);
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            GDBProcesses_7_2.this.doReverseDebugStep(iProcessDMContext, rm);
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            dataRequestMonitor.setData((Object)fContainerDmc);
                            GDBProcesses_7_2.this.setIsInitialProcess(false);
                            rm.done();
                        }
                    }};
                }

                public Sequence.Step[] getSteps() {
                    return this.steps;
                }
            });
        } else {
            dataRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
            dataRm.done();
        }
    }

    protected boolean targetAttachRequiresTrailingNewline() {
        return false;
    }

    @Override
    public void detachDebuggerFromProcess(IDMContext dmc, final RequestMonitor rm) {
        GDBProcesses_7_0.MIExitedProcessDMC exitedProc = (GDBProcesses_7_0.MIExitedProcessDMC)DMContexts.getAncestorOfType((IDMContext)dmc, GDBProcesses_7_0.MIExitedProcessDMC.class);
        if (exitedProc != null) {
            super.detachDebuggerFromProcess(dmc, rm);
            return;
        }
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        final IMIContainerDMContext containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class);
        if (controlDmc != null && containerDmc != null) {
            if (!this.doCanDetachDebuggerFromProcess()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Detach not supported.", null));
                rm.done();
                return;
            }
            IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
            if (runControl != null && !runControl.isTargetAcceptingCommands()) {
                this.fBackend.interrupt();
            }
            this.getDetachedProcesses().add(containerDmc.getGroupId());
            this.fCommandControl.queueCommand(this.fCommandFactory.createMITargetDetach(controlDmc, containerDmc.getGroupId()), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        rm.done();
                    } else {
                        GDBProcesses_7_2.this.fCommandControl.queueCommand(GDBProcesses_7_2.this.fCommandFactory.createMITargetDetach(containerDmc), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)GDBProcesses_7_2.this.getExecutor(), rm){

                            protected void handleFailure() {
                                GDBProcesses_7_2.this.getDetachedProcesses().remove(containerDmc.getGroupId());
                                super.handleFailure();
                            }
                        });
                    }
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    @Override
    protected boolean doIsDebugNewProcessSupported() {
        SessionType type = this.fBackend.getSessionType();
        if (type == SessionType.CORE) {
            return false;
        }
        if (type == SessionType.REMOTE && !this.fBackend.getIsAttachSession()) {
            return false;
        }
        IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
        if (runControl != null && runControl.getRunMode() == IMIRunControl.MIRunMode.ALL_STOP) {
            return this.getNumConnected() == 0;
        }
        return true;
    }

    @Override
    protected Sequence getDebugNewProcessSequence(DsfExecutor executor, boolean isInitial, IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        return new DebugNewProcessSequence_7_2(executor, isInitial, dmc, file, attributes, rm);
    }

    @Override
    public void getProcessesBeingDebugged(IDMContext dmc, DataRequestMonitor<IDMContext[]> rm) {
        IMIContainerDMContext containerDmc;
        if (this.getTraceVisualization() && (containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class)) != null) {
            IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
            rm.setData((Object)new IMIExecutionDMContext[]{this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, TRACE_VISUALIZATION_THREAD_ID), TRACE_VISUALIZATION_THREAD_ID)});
            rm.done();
            return;
        }
        super.getProcessesBeingDebugged(dmc, rm);
    }

    @Override
    protected IMIContainerDMContext createContainerContextForRestart(String groupId) {
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(this.fCommandControl.getContext(), "");
        return this.createContainerContext(processDmc, groupId);
    }

    @Override
    public void restart(final IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        this.fProcRestarting.add(containerDmc);
        super.restart(containerDmc, attributes, (DataRequestMonitor<IRunControl.IContainerDMContext>)new ImmediateDataRequestMonitor<IRunControl.IContainerDMContext>(rm){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    GDBProcesses_7_2.this.fProcRestarting.remove(containerDmc);
                }
                this.setData((IRunControl.IContainerDMContext)this.getData());
                super.handleCompleted();
            }
        });
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadGroupAddedEvent e) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)e.getDMContext();
        IMIContainerDMContext containerDmc = e.getGroupId() != null ? this.createContainerContext(procDmc, e.getGroupId()) : null;
        this.getSession().dispatchEvent((Object)new ContainerCreatedDMEvent(containerDmc), this.getProperties());
    }

    @Override
    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        IDMContext dmc = e.getDMContext();
        if (dmc instanceof IRunControl.IContainerDMContext) {
            MIBreakpointsManager bpmService = (MIBreakpointsManager)((Object)this.getServicesTracker().getService(MIBreakpointsManager.class));
            boolean restarting = this.fProcRestarting.remove(dmc);
            if (bpmService != null && !restarting) {
                bpmService.removeTargetFilter((IRunControl.IContainerDMContext)dmc);
                if (dmc instanceof IBreakpoints.IBreakpointsTargetDMContext && this.fBackend.getSessionType() != SessionType.CORE) {
                    IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc = (IBreakpoints.IBreakpointsTargetDMContext)dmc;
                    bpmService.stopTrackingBreakpoints(bpTargetDmc, (RequestMonitor)new ImmediateRequestMonitor(){

                        protected void handleCompleted() {
                        }
                    });
                }
            }
        }
        super.eventDispatched(e);
    }

    protected boolean needFixForGDB72Bug352998() {
        return true;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent e) {
        this.setTraceVisualization(e.isVisualizationModeEnabled());
    }

    public void canDetachDebuggerFromSomeProcesses(IDMContext[] dmcs, DataRequestMonitor<Boolean> rm) {
        this.canDetachFromProcesses(dmcs, false, rm);
    }

    public void canDetachDebuggerFromAllProcesses(IDMContext[] dmcs, DataRequestMonitor<Boolean> rm) {
        this.canDetachFromProcesses(dmcs, true, rm);
    }

    protected void canDetachFromProcesses(IDMContext[] dmcs, boolean all, DataRequestMonitor<Boolean> rm) {
        HashSet<IMIContainerDMContext> contDmcs = new HashSet<IMIContainerDMContext>();
        IDMContext[] iDMContextArray = dmcs;
        int n = dmcs.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext c = iDMContextArray[n2];
            IMIContainerDMContext contDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)c, IMIContainerDMContext.class);
            if (contDmc != null) {
                contDmcs.add(contDmc);
            }
            ++n2;
        }
        Iterator it = contDmcs.iterator();
        if (!it.hasNext()) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        this.canDetachDebuggerFromProcess((IDMContext)it.next(), (DataRequestMonitor<Boolean>)new CanDetachRequestMonitor(it, all, rm));
    }

    public void detachDebuggerFromProcesses(IDMContext[] dmcs, RequestMonitor rm) {
        HashSet<IMIContainerDMContext> contDmcs = new HashSet<IMIContainerDMContext>();
        IDMContext[] iDMContextArray = dmcs;
        int n = dmcs.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext c = iDMContextArray[n2];
            IMIContainerDMContext contDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)c, IMIContainerDMContext.class);
            if (contDmc != null) {
                contDmcs.add(contDmc);
            }
            ++n2;
        }
        if (contDmcs.isEmpty()) {
            rm.done();
            return;
        }
        CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), rm);
        crm.setDoneCount(contDmcs.size());
        for (IMIContainerDMContext contDmc : contDmcs) {
            this.detachDebuggerFromProcess((IDMContext)contDmc, (RequestMonitor)crm);
        }
    }

    public void canTerminateSome(IProcesses.IThreadDMContext[] dmcs, DataRequestMonitor<Boolean> rm) {
        this.canTerminate(dmcs, false, rm);
    }

    public void canTerminateAll(IProcesses.IThreadDMContext[] dmcs, DataRequestMonitor<Boolean> rm) {
        this.canTerminate(dmcs, true, rm);
    }

    protected void canTerminate(IProcesses.IThreadDMContext[] dmcs, boolean all, DataRequestMonitor<Boolean> rm) {
        Iterator<IProcesses.IThreadDMContext> it = Arrays.asList(dmcs).iterator();
        if (!it.hasNext()) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        this.canTerminate(it.next(), (DataRequestMonitor<Boolean>)new CanTerminateRequestMonitor(it, all, rm));
    }

    public void terminate(IProcesses.IThreadDMContext[] dmcs, RequestMonitor rm) {
        if (dmcs.length == 0) {
            rm.done();
            return;
        }
        CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), rm);
        crm.setDoneCount(dmcs.length);
        IProcesses.IThreadDMContext[] iThreadDMContextArray = dmcs;
        int n = dmcs.length;
        int n2 = 0;
        while (n2 < n) {
            IProcesses.IThreadDMContext threadDmc = iThreadDMContextArray[n2];
            this.terminate(threadDmc, (RequestMonitor)crm);
            ++n2;
        }
    }

    private class CanDetachRequestMonitor
    extends ConditionalRequestMonitor {
        private CanDetachRequestMonitor(Iterator<? extends IDMContext> it, boolean all, DataRequestMonitor<Boolean> parentMonitor) {
            super(it, all, parentMonitor);
        }

        @Override
        protected void proceed(Iterator<? extends IDMContext> it, boolean all, DataRequestMonitor<Boolean> parentMonitor) {
            GDBProcesses_7_2.this.canDetachDebuggerFromProcess(it.next(), (DataRequestMonitor<Boolean>)new CanDetachRequestMonitor(it, all, parentMonitor));
        }
    }

    private class CanTerminateRequestMonitor
    extends ConditionalRequestMonitor {
        private CanTerminateRequestMonitor(Iterator<? extends IDMContext> it, boolean all, DataRequestMonitor<Boolean> parentMonitor) {
            super(it, all, parentMonitor);
        }

        @Override
        protected void proceed(Iterator<? extends IDMContext> it, boolean all, DataRequestMonitor<Boolean> parentMonitor) {
            GDBProcesses_7_2.this.canTerminate((IProcesses.IThreadDMContext)it.next(), (DataRequestMonitor<Boolean>)new CanTerminateRequestMonitor(it, all, parentMonitor));
        }
    }

    private abstract class ConditionalRequestMonitor
    extends ImmediateDataRequestMonitor<Boolean> {
        private Iterator<? extends IDMContext> fIterator;
        private boolean fAll;
        private DataRequestMonitor<Boolean> fParentMonitor;

        private ConditionalRequestMonitor(Iterator<? extends IDMContext> it, boolean all, DataRequestMonitor<Boolean> parentMonitor) {
            super(parentMonitor);
            this.fAll = true;
            this.fAll = all;
            this.fParentMonitor = parentMonitor;
            this.fIterator = it;
        }

        protected void handleCompleted() {
            if (!this.isSuccess()) {
                this.fParentMonitor.setStatus(this.getStatus());
                this.fParentMonitor.done();
                return;
            }
            if ((Boolean)this.getData() != this.fAll) {
                this.fParentMonitor.setData((Object)((Boolean)this.getData()));
                this.fParentMonitor.done();
            } else if (!this.fIterator.hasNext()) {
                this.fParentMonitor.setData((Object)this.fAll);
                this.fParentMonitor.done();
            } else {
                this.proceed(this.fIterator, this.fAll, this.fParentMonitor);
            }
        }

        protected abstract void proceed(Iterator<? extends IDMContext> var1, boolean var2, DataRequestMonitor<Boolean> var3);
    }

    protected static class ContainerCreatedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.ICreatedDMEvent {
        public ContainerCreatedDMEvent(IRunControl.IContainerDMContext context) {
            super((IDMContext)context);
        }
    }
}

