/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.loader;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.php.internal.core.documentModel.parser.PHPSourceParser;
import org.eclipse.php.internal.core.documentModel.parser.PHPStructuredDocumentReParser;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.wst.html.core.internal.encoding.HTMLDocumentLoader;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.encoding.CodedReaderCreator;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.encoding.IContentDescriptionExtended;
import org.eclipse.wst.sse.core.internal.encoding.util.Logger;
import org.eclipse.wst.sse.core.internal.encoding.util.NullInputStream;
import org.eclipse.wst.sse.core.internal.exceptions.UnsupportedCharsetExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;

public class PHPDocumentLoader
extends HTMLDocumentLoader {
    private static final boolean DEBUG = false;
    private CodedReaderCreator fCodedReaderCreator;

    protected IEncodedDocument newEncodedDocument() {
        IEncodedDocument doc = super.newEncodedDocument();
        assert (doc instanceof BasicStructuredDocument);
        ((BasicStructuredDocument)doc).setReParser((IStructuredTextReParser)new PHPStructuredDocumentReParser());
        return doc;
    }

    public RegionParser getParser() {
        PHPSourceParser parser = new PHPSourceParser();
        this.addHTMLishTag(parser, "script");
        this.addHTMLishTag(parser, "style");
        return parser;
    }

    public IDocumentLoader newInstance() {
        return new PHPDocumentLoader();
    }

    public IDocumentPartitioner getDefaultDocumentPartitioner() {
        return new PHPStructuredTextPartitioner();
    }

    protected CodedReaderCreator getCodedReaderCreator() {
        if (this.fCodedReaderCreator == null) {
            this.fCodedReaderCreator = new PHPCodedReaderCreator();
        }
        return this.fCodedReaderCreator;
    }

    class PHPCodedReaderCreator
    extends CodedReaderCreator {
        private EncodingRule fEncodingRule;
        private String fFilename;
        private IFile fIFile;
        private InputStream fInputStream;
        private static final String CHARSET_UTF_16 = "UTF-16";
        private static final String CHARSET_UTF_16LE = "UTF-16LE";

        PHPCodedReaderCreator() {
        }

        public void set(IFile iFile) throws CoreException, IOException {
            super.set(iFile);
            this.fIFile = iFile;
        }

        public void set(String filename, InputStream inputStream) {
            super.set(filename, inputStream);
            this.fFilename = filename;
            this.fInputStream = inputStream;
        }

        protected EncodingMemento createMemento(IContentDescription contentDescription) {
            String appropriateDefault = contentDescription.getContentType().getDefaultCharset();
            String detectedCharset = (String)contentDescription.getProperty(IContentDescriptionExtended.DETECTED_CHARSET);
            String unSupportedCharset = (String)contentDescription.getProperty(IContentDescriptionExtended.UNSUPPORTED_CHARSET);
            String javaCharset = contentDescription.getCharset();
            if (detectedCharset == null && appropriateDefault == null) {
                javaCharset = appropriateDefault = ResourcesPlugin.getEncoding();
                detectedCharset = appropriateDefault;
            }
            if (javaCharset == null) {
                Logger.log((int)201, (String)"charset equaled null!");
            } else if (javaCharset.length() == 0) {
                Logger.log((int)201, (String)"charset equaled emptyString!");
            }
            byte[] BOM = (byte[])contentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK);
            EncodingMemento result = PHPCodedReaderCreator.createEncodingMemento((byte[])BOM, (String)javaCharset, (String)detectedCharset, (String)unSupportedCharset, (String)appropriateDefault, null);
            if (!result.isValid()) {
                result.setAppropriateDefault(appropriateDefault);
            }
            return result;
        }

        public Reader getCodedReader() throws CoreException, IOException {
            Reader reader = super.getCodedReader();
            try {
                char[] tBuff = new char[8192];
                reader.read(tBuff, 0, tBuff.length);
                reader.reset();
                return reader;
            }
            catch (Exception exception) {
                InputStream is = this.getResettableStream();
                EncodingMemento encodingMemento = this.getEncodingMemento();
                String charsetName = encodingMemento.getJavaCharsetName();
                if (charsetName == null) {
                    charsetName = encodingMemento.getDetectedCharsetName();
                }
                if (!encodingMemento.isValid() && !this.forceDefault()) {
                    throw new UnsupportedCharsetExceptionWithDetail(encodingMemento);
                }
                if (this.fEncodingRule == EncodingRule.FORCE_DEFAULT) {
                    charsetName = encodingMemento.getAppropriateDefault();
                }
                if (CHARSET_UTF_16.equals(charsetName) && encodingMemento.getUnicodeBOM() == IContentDescription.BOM_UTF_16LE) {
                    charsetName = CHARSET_UTF_16LE;
                }
                reader = new BufferedReader(new InputStreamReader(is, charsetName), 8192);
                return reader;
            }
        }

        private boolean forceDefault() {
            boolean result = false;
            if (this.fEncodingRule != null && this.fEncodingRule == EncodingRule.FORCE_DEFAULT) {
                result = true;
            }
            return result;
        }

        private InputStream getResettableStream() throws CoreException, IOException {
            InputStream resettableStream = null;
            if (this.fIFile != null) {
                InputStream inputStream = null;
                try {
                    inputStream = this.fIFile.getContents(true);
                }
                catch (CoreException e) {
                    Logger.logException((Throwable)e);
                    inputStream = new NullInputStream();
                }
                resettableStream = new BufferedInputStream(inputStream, 8192);
            } else if (this.fInputStream != null) {
                if (this.fInputStream.markSupported()) {
                    resettableStream = this.fInputStream;
                    resettableStream.reset();
                } else {
                    resettableStream = new BufferedInputStream(this.fInputStream, 8192);
                }
            }
            if (resettableStream == null) {
                resettableStream = new NullInputStream();
            }
            resettableStream.mark(8192);
            return resettableStream;
        }

        public void setEncodingRule(EncodingRule encodingRule) {
            super.setEncodingRule(encodingRule);
            this.fEncodingRule = encodingRule;
        }
    }
}

