/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.contentassist;

import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class ContentAssistTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    private IProject project;
    private IFile testFile;
    private IFile[] otherFiles = new IFile[0];
    private PHPVersion phpVersion;
    private PHPStructuredEditor fEditor;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    public static final String DEFAULT_CURSOR = "|";

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/codeassist/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php53/classExclusive"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php56"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php56", "/workspace/codeassist/php7"});
        TESTS.put(PHPVersion.PHP7_1, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php71"});
        TESTS.put(PHPVersion.PHP7_2, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php71", "/workspace/codeassist/php72"});
        TESTS.put(PHPVersion.PHP7_3, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php71", "/workspace/codeassist/php72"});
        TESTS.put(PHPVersion.PHP7_4, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php71", "/workspace/codeassist/php72"});
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }

    public ContentAssistTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        TestUtils.disableColliders((TestUtils.ColliderType)TestUtils.ColliderType.ALL);
        InstanceScope.INSTANCE.getNode("org.eclipse.dltk.ui").putInt("content_assist_timeout", 60000);
        this.project = TestUtils.createProject((String)("Content Assist_" + String.valueOf(this.phpVersion)));
        ResourcesPlugin.getWorkspace().getRoot().getProject("Content Assist_" + String.valueOf(this.phpVersion));
        DefaultScope.INSTANCE.getNode("org.eclipse.php.core").putBoolean("contentAssistAutoinsert", true);
        DefaultScope.INSTANCE.getNode("org.eclipse.php.core").putBoolean("contentAssistAsync", false);
        TestUtils.setProjectPHPVersion((IProject)this.project, (PHPVersion)this.phpVersion);
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.php.formatter.core");
        node.put("formatterProfile", "org.eclipse.php.formatter.ui.default");
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        TestUtils.deleteProject((IProject)this.project);
        int defaultContentAssistTimeout = DefaultScope.INSTANCE.getNode("org.eclipse.dltk.ui").getInt("content_assist_timeout", 5000);
        InstanceScope.INSTANCE.getNode("org.eclipse.dltk.ui").putInt("content_assist_timeout", defaultContentAssistTimeout);
        TestUtils.enableColliders((TestUtils.ColliderType)TestUtils.ColliderType.ALL);
    }

    @Test
    public void assist(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
        this.doAssist(pdttFile);
    }

    private void doAssist(final PdttFile pdttFile) throws Exception {
        String pdttFileData = pdttFile.getFile();
        String cursor = this.getCursor(pdttFile) != null ? this.getCursor(pdttFile) : DEFAULT_CURSOR;
        final int offset = pdttFileData.lastIndexOf(cursor);
        String data = pdttFileData.substring(0, offset) + pdttFileData.substring(offset + 1);
        final Exception[] exception = new Exception[1];
        final String[] result = new String[1];
        Object fileName = Paths.get(pdttFile.getFileName(), new String[0]).getFileName().toString();
        fileName = ((String)fileName).substring(0, ((String)fileName).indexOf(46)) + ".php";
        this.createFiles(data, (String)fileName, pdttFile.getOtherFiles());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    pdttFile.applyPreferences();
                    ContentAssistTests.this.openEditor();
                    result[0] = ContentAssistTests.this.executeAutoInsert(offset);
                    ContentAssistTests.this.closeEditor();
                    ContentAssistTests.this.deleteFiles();
                }
                catch (Exception e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        PDTTUtils.assertContents((String)pdttFile.getExpected(), (String)result[0]);
    }

    private void deleteFiles() throws Exception {
        if (this.testFile != null) {
            TestUtils.deleteFile((IFile)this.testFile);
        }
        if (this.otherFiles != null) {
            IFile[] iFileArray = this.otherFiles;
            int n = this.otherFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file != null) {
                    TestUtils.deleteFile((IFile)file);
                }
                ++n2;
            }
            this.otherFiles = null;
        }
    }

    private String getCursor(PdttFile pdttFile) {
        Map config = pdttFile.getConfig();
        return (String)config.get("cursor");
    }

    private void openEditor() throws Exception {
        FileEditorInput input;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart part = page.openEditor((IEditorInput)(input = new FileEditorInput(this.testFile)), "org.eclipse.php.test.editor", false);
        if (part instanceof PHPStructuredEditor) {
            this.fEditor = (PHPStructuredEditor)part;
        } else {
            Assert.assertTrue((String)"Unable to open php editor", (boolean)false);
        }
    }

    private void closeEditor() {
        this.fEditor.doSave(null);
        this.fEditor.getSite().getPage().closeEditor((IEditorPart)this.fEditor, false);
        this.fEditor = null;
    }

    private String executeAutoInsert(int offset) {
        StructuredTextViewer viewer = null;
        Display display = Display.getDefault();
        long timeout = System.currentTimeMillis() + 3000L;
        while (System.currentTimeMillis() < timeout && (viewer = this.fEditor.getTextViewer()) == null) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (viewer == null) {
            Assert.fail((String)("fEditor.getTextViewer() returns null for file " + String.valueOf(this.testFile.getFullPath()) + "(" + String.valueOf(this.testFile.getLocation()) + ")"));
        }
        StyledText textWidget = viewer.getTextWidget();
        textWidget.setCaretOffset(offset);
        viewer.doOperation(13);
        return this.fEditor.getDocument().get();
    }

    private void createFiles(String content, String fileName, String[] other) throws Exception {
        ResourcesPlugin.getWorkspace().run(m -> {
            this.testFile = TestUtils.createFile((IProject)this.project, (String)new Path(fileName).lastSegment(), (String)content);
            this.otherFiles = new IFile[other.length];
            int i = 0;
            while (i < other.length) {
                this.otherFiles[i] = TestUtils.createFile((IProject)this.project, (String)new Path(i + fileName).addFileExtension("php").lastSegment(), (String)other[i]);
                ++i;
            }
        }, null);
        TestUtils.waitForIndexer();
    }
}

