/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.locator;

import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.locator.AbstractConciliatorTest;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PHPElementConciliatorV5_3Test
extends AbstractConciliatorTest {
    static {
        phpVersion = PHPVersion.PHP5_3;
    }

    @BeforeClass
    public static void setUpSuite() throws Exception {
        AbstractConciliatorTest.setUpSuite();
    }

    @Test
    public void concileClassName() {
        this.setFileContent("<?php namespace my\name; class TestRenameClass{} new TestRenameClass(); ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 54;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 26;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileClassName1() {
        this.setFileContent("<?php namespace my\name; class TestRenameClass{} class TestExtendedClass extends TestRenameClass{}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 82;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileClassName2() {
        this.setFileContent("<?php namespace my\name; class A{function foo(){}} $a = new A();$a->foo(); my\\name\\A::foo();?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 59;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 82;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileInterface() {
        this.setFileContent("<?php namespace my\name; interface iTemplate{public function setVariable($name, $var);}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 25;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 36;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileInterface1() {
        this.setFileContent("<?php namespace my\name; interface iTemplate{public function setVariable($name, $var);} class Template implements iTemplate{  public function setVariable($name, $var){}}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 25;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 115;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileProgram() {
        this.setFileContent("<?php namespace my\name; class TestRenameClass{}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        Assert.assertEquals((long)7L, (long)PHPElementConciliator.concile((ASTNode)program));
    }

    @Test
    public void concileGlobalVar() {
        this.setFileContent("<?php namespace my\name; $a = 1;  function test(){  global $a; echo $a;} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 26;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 60;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 69;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileGlobalVar1() {
        this.setFileContent("<?php namespace my\name; $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 67;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileFunc() {
        this.setFileContent("<?php namespace my\name; $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 35;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)2L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 44;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)2L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileFunc1() {
        this.setFileContent("<?php namespace my\name; function a($n){return ($n * $n);}echo a(5);?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 62;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)2L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod1() {
        this.setFileContent("<?class foo {public static function bar(){return 'bar in a class called';}}$strFN2 = foo::bar;echo bar();?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 91;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod2() {
        this.setFileContent("<? namespace my\name;class foo {public function bar(){return 'bar in a class called';}}$strFN2 = new foo(); $strFN2->bar()?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 118;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod3() {
        this.setFileContent("<? namespace my\name;class foo {public function bar(){return 'bar in a class called';} public function f(){$this->bar();}}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 115;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod4() {
        this.setFileContent("<? namespace my\name;class foo {public function bar(){return 'bar in a class called';} public function f(){$this->bar();}}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 50;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileField1() {
        this.setFileContent("<? namespace my\name;class foo {var $f; public function f(){$this->$f;}}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 33;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 64;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileField2() {
        this.setFileContent("<? namespace my\name;class foo {var $f; public function f(){$this->$f;}} $cls= new foo(); $cls->f;?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 95;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileStaticField1() {
        this.setFileContent("<? namespace my\name;class foo {public static $my_static = 'foo';} echo Foo::$my_static; echo $foo->my_static?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 107;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 78;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 101;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void localVar() {
        this.setFileContent("<? namespace my\name; $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 65;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)3L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 52;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)3L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstant() {
        this.setFileContent("<?php namespace my\name; define('CONSTANT', 'Hello world.'); echo CONSTANT; echo Constant; ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 25;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 34;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 67;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 82;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstant1() {
        this.setFileContent("<?php namespace my\name; define ('TEST', 1234); ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 26;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstant2() {
        this.setFileContent("<?php namespace my\name; define ('TEST', 1234); ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 27;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstant3() {
        this.setFileContent("<?php namespace NS;define(\"CONSTANT\", \"Hello world.\"); echo \\NS\\CONSTANT;?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 20;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 28;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 51;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 64;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }
}

