/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.refactoring.core.move.PHPMoveProcessor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PHPMoveProcessorRunConfigTestCase2 {
    private IProject project1;
    private String configFileCont = "<?xml version='1.0' encoding='UTF-8' standalone='no'?> <launchConfiguration type='org.eclipse.php.debug.core.launching.PHPExeLaunchConfigurationType'><stringAttribute key='ATTR_FILE' value='/TestProject2/src/RunConfigTest.php'/><stringAttribute key='ATTR_FILE_FULL_PATH' value='C:\\src\\RunConfigTest.php'/><stringAttribute key='ATTR_LOCATION' value='C:\\php-cgi.exe'/> <stringAttribute key='debugOutputEncoding' value='UTF-8'/><stringAttribute key='debugTransferEncoding' value='UTF-8'/><booleanAttribute key='firstLineBreakpoint' value='true'/><stringAttribute key='org.eclipse.php.debug.core.PHP_Project' value='/TestProject11'/><booleanAttribute key='org.eclipse.php.debug.core.RunWithDebugInfo' value='true'/><stringAttribute key='org.eclipse.php.debug.coreconfiguration_delegate_class' value='org.eclipse.php.internal.debug.core.launching.PHPExecutableLaunchDelegate'/><stringAttribute key='org.eclipse.php.debug.corephp_debugger_id' value='org.eclipse.php.debug.core.zendDebugger'/><stringAttribute key='php_debug_type' value='php_exe_script_debug'/></launchConfiguration>";
    private ILaunchConfiguration config;
    private IFile configFile;

    @Before
    public void setUp() throws Exception {
        this.project1 = TestUtils.createProject((String)"TestProject1");
        IFolder folder = TestUtils.createFolder((IProject)this.project1, (String)"src");
        TestUtils.createFile((IFolder)folder, (String)"RunConfigTest2.php", (String)"<?php class TestRenameClass{}?>");
        this.configFile = TestUtils.createFile((IProject)this.project1, (String)"TestConfig2.launch", (String)this.configFileCont);
        folder = TestUtils.createFolder((IProject)this.project1, (String)"src1");
        TestUtils.waitForIndexer();
    }

    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testMove() {
        PHPMoveProcessor processor = new PHPMoveProcessor((IResource)this.project1.getProject().getFolder("src"));
        RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        processor.setDestination((IContainer)this.project1.getFolder("src1"));
        processor.setUpdateReferences(true);
        try {
            Change change = processor.createChange((IProgressMonitor)new NullProgressMonitor());
            change.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        TestUtils.waitForIndexer();
        try {
            this.config = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(this.configFile);
            String path = this.config.getAttribute("ATTR_FILE", "");
            Assert.assertEquals((Object)"/TestProject2/src/RunConfigTest.php", (Object)path);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

