/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.refactoring.core.rename.RenameTraitProcessor;
import org.eclipse.php.refactoring.core.test.AbstractPDTTListRefactoringTest;
import org.eclipse.php.refactoring.core.test.PdttFileExt;
import org.junit.Assert;
import org.junit.Test;

public class RenameTraitProcessorTest
extends AbstractPDTTListRefactoringTest {
    @PDTTList.Parameters
    public static String[] dirs = new String[]{"/resources/rename/renameTrait/"};

    public RenameTraitProcessorTest(String[] fileNames) {
        super(fileNames);
    }

    @Override
    @PDTTList.BeforeList
    public void setUpListSuite() throws Exception {
        super.setUpListSuite();
        TestUtils.setProjectPHPVersion((IProject)this.project.getProject(), (PHPVersion)PHPVersion.PHP5_4);
    }

    @Test
    public void testRename(String fileName) throws Exception {
        PdttFileExt testFile = (PdttFileExt)((Object)this.filesMap.get(fileName));
        IFile file = this.project.findFile(testFile.getTestFiles().get(0).getName());
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = Integer.valueOf((String)testFile.getConfig().get("start"));
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        RenameTraitProcessor processor = new RenameTraitProcessor(file, selectedNode);
        processor.setNewElementName((String)testFile.getConfig().get("newName"));
        processor.setUpdateTextualMatches(Boolean.valueOf((String)testFile.getConfig().get("updateTextualMatches")).booleanValue());
        this.checkInitCondition((RefactoringProcessor)processor);
        this.checkFinalCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        this.checkTestResult(testFile);
    }
}

