/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.test;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.refactoring.core.test.FileInfo;
import org.osgi.framework.Bundle;

public class PdttFileExt
extends PdttFile {
    List<FileInfo> testFiles;
    List<FileInfo> expectedFiles;

    public List<FileInfo> getTestFiles() {
        if (this.testFiles == null) {
            this.testFiles = new ArrayList<FileInfo>();
        }
        return this.testFiles;
    }

    public List<FileInfo> getExpectedFiles() {
        if (this.expectedFiles == null) {
            this.expectedFiles = new ArrayList<FileInfo>();
        }
        return this.expectedFiles;
    }

    public PdttFileExt(Bundle testBundle, String fileName) throws Exception {
        super(testBundle, fileName);
    }

    public PdttFileExt(String fileName) throws Exception {
        super(fileName);
    }

    protected void onState(PdttFile.STATES state, String line) throws Exception {
        switch (state) {
            case FILE: {
                this.onFileState(line);
                return;
            }
            case EXPECT: {
                this.onExpectState(line);
                return;
            }
        }
        super.onState(state, line);
    }

    private void onExpectState(String line) {
        if (line.startsWith("FILENAME://")) {
            String fileName = line.substring(11);
            FileInfo info = new FileInfo(fileName);
            this.getExpectedFiles().add(info);
        } else {
            FileInfo currInfo = this.getExpectedFiles().get(this.expectedFiles.size() - 1);
            if (currInfo.getContents().length() != 0) {
                currInfo.appendContents("\n");
            }
            currInfo.appendContents(line);
        }
    }

    private void onFileState(String line) {
        if (line.startsWith("FILENAME://")) {
            String fileName = line.substring(11);
            FileInfo info = new FileInfo(fileName);
            this.getTestFiles().add(info);
        } else {
            FileInfo currInfo = this.getTestFiles().get(this.testFiles.size() - 1);
            if (currInfo.getContents().length() != 0) {
                currInfo.appendContents("\n");
            }
            currInfo.appendContents(line);
        }
    }
}

