/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.autoEdit.CaseDefaultAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.IAppliedAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.IndentLineAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.PHPAutoIndentStrategy;
import org.eclipse.php.internal.ui.autoEdit.PHPDocAutoIndentStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class MainAutoEditStrategy
implements IAutoEditStrategy {
    private static IAutoEditStrategy indentLineAutoEditStrategy = new IndentLineAutoEditStrategy();
    private static IAppliedAutoEditStrategy caseDefaultAutoEditStrategy = new CaseDefaultAutoEditStrategy();
    private static IAutoEditStrategy docBlockAutoEditStrategy = new PHPDocAutoIndentStrategy();
    private static IAutoEditStrategy autoIndentStrategy = new PHPAutoIndentStrategy();

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        boolean isCurrentQuotesState;
        boolean isPreviousQuotesState;
        if (command.text == null) {
            return;
        }
        String partitionType = FormatterUtils.getPartitionType((IStructuredDocument)((IStructuredDocument)document), (int)command.offset);
        if (partitionType == "org.eclipse.php.PHP_DOC" || partitionType == "org.eclipse.php.PHP_MULTI_LINE_COMMENT") {
            docBlockAutoEditStrategy.customizeDocumentCommand(document, command);
            return;
        }
        boolean bl = isPreviousQuotesState = command.offset > 0 ? FormatterUtils.isPHPQuotesState((IStructuredDocument)((IStructuredDocument)document), (int)(command.offset - 1), (boolean)false) : false;
        if (isPreviousQuotesState && (isCurrentQuotesState = FormatterUtils.isPHPQuotesState((IStructuredDocument)((IStructuredDocument)document), (int)command.offset, (boolean)true))) {
            return;
        }
        if (partitionType == "org.eclipse.php.PHP_DEFAULT" || partitionType == "org.eclipse.php.PHP_SINGLE_LINE_COMMENT" || partitionType == "org.eclipse.php.PHP_QUOTED_STRING") {
            caseDefaultAutoEditStrategy.customizeDocumentCommand(document, command);
            if (caseDefaultAutoEditStrategy.wasApplied()) {
                return;
            }
            indentLineAutoEditStrategy.customizeDocumentCommand(document, command);
            autoIndentStrategy.customizeDocumentCommand(document, command);
        }
    }
}

