/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.internal;

import java.awt.event.InputEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelListener;
import org.eclipse.trace4cps.common.jfreechart.chart.ZoomAndPanKeyboardHandler;
import org.eclipse.trace4cps.common.jfreechart.chart.ZoomMouseWheelHandler;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.OfflineRenderingChartPanel;

public class ChartPanelFactory {
    private ChartPanelFactory() {
    }

    public static ChartPanel createChartPanel(JFreeChart chart) {
        return ChartPanelFactory.configureChartPanel((ChartPanel)new OfflineRenderingChartPanel(chart));
    }

    public static ChartPanel configureChartPanel(ChartPanel chartPanel) {
        chartPanel.setZoomAroundAnchor(true);
        chartPanel.setZoomOutFactor(1.25);
        chartPanel.setZoomInFactor(0.8);
        chartPanel.setDefaultPanFactor(0.1);
        chartPanel.setPanPredicate(InputEvent::isAltDown);
        chartPanel.setZoomDomainPredicate(e -> e.isControlDown() && !e.isShiftDown());
        chartPanel.setZoomRangePredicate(e -> e.isControlDown() && e.isShiftDown());
        chartPanel.addMouseWheelListener((MouseWheelListener)new ZoomMouseWheelHandler());
        chartPanel.addKeyListener((KeyListener)new ZoomAndPanKeyboardHandler());
        return chartPanel;
    }
}

