/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.completion.tokenizer.InputTokenizer;
import org.eclipse.ease.ui.completion.tokenizer.TokenList;

public class BasicContext
implements ICompletionContext {
    private final String fContent;
    private final int fCursorPosition;
    private final IScriptEngine fScriptEngine;
    private final ScriptType fScriptType;
    private final Object fResource;
    private static final Pattern LOAD_MODULE_PATTERN = Pattern.compile("loadModule\\([\\\"\\'](.*?)[\\\"\\']");

    public BasicContext(IScriptEngine scriptEngine, String content, int cursorPosition) {
        this.fScriptEngine = scriptEngine;
        this.fScriptType = (ScriptType)scriptEngine.getDescription().getSupportedScriptTypes().get(0);
        this.fResource = null;
        this.fContent = content;
        this.fCursorPosition = cursorPosition;
    }

    public BasicContext(ScriptType scriptType, Object resource, String content, int cursorPosition) {
        this.fScriptEngine = null;
        this.fScriptType = scriptType;
        this.fResource = resource;
        this.fContent = content;
        this.fCursorPosition = cursorPosition;
    }

    public List<Object> getTokens() {
        return this.getInputTokenizer().getTokens(this.getRelevantText());
    }

    protected InputTokenizer getInputTokenizer() {
        if (this.getScriptEngine() != null) {
            return new InputTokenizer(v -> {
                if (this.getScriptEngine().hasVariable(v)) {
                    Object variable = this.getScriptEngine().getVariable(v);
                    return variable == null ? null : variable.getClass();
                }
                return null;
            });
        }
        return new InputTokenizer();
    }

    public String getText() {
        return this.fContent;
    }

    private String getRelevantText() {
        return this.getText().substring(0, this.getReplaceOffset());
    }

    public int getReplaceOffset() {
        return this.fCursorPosition;
    }

    public int getReplaceLength() {
        return 0;
    }

    public IScriptEngine getScriptEngine() {
        return this.fScriptEngine;
    }

    public List<ModuleDefinition> getLoadedModules() {
        ArrayList<ModuleDefinition> modules = new ArrayList<ModuleDefinition>();
        if (this.getScriptEngine() != null) {
            modules.addAll(ModuleHelper.getLoadedModules((IScriptEngine)this.getScriptEngine()));
        } else {
            modules.addAll(this.getLoadedModules(this.getRelevantText()));
            if (modules.stream().filter(m -> "/System/Environment".equals(m.getName())).count() == 0L) {
                modules.add(ModuleHelper.resolveModuleName((String)"/System/Environment"));
            }
        }
        return modules;
    }

    private Collection<? extends ModuleDefinition> getLoadedModules(String content) {
        ArrayList<ModuleDefinition> modules = new ArrayList<ModuleDefinition>();
        Matcher matcher = LOAD_MODULE_PATTERN.matcher(content);
        while (matcher.find()) {
            String moduleId = matcher.group(1);
            ModuleDefinition moduleDefinition = ModuleHelper.resolveModuleName((String)moduleId);
            if (moduleDefinition == null || modules.stream().filter(m -> moduleId.equals(m.getName())).count() != 0L) continue;
            modules.add(moduleDefinition);
        }
        return modules;
    }

    private Map<Object, String> getIncludes() {
        return Collections.emptyMap();
    }

    public String getFilterToken() {
        Object lastToken = new TokenList(this.getTokens()).getLastToken();
        return this.isFilter(lastToken) ? lastToken.toString() : "";
    }

    public String getFilter() {
        String filter = this.getFilterToken();
        return this.isStringLiteral(filter) ? filter.substring(1) : filter;
    }

    private boolean isFilter(Object lastToken) {
        return lastToken instanceof String && !InputTokenizer.isDelimiter(lastToken);
    }

    public boolean isStringLiteral(String input) {
        return input.startsWith("\"");
    }

    public ScriptType getScriptType() {
        return this.fScriptType;
    }

    public Object getResource() {
        return this.fResource;
    }
}

