/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.PlatformExtension;
import org.eclipse.ease.ui.completion.BasicContext;
import org.eclipse.ease.ui.completion.ScriptCompletionProposal;
import org.eclipse.ease.ui.completion.provider.ICompletionProvider;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class CodeCompletionAggregator
implements IContentProposalProvider {
    private static final String SCRIPT_COMPLETION_EXTENSION_POINT = "org.eclipse.ease.ui.codeCompletionProvider";
    private final IScriptEngine fScriptEngine;
    private ScriptType fScriptType;
    private final Object fResource;
    private final List<ICompletionProvider> fStaticCompletionProviders = new ArrayList<ICompletionProvider>();

    public CodeCompletionAggregator(IScriptEngine scriptEngine) {
        if (scriptEngine == null) {
            throw new IllegalArgumentException("scriptEngine cannot be null");
        }
        this.fScriptEngine = scriptEngine;
        this.setScriptType(this.fScriptEngine.getDescription().getSupportedScriptTypes().stream().findAny().orElse(null));
        this.fResource = null;
    }

    public CodeCompletionAggregator(Object resource, ScriptType scriptType) {
        this.fScriptEngine = null;
        this.setScriptType(scriptType);
        this.fResource = resource;
    }

    private void setScriptType(ScriptType scriptType) {
        if (scriptType == null) {
            throw new IllegalArgumentException("scriptType cannot be detected");
        }
        this.fScriptType = scriptType;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        return this.getProposals(contents, position, (IProgressMonitor)new NullProgressMonitor()).toArray(new IContentProposal[0]);
    }

    public List<ScriptCompletionProposal> getProposals(String content, int cursorPosition, IProgressMonitor monitor) {
        LinkedList<ScriptCompletionProposal> proposals = new LinkedList<ScriptCompletionProposal>();
        ICompletionContext context = this.createContext(content, cursorPosition);
        for (ICompletionProvider provider : this.getProposalProviders()) {
            try {
                if (!provider.isActive(context)) continue;
                proposals.addAll(provider.getProposals(context));
            }
            catch (Throwable e) {
                Logger.error((String)"org.eclipse.ease.ui", (String)"Code completion provider failed", (Throwable)e);
            }
        }
        return proposals;
    }

    private ICompletionContext createContext(String content, int cursorPosition) {
        if (this.fScriptEngine == null) {
            return new BasicContext(this.fScriptType, null, content, cursorPosition);
        }
        return new BasicContext(this.fScriptEngine, content, cursorPosition);
    }

    private List<ICompletionProvider> getProposalProviders() {
        ArrayList<ICompletionProvider> providers = new ArrayList<ICompletionProvider>();
        providers.addAll(this.getExtensionProposalProviders());
        providers.addAll(this.getLocalProposalProviders());
        return providers;
    }

    private List<ICompletionProvider> getLocalProposalProviders() {
        return this.fStaticCompletionProviders;
    }

    private List<ICompletionProvider> getExtensionProposalProviders() {
        Collection extensions = PlatformExtension.createForName((String)SCRIPT_COMPLETION_EXTENSION_POINT, (String)"codeCompletionProvider");
        return extensions.stream().filter(e -> this.matchesScriptType(e.getAttribute("scriptType"))).map(e -> {
            try {
                return (ICompletionProvider)e.createInstance("class", ICompletionProvider.class);
            }
            catch (ClassCastException | CoreException ex) {
                return null;
            }
        }).filter(p -> p != null).collect(Collectors.toList());
    }

    private boolean matchesScriptType(String extensionScriptType) {
        return extensionScriptType == null || extensionScriptType.isEmpty() || extensionScriptType.equals(this.fScriptType.getName());
    }

    public void addCompletionProvider(ICompletionProvider completionProvider) {
        this.fStaticCompletionProviders.add(completionProvider);
    }
}

