/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.tokenizer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.ui.completion.tokenizer.Bracket;
import org.eclipse.ease.ui.completion.tokenizer.BracketMatcher;
import org.eclipse.ease.ui.completion.tokenizer.IVariablesResolver;

public class InputTokenizer {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("(java|com|org)\\.([\\p{Lower}\\d]+\\.?)*");
    private static final Pattern CLASS_PATTERN = Pattern.compile("(java|com|org)\\.([\\p{Lower}\\d]+\\.?)\\.\\p{Upper}(\\w)*");
    private static final Pattern VARIABLES_PATTERN = Pattern.compile("\\p{Alpha}\\w*");
    private static final char[] DELIMITERS = new char[]{'.', '(', ','};
    private final IVariablesResolver fVariablesResolver;

    public static boolean isDelimiter(Object element) {
        char[] cArray = DELIMITERS;
        int n = DELIMITERS.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (new String(new char[]{c}).equals(element)) {
                return true;
            }
            ++n2;
        }
        return "()".equals(element) || ")".equals(element);
    }

    public static boolean isTextFilter(Object element) {
        return element instanceof String && !InputTokenizer.isDelimiter(element);
    }

    public InputTokenizer() {
        this(v -> null);
    }

    public InputTokenizer(IVariablesResolver variablesResolver) {
        this.fVariablesResolver = variablesResolver;
    }

    public List<Object> getTokens(String input) {
        return this.getTokensFromSimplifiedInput(this.getSimplifiedInput(input));
    }

    private List<Object> getTokensFromSimplifiedInput(String simpleInput) {
        List<Object> simpleToken = this.getSimpleToken(simpleInput);
        if (simpleToken != null) {
            return simpleToken;
        }
        int delimiterPosition = this.findLastDelimiter(simpleInput);
        if (delimiterPosition > 0) {
            return this.divideAndConquerTokens(simpleInput, delimiterPosition);
        }
        return Arrays.asList(simpleInput);
    }

    private List<Object> divideAndConquerTokens(String simpleInput, int delimiterPosition) {
        Method method;
        ArrayList<Object> tokens = new ArrayList<Object>();
        String beforeDelimiter = simpleInput.substring(0, delimiterPosition);
        String delimiterAndRest = simpleInput.substring(delimiterPosition).trim();
        tokens.addAll(this.getTokensFromSimplifiedInput(beforeDelimiter));
        Class<?> lastClass = this.getTrailingClassToken(tokens);
        Method method2 = method = lastClass != null ? this.detectMethod(lastClass, delimiterAndRest.substring(1)) : null;
        if (method != null) {
            tokens.add(method);
        } else if ("()".equals(delimiterAndRest)) {
            tokens.add(delimiterAndRest);
        } else if (delimiterAndRest.startsWith("(") && delimiterAndRest.length() > 1) {
            tokens.add("(");
            tokens.add(delimiterAndRest.substring(1).trim());
        } else if (delimiterAndRest.startsWith(".") && delimiterAndRest.length() > 1) {
            tokens.add(".");
            tokens.add(delimiterAndRest.substring(1).trim());
        } else if (delimiterAndRest.startsWith(",") && delimiterAndRest.length() > 1) {
            tokens.add(",");
            tokens.add(delimiterAndRest.substring(1).trim());
        } else {
            tokens.add(delimiterAndRest);
        }
        return tokens;
    }

    private Method detectMethod(Class<?> clazz, String methodName) {
        return Arrays.asList(clazz.getMethods()).stream().filter(m -> methodName.equals(m.getName())).findFirst().orElse(null);
    }

    private Class<?> getTrailingClassToken(List<Object> tokens) {
        Object checkToken = null;
        if (tokens.size() >= 2 && "()".equals(tokens.get(tokens.size() - 1))) {
            checkToken = tokens.get(tokens.size() - 2);
            if (checkToken instanceof Method) {
                return ((Method)checkToken).getReturnType();
            }
        } else if (!tokens.isEmpty()) {
            checkToken = tokens.get(tokens.size() - 1);
        }
        if (checkToken instanceof Class) {
            return (Class)checkToken;
        }
        return null;
    }

    private int findLastDelimiter(String input) {
        int position = -1;
        char[] cArray = DELIMITERS;
        int n = DELIMITERS.length;
        int n2 = 0;
        while (n2 < n) {
            char delimiter = cArray[n2];
            position = Math.max(position, input.lastIndexOf(delimiter));
            ++n2;
        }
        return position;
    }

    private List<Object> getSimpleToken(String input) {
        Class<?> candidate;
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        Matcher variablesMatcher = VARIABLES_PATTERN.matcher(input);
        if (variablesMatcher.matches() && (candidate = this.fVariablesResolver.resolveClass(input)) != null && !this.isBlacklisted(candidate)) {
            return Arrays.asList(candidate, "()");
        }
        Package packageInstance = this.getPackage(input);
        if (packageInstance != null) {
            return Arrays.asList(packageInstance);
        }
        Class<?> clazz = this.getClass(input);
        if (clazz != null) {
            return Arrays.asList(clazz);
        }
        return null;
    }

    private boolean isBlacklisted(Class<?> candidate) {
        return candidate.getName().startsWith("org.mozilla.javascript");
    }

    protected Package getPackage(String input) {
        Matcher packageMatcher = PACKAGE_PATTERN.matcher(input);
        if (packageMatcher.matches()) {
            return Package.getPackage(input);
        }
        return null;
    }

    protected Class<?> getClass(String input) {
        Matcher classMatcher = CLASS_PATTERN.matcher(input);
        if (classMatcher.matches()) {
            try {
                return this.getClass().getClassLoader().loadClass(input);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getSimplifiedInput(String input) {
        String simplifiedInput = input.trim();
        simplifiedInput = this.simplifyLiterals(simplifiedInput);
        String trailingLiteral = this.getTrailingLiteral(simplifiedInput);
        simplifiedInput = simplifiedInput.substring(0, simplifiedInput.length() - trailingLiteral.length());
        simplifiedInput = this.simplifyBrackets(simplifiedInput);
        simplifiedInput = this.simplifyParameters(simplifiedInput);
        simplifiedInput = this.clipIrrelevantStuff(simplifiedInput);
        return String.valueOf(simplifiedInput) + trailingLiteral;
    }

    private String getTrailingLiteral(String input) {
        int literalStart = input.indexOf(34);
        return literalStart >= 0 ? input.substring(literalStart) : "";
    }

    private String clipIrrelevantStuff(String input) {
        int locationOfTab;
        int locationOfSpace;
        String simplifiedInput = input;
        int locationOfEquals = simplifiedInput.lastIndexOf(61);
        if (locationOfEquals >= 0) {
            simplifiedInput = simplifiedInput.substring(locationOfEquals + 1).trim();
        }
        if ((locationOfSpace = simplifiedInput.lastIndexOf(32)) >= 0) {
            simplifiedInput = simplifiedInput.substring(locationOfSpace + 1).trim();
        }
        if ((locationOfTab = simplifiedInput.lastIndexOf(9)) >= 0) {
            simplifiedInput = simplifiedInput.substring(locationOfTab + 1).trim();
        }
        return simplifiedInput;
    }

    private String simplifyParameters(String input) {
        BracketMatcher bracketMatcher = new BracketMatcher(input);
        if (bracketMatcher.hasOpenBrackets()) {
            Bracket openBracket = bracketMatcher.getOpenBrackets().get(0);
            int lastCommaPosition = input.lastIndexOf(44);
            if (lastCommaPosition > openBracket.getStart()) {
                StringBuilder simplifiedText = new StringBuilder(input.substring(0, openBracket.getStart() + 1));
                simplifiedText.append(this.getCommas(input.substring(openBracket.getStart())));
                simplifiedText.append(input.substring(lastCommaPosition + 1).trim());
                return simplifiedText.toString();
            }
        }
        return input;
    }

    private String getCommas(String input) {
        int amountOfNeededCommas = (int)input.chars().filter(c -> c == 44).count();
        return ",".repeat(amountOfNeededCommas);
    }

    private String simplifyBrackets(String input) {
        BracketMatcher bracketMatcher;
        Optional<Bracket> bracket;
        StringBuilder simplifiedText = new StringBuilder(input);
        while ((bracket = (bracketMatcher = new BracketMatcher(simplifiedText.toString())).getBrackets().stream().filter(b -> b.getStart() < b.getEnd() - 1).findFirst()).isPresent()) {
            simplifiedText.delete(bracket.get().getStart() + 1, bracket.get().getEnd());
        }
        return simplifiedText.toString();
    }

    private String simplifyLiterals(String input) {
        int startIndex;
        StringBuilder simplified = new StringBuilder(input);
        int endIndex = 0;
        do {
            if ((startIndex = simplified.indexOf("\"")) < 0) continue;
            endIndex = simplified.indexOf("\"", startIndex + 1);
            while (endIndex > startIndex && simplified.charAt(endIndex - 1) == '\\') {
                endIndex = simplified.indexOf("\"", endIndex + 1);
            }
            if (endIndex <= startIndex) continue;
            simplified.delete(startIndex, endIndex + 1);
        } while (startIndex >= 0 && endIndex > startIndex);
        return simplified.toString();
    }

    protected boolean isLiteral(char candidate) {
        return '\"' == candidate;
    }
}

