/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.histogram;

import java.util.Arrays;

public class HistogramBucket {
    private int fNbEvents = 0;
    private int[] fEvents;

    public HistogramBucket(int traceCount) {
        this.fEvents = new int[traceCount];
    }

    public HistogramBucket(int ... values) {
        int[] nArray = this.fEvents = values;
        int n = this.fEvents.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.fNbEvents += i;
            ++n2;
        }
    }

    public HistogramBucket(HistogramBucket b) {
        this.add(b);
    }

    public HistogramBucket(HistogramBucket b1, HistogramBucket b2) {
        this.add(b1);
        this.add(b2);
    }

    public int getNbEvents() {
        return this.fNbEvents;
    }

    public synchronized void addEvent(int traceIndex) {
        this.ensureCapacity(traceIndex + 1);
        int n = traceIndex;
        this.fEvents[n] = this.fEvents[n] + 1;
        ++this.fNbEvents;
    }

    private void ensureCapacity(int len) {
        if (this.fEvents == null) {
            this.fEvents = new int[len];
        } else if (this.fEvents.length < len) {
            int[] oldArray = this.fEvents;
            this.fEvents = new int[len];
            System.arraycopy(oldArray, 0, this.fEvents, 0, oldArray.length);
        }
    }

    public int getNbEvent(int traceIndex) {
        if (this.fEvents == null || this.fEvents.length <= traceIndex) {
            return 0;
        }
        return this.fEvents[traceIndex];
    }

    public int getNbTraces() {
        if (this.fEvents == null) {
            return 0;
        }
        return this.fEvents.length;
    }

    public synchronized void add(HistogramBucket histogramBucket) {
        if (histogramBucket != null && histogramBucket.fNbEvents != 0) {
            int len = histogramBucket.fEvents.length;
            this.ensureCapacity(len);
            int i = 0;
            while (i < len) {
                int nbEvents = histogramBucket.fEvents[i];
                int n = i++;
                this.fEvents[n] = this.fEvents[n] + nbEvents;
                this.fNbEvents += nbEvents;
            }
        }
    }

    public boolean isEmpty() {
        return this.fNbEvents == 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fEvents);
        result = 31 * result + this.fNbEvents;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HistogramBucket other = (HistogramBucket)obj;
        if (this.fNbEvents != other.fNbEvents) {
            return false;
        }
        return this.fNbEvents == 0 || Arrays.equals(this.fEvents, other.fEvents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fNbEvents);
        sb.append(": ");
        sb.append(Arrays.toString(this.fEvents));
        return sb.toString();
    }
}

