/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.types.composite;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IEventHeaderDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderDefinition;

@NonNullByDefault
public final class EventHeaderLargeDeclaration
extends Declaration
implements IEventHeaderDeclaration {
    private static final int ALIGN_ON_1 = 1;
    private static final int BASE_10 = 10;
    private static final int COMPACT_ID = 16;
    private static final int EXTENDED_VALUE = 65535;
    private static final int FULL_TS = 64;
    private static final int COMPACT_TS = 32;
    private static final String CLOCK = "";
    private static final String CLOCK_MONOTONIC = "clock_monotonic";
    private static final int MAX_SIZE = 112;
    private static final int ALIGN_ON_8 = 8;
    private final ByteOrder fByteOrder;
    private final List<StructDeclaration> fReferenceStructs = new ArrayList<StructDeclaration>();
    private static final EventHeaderLargeDeclaration EVENT_HEADER_BIG_ENDIAN = new EventHeaderLargeDeclaration(EventHeaderLargeDeclaration.nullCheck(ByteOrder.BIG_ENDIAN));
    private static final EventHeaderLargeDeclaration EVENT_HEADER_LITTLE_ENDIAN = new EventHeaderLargeDeclaration(EventHeaderLargeDeclaration.nullCheck(ByteOrder.LITTLE_ENDIAN));

    private EventHeaderLargeDeclaration(ByteOrder byteOrder) {
        this.fByteOrder = byteOrder;
        this.populateReferences();
    }

    private void populateReferences() {
        if (!this.fReferenceStructs.isEmpty()) {
            return;
        }
        StructDeclaration ref = new StructDeclaration(8L);
        EnumDeclaration id = new EnumDeclaration(IntegerDeclaration.createDeclaration(16, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 1L));
        id.add(0L, 65534L, "compact");
        id.add(65535L, 65535L, "extended");
        ref.addField("id", id);
        VariantDeclaration v = new VariantDeclaration();
        StructDeclaration compact = new StructDeclaration(1L);
        compact.addField("timestamp", IntegerDeclaration.createDeclaration(32, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 8L));
        StructDeclaration extended = new StructDeclaration(1L);
        extended.addField("id", IntegerDeclaration.createDeclaration(32, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 8L));
        extended.addField("timestamp", IntegerDeclaration.createDeclaration(64, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 8L));
        v.addField("compact", compact);
        v.addField("extended", extended);
        ref.addField("v", v);
        this.fReferenceStructs.add(ref);
        ref = new StructDeclaration(8L);
        id = new EnumDeclaration(IntegerDeclaration.createDeclaration(16, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 8L));
        id.add(0L, 65534L, "compact");
        id.add(65535L, 65535L, "extended");
        ref.addField("id", id);
        v = new VariantDeclaration();
        compact = new StructDeclaration(1L);
        compact.addField("timestamp", IntegerDeclaration.createDeclaration(32, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 8L));
        extended = new StructDeclaration(1L);
        extended.addField("id", IntegerDeclaration.createDeclaration(32, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 8L));
        extended.addField("timestamp", IntegerDeclaration.createDeclaration(64, false, 10, this.fByteOrder, Encoding.NONE, CLOCK_MONOTONIC, 8L));
        v.addField("compact", compact);
        v.addField("extended", extended);
        ref.addField("v", v);
        this.fReferenceStructs.add(ref);
        ref = new StructDeclaration(8L);
        id = new EnumDeclaration(IntegerDeclaration.createDeclaration(16, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 16L));
        id.add(0L, 65534L, "compact");
        id.add(65535L, 65535L, "extended");
        ref.addField("id", id);
        v = new VariantDeclaration();
        compact = new StructDeclaration(1L);
        compact.addField("timestamp", IntegerDeclaration.createDeclaration(32, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 8L));
        extended = new StructDeclaration(1L);
        extended.addField("id", IntegerDeclaration.createDeclaration(32, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 8L));
        extended.addField("timestamp", IntegerDeclaration.createDeclaration(64, false, 10, this.fByteOrder, Encoding.NONE, CLOCK_MONOTONIC, 8L));
        v.addField("compact", compact);
        v.addField("extended", extended);
        ref.addField("v", v);
        this.fReferenceStructs.add(ref);
    }

    public static EventHeaderLargeDeclaration getEventHeader(@Nullable ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return EVENT_HEADER_BIG_ENDIAN;
        }
        return EVENT_HEADER_LITTLE_ENDIAN;
    }

    @Override
    public EventHeaderDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        this.alignRead(input);
        ByteOrder bo = input.getByteOrder();
        input.setByteOrder(this.fByteOrder);
        int first = (int)input.get(16, false);
        long second = input.get(32, false);
        if (first != 65535) {
            input.setByteOrder(bo);
            return new EventHeaderDefinition(this, first, second, 32);
        }
        long timestampLong = input.get(64, false);
        input.setByteOrder(bo);
        if (second > Integer.MAX_VALUE) {
            throw new CTFException("ID " + second + " larger than " + Integer.MAX_VALUE + " is currently unsupported by the parser");
        }
        return new EventHeaderDefinition(this, (int)second, timestampLong, 64);
    }

    @Override
    public long getAlignment() {
        return 8L;
    }

    @Override
    public int getMaximumSize() {
        return 112;
    }

    public boolean isLargeEventHeader(@Nullable StructDeclaration declaration) {
        if (declaration == null) {
            return false;
        }
        for (IDeclaration iDeclaration : this.fReferenceStructs) {
            if (!iDeclaration.isBinaryEquivalent(declaration)) continue;
            return true;
        }
        return false;
    }

    private static ByteOrder nullCheck(@Nullable ByteOrder bo) {
        if (bo == null) {
            throw new IllegalStateException("Could not create byteorder");
        }
        return bo;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fByteOrder.equals(ByteOrder.BIG_ENDIAN) ? 4321 : 1234);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventHeaderLargeDeclaration other = (EventHeaderLargeDeclaration)obj;
        return this.fByteOrder.equals(other.fByteOrder);
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration other) {
        for (StructDeclaration referenceStruct : this.fReferenceStructs) {
            if (!referenceStruct.isBinaryEquivalent(other)) continue;
            return true;
        }
        return false;
    }
}

