/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.analysis.core.weighted.tree;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IDataPalette;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.QualitativePaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;

public class DefaultDataPalette
implements IDataPalette {
    private static final int NUM_COLORS = 12;
    private static final Map<String, OutputElementStyle> STYLES;
    private static final Map<String, OutputElementStyle> STYLE_MAP;
    private static @Nullable DefaultDataPalette fInstance;

    static {
        STYLE_MAP = Collections.synchronizedMap(new HashMap());
        QualitativePaletteProvider palette = new QualitativePaletteProvider.Builder().setNbColors(12).build();
        int i = 0;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (RGBAColor color : palette.get()) {
            builder.put((Object)String.valueOf(i), (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(i), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()), (Object)"opacity", (Object)Float.valueOf((float)color.getAlpha() / 255.0f))));
            ++i;
        }
        STYLES = builder.build();
        fInstance = null;
    }

    private DefaultDataPalette() {
    }

    public static DefaultDataPalette getInstance() {
        DefaultDataPalette instance = fInstance;
        if (instance == null) {
            fInstance = instance = new DefaultDataPalette();
        }
        return instance;
    }

    @Override
    public Map<String, OutputElementStyle> getStyles() {
        return STYLES;
    }

    @Override
    public OutputElementStyle getStyleFor(Object object) {
        return STYLE_MAP.computeIfAbsent(String.valueOf(Math.floorMod(object.hashCode(), 12)), style -> new OutputElementStyle(style));
    }
}

