/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.core.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.scripting.core.ScriptExecutionHelper;
import org.eclipse.tracecompass.incubator.internal.scripting.core.cli.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliCommandLine;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliOption;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.ICliParser;

public class ScriptCliParser
implements ICliParser {
    private static final String OPTION_COMMAND_LINE_RUN_SCRIPT_SHORT = "s";
    private static final String OPTION_COMMAND_LINE_RUN_SCRIPT_LONG = "script";
    private static final String OPTION_COMMAND_LINE_RUN_SCRIPT_DESCRIPTION = Objects.requireNonNull(Messages.CliParser_RunScriptDescription);
    private static final String OPTION_COMMAND_LINE_SCRIPT_ENGINE_SHORT = "e";
    private static final String OPTION_COMMAND_LINE_SCRIPT_ENGINE_LONG = "engine";
    private static final String OPTION_COMMAND_LINE_SCRIPT_ENGINE_DESCRIPTION = Objects.requireNonNull(Messages.CliParser_ScriptEngineDescription);
    private static final String OPTION_COMMAND_LINE_SCRIPT_ARGUMENT_SHORT = "a";
    private static final String OPTION_COMMAND_LINE_SCRIPT_ARGUMENT_LONG = "args";
    private static final String OPTION_COMMAND_LINE_SCRIPT_ARGUMENT_DESCRIPTION = Objects.requireNonNull(Messages.CliParser_ScriptArgumentDescription);
    private final HashMap<String, String> fEngineNameToId;
    private final ArrayList<CliOption> fOptions = new ArrayList();

    public ScriptCliParser() {
        this.fOptions.add(CliOption.createOptionWithArgs((String)OPTION_COMMAND_LINE_RUN_SCRIPT_SHORT, (String)OPTION_COMMAND_LINE_RUN_SCRIPT_LONG, (String)OPTION_COMMAND_LINE_RUN_SCRIPT_DESCRIPTION, (boolean)true, (boolean)true, (String)OPTION_COMMAND_LINE_RUN_SCRIPT_LONG));
        this.fOptions.add(CliOption.createOptionWithArgs((String)OPTION_COMMAND_LINE_SCRIPT_ENGINE_SHORT, (String)OPTION_COMMAND_LINE_SCRIPT_ENGINE_LONG, (String)OPTION_COMMAND_LINE_SCRIPT_ENGINE_DESCRIPTION, (boolean)true, (boolean)false, (String)"engine name"));
        this.fOptions.add(CliOption.createOptionWithArgs((String)OPTION_COMMAND_LINE_SCRIPT_ARGUMENT_SHORT, (String)OPTION_COMMAND_LINE_SCRIPT_ARGUMENT_LONG, (String)OPTION_COMMAND_LINE_SCRIPT_ARGUMENT_DESCRIPTION, (boolean)true, (boolean)true, (String)"argument"));
        this.fEngineNameToId = new HashMap();
        ScriptService scriptService = ScriptService.getInstance();
        Collection engines = scriptService.getEngines();
        for (EngineDescription engine : engines) {
            if (engine.getName().contains("Debugger")) continue;
            this.fEngineNameToId.put(engine.getName(), engine.getID());
        }
    }

    public List<CliOption> getCmdLineOptions() {
        return this.fOptions;
    }

    public @NonNull IStatus workspaceLoading(@NonNull CliCommandLine commandLine, @NonNull IProgressMonitor monitor) {
        if (commandLine.hasOption(OPTION_COMMAND_LINE_RUN_SCRIPT_SHORT)) {
            String[] scripts = commandLine.getOptionValues(OPTION_COMMAND_LINE_RUN_SCRIPT_SHORT);
            String scriptEngine = null;
            List<String> scriptArguments = null;
            if (commandLine.hasOption(OPTION_COMMAND_LINE_SCRIPT_ENGINE_SHORT)) {
                String scriptEngineName = commandLine.getOptionValues(OPTION_COMMAND_LINE_SCRIPT_ENGINE_SHORT)[0];
                for (Map.Entry<String, String> entry : this.fEngineNameToId.entrySet()) {
                    String entryEngineName = Objects.requireNonNull(entry.getKey());
                    if (!entryEngineName.toLowerCase().contains(scriptEngineName.toLowerCase())) continue;
                    scriptEngine = Objects.requireNonNull(entry.getValue());
                }
                if (scriptEngine == null) {
                    return new Status(4, "org.eclipse.tracecompass.incubator.scripting.core", Messages.CliParser_ScriptEngineMapError);
                }
            }
            if (commandLine.hasOption(OPTION_COMMAND_LINE_SCRIPT_ARGUMENT_SHORT)) {
                scriptArguments = Arrays.asList(commandLine.getOptionValues(OPTION_COMMAND_LINE_SCRIPT_ARGUMENT_SHORT));
            }
            String[] stringArray = scripts;
            int n = scripts.length;
            int n2 = 0;
            while (n2 < n) {
                String script = stringArray[n2];
                Object scriptRet = ScriptExecutionHelper.executeScript(String.valueOf(script), scriptEngine, scriptArguments);
                if (scriptRet == null) {
                    return new Status(4, "org.eclipse.tracecompass.incubator.scripting.core", Messages.CliParser_ScriptExecutionError);
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }
}

