/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.nested;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.resources.nested.NestedProjectsProblemsModel;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.internal.navigator.resources.workbench.ResourceExtensionLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;

public class NestedProjectsLabelProvider
extends ResourceExtensionLabelProvider {
    private IResourceChangeListener refreshSeveritiesOnProblemMarkerChange;
    private NestedProjectsProblemsModel model;
    private CompletableFuture<NestedProjectsProblemsModel> refreshModelJob;
    static final Set<StructuredViewer> viewersToUpdate = Collections.synchronizedSet(new LinkedHashSet());

    @Override
    public void init(ICommonContentExtensionSite aConfig) {
        super.init(aConfig);
        this.model = new NestedProjectsProblemsModel();
        this.refreshModelJob = this.refreshSeverities();
        this.refreshSeveritiesOnProblemMarkerChange = event -> {
            if (event.getDelta() == null) {
                return;
            }
            MarkerManager markerManager = ((Workspace)WorkbenchNavigatorPlugin.getWorkspace()).getMarkerManager();
            try {
                event.getDelta().accept(delta -> {
                    IMarkerDelta[] markerDeltas;
                    IMarkerDelta[] iMarkerDeltaArray = markerDeltas = delta.getMarkerDeltas();
                    int n = markerDeltas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource;
                        IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                        if (markerManager.isSubtype(markerDelta.getType(), "org.eclipse.core.resources.problemmarker") && (resource = markerDelta.getResource()) != null) {
                            this.model.markDirty(resource);
                        }
                        ++n2;
                    }
                    return true;
                });
            }
            catch (CoreException e) {
                WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
            }
            if (this.model.isDirty()) {
                this.refreshModelJob = this.refreshSeverities();
                this.refreshModelJob.thenAccept(model -> {
                    StructuredViewer[] viewers;
                    Object[] toUpdate = model.getResourcesWithModifiedSeverity().toArray();
                    Set<StructuredViewer> set = viewersToUpdate;
                    synchronized (set) {
                        viewers = viewersToUpdate.toArray(new StructuredViewer[0]);
                    }
                    StructuredViewer[] structuredViewerArray = viewers;
                    int n = viewers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StructuredViewer viewer = structuredViewerArray[n2];
                        viewer.update(toUpdate, new String[0]);
                        ++n2;
                    }
                });
            }
        };
        WorkbenchNavigatorPlugin.getWorkspace().addResourceChangeListener(this.refreshSeveritiesOnProblemMarkerChange);
    }

    public void dispose() {
        WorkbenchNavigatorPlugin.getWorkspace().removeResourceChangeListener(this.refreshSeveritiesOnProblemMarkerChange);
        super.dispose();
    }

    private CompletableFuture<NestedProjectsProblemsModel> refreshSeverities() {
        return CompletableFuture.supplyAsync(() -> {
            this.model.refreshModel();
            return this.model;
        });
    }

    protected String decorateText(String input, Object element) {
        super.decorateText(input, element);
        if (!(element instanceof IProject)) {
            return input;
        }
        IProject project = (IProject)element;
        IPath location = project.getLocation();
        if (location != null && !location.lastSegment().equals(project.getName())) {
            return NLS.bind((String)WorkbenchNavigatorMessages.NestedProjectLabelProvider_nestedProjectLabel, (Object)input, (Object)location.lastSegment());
        }
        return input;
    }

    @Override
    protected int getHighestProblemSeverity(IResource resource) {
        int problemSeverity = super.getHighestProblemSeverity(resource);
        if (resource instanceof IContainer && problemSeverity < 2) {
            try {
                CompletableFuture<NestedProjectsProblemsModel> problemsModelSnapshot = this.refreshModelJob;
                if (problemsModelSnapshot != null) {
                    problemSeverity = Math.max(problemSeverity, problemsModelSnapshot.get(50L, TimeUnit.MILLISECONDS).getMaxSeverityIncludingNestedProjects(resource));
                }
            }
            catch (InterruptedException | ExecutionException e) {
                WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
            }
            catch (TimeoutException timeoutException) {
            }
            catch (RuntimeException e) {
                WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
            }
        }
        return problemSeverity;
    }
}

