/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.c.CVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCAnnotations;
import org.eclipse.core.runtime.CoreException;

class PDOMCVariable
extends PDOMBinding
implements IVariable {
    private static final int TYPE_OFFSET = 32;
    private static final int VALUE_OFFSET = 38;
    private static final int ANNOTATIONS = 43;
    protected static final int RECORD_SIZE = 44;

    public PDOMCVariable(PDOMLinkage linkage, PDOMNode parent, IVariable variable) throws CoreException {
        super(linkage, parent, variable.getNameCharArray());
        linkage.storeType(this.record + 32L, variable.getType());
        linkage.storeValue(this.record + 38L, variable.getInitialValue());
        this.getDB().putByte(this.record + 43L, PDOMCAnnotations.encodeVariableAnnotations(variable));
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IVariable) {
            IVariable var = (IVariable)newBinding;
            linkage.storeType(this.record + 32L, var.getType());
            linkage.storeValue(this.record + 38L, var.getInitialValue());
            this.getDB().putByte(this.record + 43L, PDOMCAnnotations.encodeVariableAnnotations(var));
        }
    }

    public PDOMCVariable(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    protected int getRecordSize() {
        return 44;
    }

    @Override
    public int getNodeType() {
        return 6;
    }

    @Override
    public IType getType() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadType(this.record + 32L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public IValue getInitialValue() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadValue(this.record + 38L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return IntegralValue.UNKNOWN;
        }
    }

    @Override
    public boolean isStatic() {
        return PDOMCAnnotations.isStatic(this.getAnnotations());
    }

    @Override
    public boolean isExtern() {
        return PDOMCAnnotations.isExtern(this.getAnnotations());
    }

    @Override
    public boolean isAuto() {
        return PDOMCAnnotations.isAuto(this.getAnnotations());
    }

    @Override
    public boolean isRegister() {
        return PDOMCAnnotations.isRegister(this.getAnnotations());
    }

    private byte getAnnotations() {
        return this.getByte(this.record + 43L);
    }

    @Override
    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        if ((standardFlags & 3) == 3) {
            return CVariableReadWriteFlags.getReadWriteFlags(name);
        }
        return 0;
    }
}

