/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.ObjectType;

class MaskType
extends JSType {
    private static final int NUMBER_OR_STRING_MASK = 192;
    private static final int UNDEFINED_OR_BOOLEAN_MASK = 280;
    private static final int UNDEFINED_OR_NUMBER_MASK = 320;
    private static final int UNDEFINED_OR_STRING_MASK = 384;
    private static final int UNDEFINED_OR_NULL_MASK = 288;
    private static final int NULL_OR_BOOLEAN_MASK = 56;
    private static final int NULL_OR_NUMBER_MASK = 96;
    private static final int NULL_OR_STRING_MASK = 160;
    private static final MaskType NUMBER_OR_STRING = new MaskType(192);
    private static final MaskType UNDEFINED_OR_BOOLEAN = new MaskType(280);
    private static final MaskType UNDEFINED_OR_NUMBER = new MaskType(320);
    private static final MaskType UNDEFINED_OR_STRING = new MaskType(384);
    private static final MaskType UNDEFINED_OR_NULL = new MaskType(288);
    private static final MaskType NULL_OR_BOOLEAN = new MaskType(56);
    private static final MaskType NULL_OR_NUMBER = new MaskType(96);
    private static final MaskType NULL_OR_STRING = new MaskType(160);
    protected final int mask;

    MaskType(int mask) {
        this.mask = mask;
    }

    static JSType make(int mask) {
        switch (mask) {
            case 0: {
                return JSType.BOTTOM;
            }
            case 8: {
                return JSType.TRUE_TYPE;
            }
            case 16: {
                return JSType.FALSE_TYPE;
            }
            case 32: {
                return JSType.NULL;
            }
            case 64: {
                return JSType.NUMBER;
            }
            case 128: {
                return JSType.STRING;
            }
            case 256: {
                return JSType.UNDEFINED;
            }
            case 512: {
                return JSType.TRUTHY;
            }
            case 1024: {
                return JSType.FALSY;
            }
            case 0x7FFFFFFF: {
                return JSType.UNKNOWN;
            }
            case -1: {
                return JSType.TOP;
            }
            case 24: {
                return JSType.BOOLEAN;
            }
            case 192: {
                return NUMBER_OR_STRING;
            }
            case 280: {
                return UNDEFINED_OR_BOOLEAN;
            }
            case 320: {
                return UNDEFINED_OR_NUMBER;
            }
            case 384: {
                return UNDEFINED_OR_STRING;
            }
            case 288: {
                return UNDEFINED_OR_NULL;
            }
            case 56: {
                return NULL_OR_BOOLEAN;
            }
            case 96: {
                return NULL_OR_NUMBER;
            }
            case 160: {
                return NULL_OR_STRING;
            }
        }
        return new MaskType(mask);
    }

    @Override
    protected int getMask() {
        return this.mask;
    }

    @Override
    protected ImmutableSet<ObjectType> getObjs() {
        return ImmutableSet.of();
    }

    @Override
    protected String getTypeVar() {
        return null;
    }

    @Override
    protected ImmutableSet<EnumType> getEnums() {
        return ImmutableSet.of();
    }
}

