/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.ui.views.io.perprocess;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.incubator.internal.kernel.core.io.IoAccessDataProviderFactory;
import org.eclipse.tracecompass.incubator.internal.kernel.core.io.IoPerProcessDataProviderFactory;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.AbstractMultiView;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.IMultiViewer;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.timegraph.BaseDataProviderTimeGraphMultiViewer;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart.ChartMultiViewer;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph.BaseDataProviderTimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.IElementResolver;
import org.eclipse.tracecompass.tmf.core.signal.TmfDataModelSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer2;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.ui.IWorkbenchPartSite;

public class IoByProcessView
extends AbstractMultiView {
    public static final String VIEW_ID = "org.eclipse.tracecompass.kernel.ui.view.iobyprocess";
    private @Nullable Integer fSelectedTid = null;
    private Set<Integer> fCheckedTids = new HashSet<Integer>();
    private @Nullable BaseDataProviderTimeGraphMultiViewer fTgViewer = null;
    private @Nullable TmfViewer fSignalSource;

    public IoByProcessView() {
        super(VIEW_ID);
    }

    @TmfSignalHandler
    public void modelSelectedSignal(TmfDataModelSelectedSignal signal) {
        if (signal.getSource() != this.fSignalSource) {
            return;
        }
        Multimap metadata = signal.getMetadata();
        Collection collection = metadata.get((Object)OsStrings.tid());
        if (!collection.isEmpty()) {
            Object tidObj = collection.iterator().next();
            BaseDataProviderTimeGraphMultiViewer tgViewer = this.fTgViewer;
            Integer selectedTid = this.fSelectedTid;
            if (tidObj instanceof Integer && !tidObj.equals(selectedTid) && tgViewer != null) {
                this.fSelectedTid = (Integer)tidObj;
                tgViewer.triggerRebuild();
            }
        }
    }

    protected void partControlCreated(Composite mainComposite, SashForm sashForm) {
        ChartMultiViewer chartViewer = this.addChartViewer(IoPerProcessDataProviderFactory.DESCRIPTOR.getId(), false);
        TmfViewer leftChildViewer = chartViewer.getLeftChildViewer();
        if (leftChildViewer instanceof AbstractSelectTreeViewer2) {
            ((AbstractSelectTreeViewer2)leftChildViewer).addTreeListener(entries -> {
                HashSet tids = new HashSet();
                entries.stream().filter(e -> e instanceof TmfGenericTreeEntry).map(e -> ((TmfGenericTreeEntry)e).getModel()).filter(m -> m instanceof IElementResolver).map(m -> ((IElementResolver)m).getMetadata().get((Object)OsStrings.tid())).forEach(t -> {
                    boolean bl = tids.addAll(t);
                });
                this.fCheckedTids.clear();
                for (Object tid : tids) {
                    if (!(tid instanceof Integer)) continue;
                    this.fCheckedTids.add((Integer)tid);
                }
            });
        }
        this.fSignalSource = leftChildViewer;
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setBackground(this.getColorScheme().getColor(32));
        IoAccessTimeGraphViewer tgViewer = new IoAccessTimeGraphViewer(composite);
        tgViewer.init();
        this.addLane((IMultiViewer)tgViewer);
        this.fTgViewer = tgViewer;
    }

    public class IoAccessTimeGraphViewer
    extends BaseDataProviderTimeGraphMultiViewer {
        public IoAccessTimeGraphViewer(Composite composite) {
            super(composite, (ITimeGraphPresentationProvider)new BaseDataProviderTimeGraphPresentationProvider(), (IWorkbenchPartSite)IoByProcessView.this.getViewSite(), IoAccessDataProviderFactory.DESCRIPTOR.getId());
            TmfSignalManager.register((Object)((Object)this));
        }

        public void dispose() {
            TmfSignalManager.deregister((Object)((Object)this));
            super.dispose();
        }

        protected @NonNull Map<@NonNull String, @NonNull Object> getFetchTreeParameters() {
            Integer tid = IoByProcessView.this.fSelectedTid;
            HashSet<Integer> tids = new HashSet<Integer>(IoByProcessView.this.fCheckedTids);
            if (tid != null) {
                tids.add(tid);
            }
            ITimeDataProvider timeProvider = IoByProcessView.this.getTimeProvider();
            if (tids.isEmpty() || timeProvider == null) {
                return Collections.emptyMap();
            }
            return ImmutableMap.of((Object)"selected", tids, (Object)"requested_times", (Object)ImmutableList.of((Object)timeProvider.getTime0(), (Object)timeProvider.getTime1()));
        }

        @TmfSignalHandler
        public void windowRangeUpdated(@Nullable TmfWindowRangeUpdatedSignal signal) {
            if (IoByProcessView.this.fSelectedTid != null) {
                this.triggerRebuild();
            }
        }
    }
}

