/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.AbstractTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.WildcardType;

public final class CaptureType
extends AbstractTypeVariable {
    private WildcardType fWildcard;
    private IJavaScriptProject fJavaProject;

    protected CaptureType(TypeEnvironment environment) {
        super(environment);
    }

    protected void initialize(ITypeBinding binding, IJavaScriptProject javaProject) {
        Assert.isTrue((boolean)false);
        super.initialize(binding);
        this.fJavaProject = javaProject;
    }

    @Override
    public int getKind() {
        return 13;
    }

    public WildcardType getWildcard() {
        return this.fWildcard;
    }

    @Override
    public boolean doEquals(TType type) {
        return this.getBindingKey().equals(((CaptureType)type).getBindingKey()) && this.fJavaProject.equals(((CaptureType)type).fJavaProject);
    }

    public int hashCode() {
        return this.getBindingKey().hashCode();
    }

    @Override
    protected boolean doCanAssignTo(TType lhs) {
        switch (lhs.getKind()) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                return this.canAssignFirstBoundTo(lhs);
            }
            case 6: {
                return false;
            }
            case 5: 
            case 7: 
            case 8: {
                return this.canAssignOneBoundTo(lhs);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)lhs).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)lhs).checkLowerBound(this.getWildcard());
            }
        }
        return false;
    }

    protected boolean checkLowerBound(TType rhs) {
        if (!this.getWildcard().isSuperWildcardType()) {
            return false;
        }
        return rhs.canAssignTo(this.getWildcard().getBound());
    }

    private boolean canAssignFirstBoundTo(TType lhs) {
        if (this.fBounds.length > 0 && this.fBounds[0].isArrayType()) {
            return this.fBounds[0].canAssignTo(lhs);
        }
        return false;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    protected String getPlainPrettySignature() {
        return "capture-of " + this.fWildcard.getPrettySignature();
    }
}

