/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IFileNomination;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSpecification;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPreprocessorName;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPreprocessorNode;
import org.eclipse.core.runtime.CoreException;

class ASTInclusionStatement
extends ASTPreprocessorNode
implements IASTPreprocessorIncludeStatement {
    private static final ISignificantMacros[] NO_VERSIONS = new ISignificantMacros[0];
    private final ASTPreprocessorName fName;
    private final String fPath;
    private final boolean fIsResolved;
    private final boolean fIsSystemInclude;
    private final boolean fFoundByHeuristics;
    private final boolean fIncludedFileExported;
    private final IFileNomination fNominationDelegate;
    private boolean fPragmaOnce;
    private boolean fCreatesAST;
    private ISignificantMacros fSignificantMacros;
    private ISignificantMacros[] fLoadedVersions = NO_VERSIONS;
    private long fIncludedFileContentsHash;
    private long fIncludedFileTimestamp = -1L;
    private long fIncludedFileSize;
    private long fIncludedFileReadTime;
    private boolean fErrorInIncludedFile;

    public ASTInclusionStatement(IASTTranslationUnit parent, int startNumber, int nameStartNumber, int nameEndNumber, int endNumber, char[] headerName, String filePath, boolean userInclude, boolean active, boolean heuristic, boolean exportedFile, IFileNomination nominationDelegate) {
        super(parent, IASTTranslationUnit.PREPROCESSOR_STATEMENT, startNumber, endNumber);
        this.fName = new ASTPreprocessorName(this, IASTPreprocessorIncludeStatement.INCLUDE_NAME, nameStartNumber, nameEndNumber, headerName, null);
        this.fPath = filePath == null ? "" : filePath;
        this.fIsResolved = filePath != null;
        this.fIsSystemInclude = !userInclude;
        this.fFoundByHeuristics = heuristic;
        this.fSignificantMacros = ISignificantMacros.NONE;
        this.fNominationDelegate = nominationDelegate;
        this.fIncludedFileExported = exportedFile;
        if (!active) {
            this.setInactive();
        }
    }

    @Override
    public IASTName getName() {
        return this.fName;
    }

    @Override
    public String getPath() {
        return this.fPath;
    }

    @Override
    public boolean isResolved() {
        return this.fIsResolved;
    }

    @Override
    public boolean isSystemInclude() {
        return this.fIsSystemInclude;
    }

    @Override
    void findNode(ASTNodeSpecification<?> nodeSpec) {
        super.findNode(nodeSpec);
        nodeSpec.visit(this.fName);
    }

    @Override
    public boolean isResolvedByHeuristics() {
        return this.fFoundByHeuristics;
    }

    @Override
    public boolean hasPragmaOnceSemantics() {
        if (this.fNominationDelegate != null) {
            try {
                return this.fNominationDelegate.hasPragmaOnceSemantics();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.fPragmaOnce;
    }

    public void setPragamOnceSemantics(boolean value) {
        assert (this.fNominationDelegate == null);
        this.fPragmaOnce = value;
    }

    @Override
    public ISignificantMacros getSignificantMacros() {
        if (this.fNominationDelegate != null) {
            try {
                return this.fNominationDelegate.getSignificantMacros();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.fSignificantMacros;
    }

    public void setSignificantMacros(ISignificantMacros sig) {
        assert (sig != null);
        assert (this.fNominationDelegate == null);
        this.fSignificantMacros = sig;
    }

    public void setLoadedVersions(ISignificantMacros[] versions) {
        this.fLoadedVersions = versions;
    }

    @Override
    public ISignificantMacros[] getLoadedVersions() {
        return this.fLoadedVersions;
    }

    @Override
    public long getIncludedFileTimestamp() {
        if (this.fNominationDelegate != null) {
            return 0L;
        }
        return this.fIncludedFileTimestamp;
    }

    public void setIncludedFileTimestamp(long timestamp) {
        assert (this.fNominationDelegate == null);
        this.fIncludedFileTimestamp = timestamp;
    }

    @Override
    public long getIncludedFileReadTime() {
        if (this.fNominationDelegate != null) {
            return 0L;
        }
        return this.fIncludedFileReadTime;
    }

    public void setIncludedFileReadTime(long time) {
        assert (this.fNominationDelegate == null);
        this.fIncludedFileReadTime = time;
    }

    @Override
    public long getIncludedFileSize() {
        if (this.fNominationDelegate != null) {
            return 0L;
        }
        return this.fIncludedFileSize;
    }

    public void setIncludedFileSize(long size) {
        assert (this.fNominationDelegate == null);
        this.fIncludedFileSize = size;
    }

    @Override
    public long getIncludedFileContentsHash() {
        if (this.fNominationDelegate != null) {
            return 0L;
        }
        return this.fIncludedFileContentsHash;
    }

    public void setIncludedFileContentsHash(long hash) {
        assert (this.fNominationDelegate == null);
        this.fCreatesAST = true;
        this.fIncludedFileContentsHash = hash;
    }

    @Override
    public boolean isErrorInIncludedFile() {
        if (this.fNominationDelegate != null) {
            return false;
        }
        return this.fErrorInIncludedFile;
    }

    public void setErrorInIncludedFile(boolean error) {
        assert (this.fNominationDelegate == null);
        this.fErrorInIncludedFile = error;
    }

    @Override
    public boolean isIncludedFileExported() {
        return this.fIncludedFileExported;
    }

    @Override
    public boolean createsAST() {
        return this.fCreatesAST;
    }

    @Override
    public IIndexFile getImportedIndexFile() {
        if (this.fNominationDelegate instanceof IIndexFile) {
            return (IIndexFile)this.fNominationDelegate;
        }
        return null;
    }
}

