/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.datastore.core.condition;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;

public class ArrayTimeRangeCondition
implements TimeRangeCondition {
    private final long[] fTimeArray;

    public ArrayTimeRangeCondition(Collection<@NonNull Long> times) {
        if (times.isEmpty()) {
            throw new IllegalArgumentException("QuarkArrayRangeCondition requires a non empty collection");
        }
        this.fTimeArray = new long[times.size()];
        int i = 0;
        for (Long quark : times) {
            this.fTimeArray[i] = quark;
            ++i;
        }
        Arrays.sort(this.fTimeArray);
    }

    private ArrayTimeRangeCondition(long[] timeArray) {
        this.fTimeArray = timeArray;
    }

    @Override
    public long min() {
        return this.fTimeArray[0];
    }

    @Override
    public long max() {
        return this.fTimeArray[this.fTimeArray.length - 1];
    }

    @Override
    public boolean test(long element) {
        return Arrays.binarySearch(this.fTimeArray, element) >= 0;
    }

    @Override
    public boolean intersects(long low, long high) {
        int lowIndex = Arrays.binarySearch(this.fTimeArray, low);
        if (lowIndex >= 0) {
            return true;
        }
        if (lowIndex == -this.fTimeArray.length - 1) {
            return false;
        }
        return this.fTimeArray[-lowIndex - 1] <= high;
    }

    @Override
    public @Nullable TimeRangeCondition subCondition(long from, long to) {
        if (from <= this.min() && this.max() <= to) {
            return this;
        }
        int fromIndex = Arrays.binarySearch(this.fTimeArray, from);
        if (fromIndex == -this.fTimeArray.length - 1) {
            return null;
        }
        int toIndex = Arrays.binarySearch(this.fTimeArray, fromIndex = fromIndex >= 0 ? fromIndex : -fromIndex - 1, this.fTimeArray.length, to);
        if (toIndex == -1) {
            return null;
        }
        int n = toIndex = toIndex >= 0 ? toIndex + 1 : -toIndex - 1;
        if (toIndex <= fromIndex) {
            return null;
        }
        return new ArrayTimeRangeCondition(Arrays.copyOfRange(this.fTimeArray, fromIndex, toIndex));
    }

    public String toString() {
        return "ArrayTimeRangeCondition[" + this.fTimeArray.length + "](" + this.min() + "\u2025" + this.max() + ")";
    }
}

