/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.event;

import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryIntegerParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class EventIDParser
implements ICommonTreeParser {
    private static final String INVALID_VALUE_ERROR = "Invalid value for event id";
    public static final EventIDParser INSTANCE = new EventIDParser();

    private EventIDParser() {
    }

    @Override
    public Long parse(ICTFMetadataNode tree, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        ICTFMetadataNode firstChild = tree.getChild(0);
        if (TsdlUtils.isUnaryInteger(firstChild)) {
            if (tree.getChildren().size() > 1) {
                throw new ParseException(INVALID_VALUE_ERROR);
            }
            long intval = UnaryIntegerParser.INSTANCE.parse(firstChild, null);
            if (intval > Integer.MAX_VALUE) {
                throw new ParseException("Event id larger than int.maxvalue, something is amiss");
            }
            return intval;
        }
        throw new ParseException(INVALID_VALUE_ERROR);
    }
}

