/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.model.TmfEditorLinkHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.views.ITmfPinnable;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.TmfViewFactory;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.FileEditorInput;

public class NewTmfViewAction
extends Action {
    private final @NonNull String fViewId;
    private final @Nullable ITmfTrace fPinnedTrace;
    private final boolean fNewInstance;

    public NewTmfViewAction(TmfView view) {
        super(MessageFormat.format(Messages.TmfView_NewViewActionText, view.getTitle()));
        this.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/new_view.png"));
        this.fViewId = view.getViewId();
        this.fPinnedTrace = null;
        this.fNewInstance = false;
    }

    public NewTmfViewAction(TmfView view, ITmfTrace pinnedTrace) {
        if (pinnedTrace == null) {
            this.setText(Messages.TmfView_NewViewActionUnpinnedText);
            this.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/unpinned_view.gif"));
        } else {
            this.setText(MessageFormat.format(Messages.TmfView_NewViewActionPinnedText, TmfTraceManager.getInstance().getTraceUniqueName(pinnedTrace)));
            this.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/pin_view.gif"));
        }
        this.fViewId = view.getViewId();
        this.fPinnedTrace = pinnedTrace;
        this.fNewInstance = false;
    }

    public NewTmfViewAction(TmfView view, @NonNull ITmfTrace pinnedTrace, boolean newInstance) {
        super(MessageFormat.format(Messages.TmfView_NewViewActionPinnedNewInstanceText, pinnedTrace.getName()));
        this.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/pin_view.gif"));
        this.fViewId = view.getViewId();
        this.fPinnedTrace = pinnedTrace;
        this.fNewInstance = newInstance;
    }

    public void run() {
        ITmfTrace pinnedTrace = this.fPinnedTrace;
        if (this.fNewInstance) {
            if (pinnedTrace == null) {
                return;
            }
            IFile file = TmfTraceManager.getInstance().getTraceContext(pinnedTrace).getEditorFile();
            Object element = new TmfEditorLinkHelper().findSelection((IEditorInput)new FileEditorInput(file)).getFirstElement();
            if (element instanceof TmfCommonProjectElement) {
                final TmfOpenTraceHelper.OpenProjectElementJob openJob = new TmfOpenTraceHelper.OpenProjectElementJob((TmfCommonProjectElement)element, file);
                openJob.schedule();
                Thread waitThread = new Thread(){

                    @Override
                    public void run() {
                        while (!TmfTraceManager.getInstance().getOpenedTraces().contains(openJob.getTrace())) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                        Display.getDefault().asyncExec(() -> {
                            IViewPart view = TmfViewFactory.newView(NewTmfViewAction.this.fViewId, true);
                            if (view instanceof ITmfPinnable) {
                                ((ITmfPinnable)view).setPinned(openJob.getTrace());
                            }
                        });
                    }
                };
                waitThread.start();
            }
            return;
        }
        IViewPart view = TmfViewFactory.newView(this.fViewId, true);
        if (pinnedTrace != null && view instanceof ITmfPinnable) {
            ((ITmfPinnable)view).setPinned(pinnedTrace);
        }
    }
}

