/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.trace;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.trace.CTFIOException;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamPacketOutputWriter;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputPacketIndex;

public class CTFStreamOutputWriter {
    private final @Nullable CTFStreamInput fStreamInput;
    private final @NonNull CTFStreamPacketOutputWriter fStreamPacketOutputWriter;
    private final @NonNull File fOutFile;

    public CTFStreamOutputWriter(@NonNull CTFStreamInput streamInput, @NonNull File file) throws CTFException {
        this.fStreamInput = streamInput;
        String inFileName = streamInput.getFile().getName();
        Path outFilePath = FileSystems.getDefault().getPath(file.getAbsolutePath(), inFileName);
        try {
            this.fOutFile = Objects.requireNonNull(Files.createFile(outFilePath, new FileAttribute[0]).toFile());
        }
        catch (IOException e) {
            throw new CTFIOException("Output file can't be created: " + outFilePath, e);
        }
        this.fStreamPacketOutputWriter = new CTFStreamPacketOutputWriter(streamInput);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyPackets(long startTime, long endTime) throws CTFException {
        CTFStreamInput streamInput = this.fStreamInput;
        if (streamInput == null) {
            throw new CTFIOException("StreamInput is null. Can't copy packets");
        }
        try {
            Throwable throwable = null;
            Object var7_7 = null;
            try {
                FileChannel fc = Objects.requireNonNull(FileChannel.open(this.fOutFile.toPath(), StandardOpenOption.WRITE));
                try {
                    try (FileChannel source = FileChannel.open(streamInput.getFile().toPath(), StandardOpenOption.READ);){
                        boolean deleteResult;
                        StreamInputPacketIndex index = streamInput.getIndex();
                        int count = 0;
                        long initialLost = 0L;
                        int i = 0;
                        while (i < index.size()) {
                            ICTFPacketDescriptor entry = index.getElement(i);
                            long packetStart = entry.getTimestampBegin();
                            long packetEnd = entry.getTimestampEnd();
                            if (count == 0) {
                                initialLost = (Long)entry.getAttributes().getOrDefault("events_discarded", 0L);
                            }
                            if (startTime <= packetStart && endTime >= packetEnd) {
                                this.fStreamPacketOutputWriter.writePacket(entry, fc, initialLost);
                                ++count;
                            } else if (startTime <= packetEnd && endTime >= packetStart) {
                                this.fStreamPacketOutputWriter.writePacket(entry, startTime, endTime, initialLost, fc);
                                ++count;
                            } else if (entry.getTimestampBegin() > endTime) break;
                            ++i;
                        }
                        if ((count == 0 && this.fOutFile.exists() || this.fOutFile.length() == 0L) && !(deleteResult = this.fOutFile.delete())) {
                            throw new CTFIOException("Could not delete " + this.fOutFile.getAbsolutePath());
                        }
                    }
                    if (fc == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fc == null) throw throwable;
                    fc.close();
                    throw throwable;
                }
                fc.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CTFIOException("Error copying packets: " + e.toString(), e);
        }
    }

    public File getOutFile() {
        return this.fOutFile;
    }
}

