/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.model.impl;

import org.eclipse.tracecompass.internal.lttng2.control.core.model.ILoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceJulLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLog4jLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.LoggerInfo;
import org.eclipse.tracecompass.lttng2.control.core.tests.model.impl.ModelImplFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggerInfoTest {
    private ILoggerInfo fLoggerInfo1 = null;
    private ILoggerInfo fLoggerInfo2 = null;

    @Before
    public void setUp() {
        ModelImplFactory factory = new ModelImplFactory();
        this.fLoggerInfo1 = factory.getLoggerInfo1();
        this.fLoggerInfo2 = factory.getLoggerInfo2();
    }

    @Test
    public void testLoggerInfo() {
        LoggerInfo fixture = new LoggerInfo("logger");
        Assert.assertNotNull((Object)fixture);
        String name = fixture.getName();
        Assert.assertEquals((Object)"logger", (Object)name);
        TraceDomainType result = fixture.getDomain();
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.toString());
        Assert.assertEquals((long)5L, (long)result.ordinal());
        TraceEnablement state = fixture.getState();
        Assert.assertEquals((Object)"disabled", (Object)state.getInName());
        Assert.assertEquals((Object)"DISABLED", (Object)state.name());
        Assert.assertEquals((Object)"DISABLED", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        LogLevelType logType = fixture.getLogLevelType();
        Assert.assertEquals((Object)"All", (Object)logType.getShortName());
        Assert.assertEquals((Object)"LOGLEVEL_ALL", (Object)logType.name());
        Assert.assertEquals((Object)"LOGLEVEL_ALL", (Object)logType.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        TraceJulLogLevel logLevel = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)logLevel.getInName());
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)logLevel.name());
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)logLevel.toString());
        Assert.assertEquals((long)9L, (long)logLevel.ordinal());
    }

    @Test
    public void testLoggerInfoCopy() {
        LoggerInfo info = new LoggerInfo((LoggerInfo)this.fLoggerInfo1);
        Assert.assertEquals((Object)this.fLoggerInfo1.getName(), (Object)info.getName());
        Assert.assertEquals((Object)this.fLoggerInfo1.getState(), (Object)info.getState());
        Assert.assertEquals((Object)this.fLoggerInfo1.getLogLevelType(), (Object)info.getLogLevelType());
        Assert.assertEquals((Object)this.fLoggerInfo1.getLogLevel(), (Object)info.getLogLevel());
        Assert.assertEquals((Object)this.fLoggerInfo1.getDomain(), (Object)info.getDomain());
    }

    @Test
    public void testEventCopy2() {
        try {
            LoggerInfo info = null;
            new LoggerInfo(info);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testGetAndSetter() {
        LoggerInfo fixture = new LoggerInfo("logger");
        fixture.setState("disabled");
        TraceEnablement state = fixture.getState();
        Assert.assertEquals((Object)"disabled", (Object)state.getInName());
        Assert.assertEquals((Object)"DISABLED", (Object)state.name());
        Assert.assertEquals((Object)"DISABLED", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        fixture.setState("true");
        state = fixture.getState();
        Assert.assertEquals((Object)"true", (Object)state.getInMiName());
        Assert.assertEquals((Object)"ENABLED", (Object)state.name());
        Assert.assertEquals((Object)"ENABLED", (Object)state.toString());
        Assert.assertEquals((long)1L, (long)state.ordinal());
        fixture.setState("false");
        state = fixture.getState();
        Assert.assertEquals((Object)"false", (Object)state.getInMiName());
        Assert.assertEquals((Object)"DISABLED", (Object)state.name());
        Assert.assertEquals((Object)"DISABLED", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        fixture.setState("enabled");
        state = fixture.getState();
        Assert.assertEquals((Object)"enabled", (Object)state.getInName());
        Assert.assertEquals((Object)"ENABLED", (Object)state.name());
        Assert.assertEquals((Object)"ENABLED", (Object)state.toString());
        Assert.assertEquals((long)1L, (long)state.ordinal());
        fixture.setState("bla");
        state = fixture.getState();
        Assert.assertEquals((Object)"disabled", (Object)state.getInName());
        Assert.assertEquals((Object)"DISABLED", (Object)state.name());
        Assert.assertEquals((Object)"DISABLED", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        fixture.setState(TraceEnablement.ENABLED);
        state = fixture.getState();
        Assert.assertEquals((Object)"enabled", (Object)state.getInName());
        Assert.assertEquals((Object)"ENABLED", (Object)state.name());
        Assert.assertEquals((Object)"ENABLED", (Object)state.toString());
        Assert.assertEquals((long)1L, (long)state.ordinal());
        fixture.setState(TraceEnablement.DISABLED);
        state = fixture.getState();
        Assert.assertEquals((Object)"disabled", (Object)state.getInName());
        Assert.assertEquals((Object)"DISABLED", (Object)state.name());
        Assert.assertEquals((Object)"DISABLED", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        fixture.setLogLevelType("==");
        Assert.assertEquals((Object)"LOGLEVEL_ONLY", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"==", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType("<=");
        Assert.assertEquals((Object)"LOGLEVEL", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"<=", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType("All");
        Assert.assertEquals((Object)"LOGLEVEL_ALL", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"All", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType(LogLevelType.LOGLEVEL_ONLY);
        Assert.assertEquals((Object)"LOGLEVEL_ONLY", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"==", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType(LogLevelType.LOGLEVEL);
        Assert.assertEquals((Object)"LOGLEVEL", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"<=", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType(LogLevelType.LOGLEVEL_ALL);
        Assert.assertEquals((Object)"LOGLEVEL_ALL", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"All", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType(LogLevelType.LOGLEVEL_NONE);
        Assert.assertEquals((Object)"LOGLEVEL_NONE", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType("SINGLE");
        Assert.assertEquals((Object)"LOGLEVEL_ONLY", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"SINGLE", (Object)fixture.getLogLevelType().getMiName());
        fixture.setLogLevelType("RANGE");
        Assert.assertEquals((Object)"LOGLEVEL", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"RANGE", (Object)fixture.getLogLevelType().getMiName());
        fixture.setLogLevelType("ALL");
        Assert.assertEquals((Object)"LOGLEVEL_ALL", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"ALL", (Object)fixture.getLogLevelType().getMiName());
        fixture.setLogLevelType("UNKNOWN");
        Assert.assertEquals((Object)"LOGLEVEL_NONE", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)fixture.getLogLevelType().getMiName());
    }

    @Test
    public void testToString() {
        LoggerInfo fixture = new LoggerInfo("logger");
        fixture.setName("testName");
        String result = fixture.toString();
        Assert.assertEquals((Object)"[LoggerInfo([BaseLoggerInfo([TraceInfo(Name=testName)],domain=UNKNOWN,level=LEVEL_UNKNOWN)],State=DISABLED,levelType=LOGLEVEL_ALL)]", (Object)result);
        fixture.setDomain(TraceDomainType.JUL);
        result = fixture.toString();
        Assert.assertEquals((Object)"[LoggerInfo([BaseLoggerInfo([TraceInfo(Name=testName)],domain=JUL,level=LEVEL_UNKNOWN)],State=DISABLED,levelType=LOGLEVEL_ALL)]", (Object)result);
        fixture.setLogLevel((ITraceLogLevel)TraceJulLogLevel.JUL_FINE);
        result = fixture.toString();
        Assert.assertEquals((Object)"[LoggerInfo([BaseLoggerInfo([TraceInfo(Name=testName)],domain=JUL,level=JUL_FINE)],State=DISABLED,levelType=LOGLEVEL_ALL)]", (Object)result);
        fixture.setState(TraceEnablement.ENABLED);
        result = fixture.toString();
        Assert.assertEquals((Object)"[LoggerInfo([BaseLoggerInfo([TraceInfo(Name=testName)],domain=JUL,level=JUL_FINE)],State=ENABLED,levelType=LOGLEVEL_ALL)]", (Object)result);
        fixture.setDomain(TraceDomainType.LOG4J);
        result = fixture.toString();
        Assert.assertEquals((Object)"[LoggerInfo([BaseLoggerInfo([TraceInfo(Name=testName)],domain=LOG4J,level=JUL_FINE)],State=ENABLED,levelType=LOGLEVEL_ALL)]", (Object)result);
        fixture.setLogLevel((ITraceLogLevel)TraceLog4jLogLevel.LOG4J_FATAL);
        result = fixture.toString();
        Assert.assertEquals((Object)"[LoggerInfo([BaseLoggerInfo([TraceInfo(Name=testName)],domain=LOG4J,level=LOG4J_FATAL)],State=ENABLED,levelType=LOGLEVEL_ALL)]", (Object)result);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fLoggerInfo1.equals(this.fLoggerInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fLoggerInfo2.equals(this.fLoggerInfo2));
        Assert.assertTrue((String)"equals", (!this.fLoggerInfo1.equals(this.fLoggerInfo2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fLoggerInfo2.equals(this.fLoggerInfo1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        LoggerInfo info1 = new LoggerInfo((LoggerInfo)this.fLoggerInfo1);
        LoggerInfo info2 = new LoggerInfo((LoggerInfo)this.fLoggerInfo2);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)this.fLoggerInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fLoggerInfo1.equals(info1));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)this.fLoggerInfo2));
        Assert.assertTrue((String)"equals", (boolean)this.fLoggerInfo2.equals(info2));
    }

    @Test
    public void testEqualsTransivity() {
        LoggerInfo info1 = new LoggerInfo((LoggerInfo)this.fLoggerInfo1);
        LoggerInfo info2 = new LoggerInfo((LoggerInfo)this.fLoggerInfo1);
        LoggerInfo info3 = new LoggerInfo((LoggerInfo)this.fLoggerInfo1);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info2));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)info3));
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fLoggerInfo1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fLoggerInfo2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        LoggerInfo info1 = new LoggerInfo((LoggerInfo)this.fLoggerInfo1);
        LoggerInfo info2 = new LoggerInfo((LoggerInfo)this.fLoggerInfo2);
        Assert.assertTrue((String)"hashCode", (this.fLoggerInfo1.hashCode() == info1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fLoggerInfo2.hashCode() == info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fLoggerInfo1.hashCode() != info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fLoggerInfo2.hashCode() != info1.hashCode() ? 1 : 0) != 0);
    }
}

