/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.component;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.tracecompass.internal.tmf.core.request.TmfCoalescedEventRequest;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartSynchSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfExperimentStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TmfEventProviderCoalescingTest {
    private static final int TRACE1_NB_EVENT = 10000;
    private static final int TRACE2_NB_EVENT = 702;
    private static final int TRACE3_NB_EVENT = 10000;
    private static TmfTraceStub fTmfTrace1;
    private static TmfTraceStub fTmfTrace2;
    private static TmfTraceStub fTmfTrace3;
    private static TmfExperimentStub fExperiment;
    private static TmfExperimentStub fExperiment2;

    @BeforeClass
    public static void setUp() throws Exception {
        fTmfTrace1 = (TmfTraceStub)TmfTestTrace.A_TEST_10K.getTrace();
        fTmfTrace2 = (TmfTraceStub)TmfTestTrace.A_TEST_10K2.getTrace();
        fTmfTrace3 = (TmfTraceStub)TmfTestTrace.E_TEST_10K.getTrace();
        ITmfTrace[] traces2 = new ITmfTrace[]{fTmfTrace3};
        fExperiment2 = new TmfExperimentStub("", traces2, 100);
        ITmfTrace[] traces = new ITmfTrace[]{fTmfTrace1, fTmfTrace2, fExperiment2};
        fExperiment = new TmfExperimentStub("", traces, 100);
        fExperiment.indexTrace(true);
        TmfEventProviderCoalescingTest.setTimerFlags(false);
    }

    @AfterClass
    public static void tearDown() {
        fExperiment.dispose();
    }

    @After
    public void testCleanUp() throws Exception {
        TmfEventProviderCoalescingTest.clearPendingRequests();
    }

    @Test
    public void testParentFirstCoalescing() throws Exception {
        InnerEventRequest expReq = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace1Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace2Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        fExperiment.sendRequest((ITmfEventRequest)expReq);
        fTmfTrace1.sendRequest((ITmfEventRequest)trace1Req);
        fTmfTrace2.sendRequest((ITmfEventRequest)trace2Req);
        List<TmfCoalescedEventRequest> pending = fExperiment.getAllPendingRequests();
        Assert.assertEquals((long)1L, (long)pending.size());
        Assert.assertEquals((long)0L, (long)fTmfTrace1.getAllPendingRequests().size());
        Assert.assertEquals((long)0L, (long)fTmfTrace2.getAllPendingRequests().size());
        String expectedIds = "[" + expReq.getRequestId() + ", " + trace1Req.getRequestId() + ", " + trace2Req.getRequestId() + "]";
        TmfCoalescedEventRequest coalescedRequest = pending.get(0);
        Assert.assertEquals((Object)expectedIds, (Object)coalescedRequest.getSubRequestIds());
    }

    @Test
    public void testChildrenFirstCoalescing() throws Exception {
        InnerEventRequest expReq = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace1Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace2Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        fTmfTrace1.sendRequest((ITmfEventRequest)trace1Req);
        fTmfTrace2.sendRequest((ITmfEventRequest)trace2Req);
        fExperiment.sendRequest((ITmfEventRequest)expReq);
        List<TmfCoalescedEventRequest> pending = fExperiment.getAllPendingRequests();
        Assert.assertEquals((long)1L, (long)pending.size());
        Assert.assertEquals((long)0L, (long)fTmfTrace1.getAllPendingRequests().size());
        Assert.assertEquals((long)0L, (long)fTmfTrace2.getAllPendingRequests().size());
        fExperiment.notifyPendingRequest(false);
        try {
            expReq.waitForCompletion();
        }
        catch (InterruptedException interruptedException) {}
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertFalse((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertFalse((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace2));
    }

    @Test
    public void testChildrenFirstCoalescing2() throws Exception {
        InnerEventRequest expReq = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest exp2Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace1Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace2Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace3Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        fTmfTrace1.sendRequest((ITmfEventRequest)trace1Req);
        fTmfTrace2.sendRequest((ITmfEventRequest)trace2Req);
        fTmfTrace3.sendRequest((ITmfEventRequest)trace3Req);
        fExperiment2.sendRequest((ITmfEventRequest)exp2Req);
        fExperiment.sendRequest((ITmfEventRequest)expReq);
        List<TmfCoalescedEventRequest> pending = fExperiment.getAllPendingRequests();
        Assert.assertEquals((long)1L, (long)pending.size());
        Assert.assertEquals((long)0L, (long)fTmfTrace1.getAllPendingRequests().size());
        Assert.assertEquals((long)0L, (long)fTmfTrace2.getAllPendingRequests().size());
        fExperiment.notifyPendingRequest(false);
        try {
            expReq.waitForCompletion();
        }
        catch (InterruptedException interruptedException) {}
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertFalse((boolean)exp2Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertFalse((boolean)exp2Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)exp2Req.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertTrue((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertFalse((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertFalse((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertFalse((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertFalse((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertFalse((boolean)trace3Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertFalse((boolean)trace3Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)trace3Req.isTraceHandled((ITmfTrace)fTmfTrace3));
    }

    @Test
    public void testMixedOrderCoalescing() throws Exception {
        InnerEventRequest expReq = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace1Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace2Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        fTmfTrace1.sendRequest((ITmfEventRequest)trace1Req);
        fExperiment.sendRequest((ITmfEventRequest)expReq);
        fTmfTrace2.sendRequest((ITmfEventRequest)trace2Req);
        List<TmfCoalescedEventRequest> pending = fExperiment.getAllPendingRequests();
        Assert.assertEquals((long)1L, (long)pending.size());
        Assert.assertEquals((long)0L, (long)fTmfTrace1.getAllPendingRequests().size());
        Assert.assertEquals((long)0L, (long)fTmfTrace2.getAllPendingRequests().size());
        fExperiment.notifyPendingRequest(false);
        try {
            expReq.waitForCompletion();
        }
        catch (InterruptedException interruptedException) {}
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertFalse((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertFalse((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace2));
    }

    @Test
    public void testMixedCoalescing2() throws Exception {
        InnerEventRequest expReq = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest exp2Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace1Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace2Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace3Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        fExperiment2.sendRequest((ITmfEventRequest)exp2Req);
        fExperiment.sendRequest((ITmfEventRequest)expReq);
        fTmfTrace1.sendRequest((ITmfEventRequest)trace1Req);
        fTmfTrace2.sendRequest((ITmfEventRequest)trace2Req);
        fTmfTrace3.sendRequest((ITmfEventRequest)trace3Req);
        List<TmfCoalescedEventRequest> pending = fExperiment.getAllPendingRequests();
        Assert.assertEquals((long)1L, (long)pending.size());
        Assert.assertEquals((long)0L, (long)fTmfTrace1.getAllPendingRequests().size());
        Assert.assertEquals((long)0L, (long)fTmfTrace2.getAllPendingRequests().size());
        Assert.assertEquals((long)0L, (long)fTmfTrace3.getAllPendingRequests().size());
        fExperiment.notifyPendingRequest(false);
        try {
            expReq.waitForCompletion();
        }
        catch (InterruptedException interruptedException) {}
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertFalse((boolean)exp2Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertFalse((boolean)exp2Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)exp2Req.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertTrue((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertFalse((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertFalse((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertFalse((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertFalse((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertFalse((boolean)trace3Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertFalse((boolean)trace3Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)trace3Req.isTraceHandled((ITmfTrace)fTmfTrace3));
    }

    @Test
    public void testMultipleRequestsCoalescing() throws Exception {
        InnerEventRequest expReq = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
        InnerEventRequest expReq2 = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
        InnerEventRequest trace1Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
        InnerEventRequest trace1Req2 = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
        InnerEventRequest trace2Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
        TmfEventProviderCoalescingTest.sendSync(true);
        fTmfTrace1.sendRequest((ITmfEventRequest)trace1Req);
        fTmfTrace1.sendRequest((ITmfEventRequest)trace1Req2);
        fExperiment.sendRequest((ITmfEventRequest)expReq);
        fTmfTrace2.sendRequest((ITmfEventRequest)trace2Req);
        fExperiment.sendRequest((ITmfEventRequest)expReq2);
        List<TmfCoalescedEventRequest> pending = fExperiment.getAllPendingRequests();
        Assert.assertEquals((long)1L, (long)pending.size());
        Assert.assertEquals((long)0L, (long)fTmfTrace1.getAllPendingRequests().size());
        Assert.assertEquals((long)0L, (long)fTmfTrace2.getAllPendingRequests().size());
        Assert.assertEquals((long)0L, (long)fTmfTrace3.getAllPendingRequests().size());
        Assert.assertEquals((long)0L, (long)fExperiment2.getAllPendingRequests().size());
        TmfEventProviderCoalescingTest.sendSync(false);
        try {
            expReq.waitForCompletion();
        }
        catch (InterruptedException interruptedException) {}
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertTrue((boolean)expReq2.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)expReq2.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)expReq2.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertTrue((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertFalse((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertFalse((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertFalse((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertFalse((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace3));
    }

    @Test
    public void testTraceDependencyBackground() throws Exception {
        InnerEventRequest traceReqLevel0 = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest traceReq2Level0 = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest traceReqLevel1 = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND, 1);
        InnerEventRequest traceReq2Level1 = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND, 1);
        fTmfTrace1.sendRequest((ITmfEventRequest)traceReqLevel0);
        fTmfTrace1.sendRequest((ITmfEventRequest)traceReq2Level0);
        fTmfTrace1.sendRequest((ITmfEventRequest)traceReqLevel1);
        fTmfTrace1.sendRequest((ITmfEventRequest)traceReq2Level1);
        List<TmfCoalescedEventRequest> pending = fTmfTrace1.getAllPendingRequests();
        Assert.assertEquals((long)2L, (long)pending.size());
        fTmfTrace1.notifyPendingRequest(false);
        String expectedIds = "[" + traceReqLevel0.getRequestId() + ", " + traceReq2Level0.getRequestId() + "]";
        TmfCoalescedEventRequest coalescedRequest = pending.get(0);
        Assert.assertEquals((Object)expectedIds, (Object)coalescedRequest.getSubRequestIds());
        expectedIds = "[" + traceReqLevel1.getRequestId() + ", " + traceReq2Level1.getRequestId() + "]";
        coalescedRequest = pending.get(1);
        Assert.assertEquals((Object)expectedIds, (Object)coalescedRequest.getSubRequestIds());
        traceReqLevel0.waitForCompletion();
        traceReq2Level0.waitForCompletion();
        traceReqLevel1.waitForCompletion();
        traceReq2Level1.waitForCompletion();
        Assert.assertEquals((long)10000L, (long)traceReqLevel0.getNbRead());
        Assert.assertEquals((long)10000L, (long)traceReq2Level0.getNbRead());
        Assert.assertEquals((long)10000L, (long)traceReqLevel1.getNbRead());
        Assert.assertEquals((long)10000L, (long)traceReq2Level1.getNbRead());
    }

    @Test
    public void testTraceDependencyForeground() throws Exception {
        InnerEventRequest traceReqLevel0 = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
        InnerEventRequest traceReq2Level0 = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
        InnerEventRequest traceReqLevel1 = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND, 1);
        InnerEventRequest traceReq2Level1 = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND, 1);
        TmfEventProviderCoalescingTest.sendSync(true);
        fTmfTrace1.sendRequest((ITmfEventRequest)traceReqLevel0);
        fTmfTrace1.sendRequest((ITmfEventRequest)traceReq2Level0);
        fTmfTrace1.sendRequest((ITmfEventRequest)traceReqLevel1);
        fTmfTrace1.sendRequest((ITmfEventRequest)traceReq2Level1);
        List<TmfCoalescedEventRequest> pending = fTmfTrace1.getAllPendingRequests();
        Assert.assertEquals((long)2L, (long)pending.size());
        TmfEventProviderCoalescingTest.sendSync(false);
        String expectedIds = "[" + traceReqLevel0.getRequestId() + ", " + traceReq2Level0.getRequestId() + "]";
        TmfCoalescedEventRequest coalescedRequest = pending.get(0);
        Assert.assertEquals((Object)expectedIds, (Object)coalescedRequest.getSubRequestIds());
        expectedIds = "[" + traceReqLevel1.getRequestId() + ", " + traceReq2Level1.getRequestId() + "]";
        coalescedRequest = pending.get(1);
        Assert.assertEquals((Object)expectedIds, (Object)coalescedRequest.getSubRequestIds());
        traceReqLevel0.waitForCompletion();
        traceReq2Level0.waitForCompletion();
        traceReqLevel1.waitForCompletion();
        traceReq2Level1.waitForCompletion();
        Assert.assertEquals((long)10000L, (long)traceReqLevel0.getNbRead());
        Assert.assertEquals((long)10000L, (long)traceReq2Level0.getNbRead());
        Assert.assertEquals((long)10000L, (long)traceReqLevel1.getNbRead());
        Assert.assertEquals((long)10000L, (long)traceReq2Level1.getNbRead());
    }

    @Test
    public void testParentDependencyBackground() throws Exception {
        InnerEventRequest expReq = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest expReq2 = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND, 1);
        InnerEventRequest trace1Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace2Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND, 1);
        fExperiment.sendRequest((ITmfEventRequest)expReq);
        fTmfTrace1.sendRequest((ITmfEventRequest)trace1Req);
        fExperiment.sendRequest((ITmfEventRequest)expReq2);
        fTmfTrace2.sendRequest((ITmfEventRequest)trace2Req);
        List<TmfCoalescedEventRequest> pending = fExperiment.getAllPendingRequests();
        Assert.assertEquals((long)2L, (long)pending.size());
        Assert.assertEquals((long)0L, (long)fTmfTrace1.getAllPendingRequests().size());
        Assert.assertEquals((long)0L, (long)fTmfTrace2.getAllPendingRequests().size());
        fExperiment.notifyPendingRequest(false);
        String expectedIds = "[" + expReq.getRequestId() + ", " + trace1Req.getRequestId() + "]";
        TmfCoalescedEventRequest coalescedRequest = pending.get(0);
        Assert.assertEquals((Object)expectedIds, (Object)coalescedRequest.getSubRequestIds());
        expectedIds = "[" + expReq2.getRequestId() + ", " + trace2Req.getRequestId() + "]";
        coalescedRequest = pending.get(1);
        Assert.assertEquals((Object)expectedIds, (Object)coalescedRequest.getSubRequestIds());
        expReq.waitForCompletion();
        expReq2.waitForCompletion();
        trace1Req.waitForCompletion();
        trace2Req.waitForCompletion();
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertTrue((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertFalse((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertFalse((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertTrue((boolean)expReq2.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)expReq2.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)expReq2.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertFalse((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertFalse((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertEquals((long)20702L, (long)expReq.getNbRead());
        Assert.assertEquals((long)10000L, (long)trace1Req.getNbRead());
        Assert.assertEquals((long)702L, (long)trace2Req.getNbRead());
    }

    @Test
    public void testChildFirstDependencyBackground() throws Exception {
        InnerEventRequest expReq = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest expReq2 = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND, 1);
        InnerEventRequest trace1Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
        InnerEventRequest trace2Req = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND, 1);
        fTmfTrace1.sendRequest((ITmfEventRequest)trace1Req);
        fExperiment.sendRequest((ITmfEventRequest)expReq);
        fTmfTrace2.sendRequest((ITmfEventRequest)trace2Req);
        fExperiment.sendRequest((ITmfEventRequest)expReq2);
        List<TmfCoalescedEventRequest> pending = fExperiment.getAllPendingRequests();
        Assert.assertEquals((long)2L, (long)pending.size());
        Assert.assertEquals((long)0L, (long)fTmfTrace1.getAllPendingRequests().size());
        Assert.assertEquals((long)0L, (long)fTmfTrace2.getAllPendingRequests().size());
        fExperiment.notifyPendingRequest(false);
        fTmfTrace1.notifyPendingRequest(false);
        fTmfTrace2.notifyPendingRequest(false);
        String expectedIds = "[" + expReq.getRequestId() + ", " + trace1Req.getRequestId() + "]";
        TmfCoalescedEventRequest coalescedRequest = pending.get(0);
        Assert.assertEquals((Object)expectedIds, (Object)coalescedRequest.getSubRequestIds());
        expectedIds = "[" + expReq2.getRequestId() + ", " + trace2Req.getRequestId() + "]";
        coalescedRequest = pending.get(1);
        Assert.assertEquals((Object)expectedIds, (Object)coalescedRequest.getSubRequestIds());
        expReq.waitForCompletion();
        expReq2.waitForCompletion();
        trace1Req.waitForCompletion();
        trace2Req.waitForCompletion();
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)expReq.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertTrue((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertFalse((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertFalse((boolean)trace1Req.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertTrue((boolean)expReq2.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)expReq2.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertTrue((boolean)expReq2.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertFalse((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace1));
        Assert.assertTrue((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace2));
        Assert.assertFalse((boolean)trace2Req.isTraceHandled((ITmfTrace)fTmfTrace3));
        Assert.assertEquals((long)20702L, (long)expReq.getNbRead());
        Assert.assertEquals((long)10000L, (long)trace1Req.getNbRead());
        Assert.assertEquals((long)702L, (long)trace2Req.getNbRead());
    }

    private static void sendSync(boolean isStart) {
        if (isStart) {
            TmfStartSynchSignal signal = new TmfStartSynchSignal(0);
            fTmfTrace1.startSynch(signal);
            fTmfTrace1.startSynch(signal);
            fExperiment.startSynch(signal);
            fTmfTrace2.startSynch(signal);
            fExperiment.startSynch(signal);
        } else {
            TmfEndSynchSignal signal = new TmfEndSynchSignal(0);
            fTmfTrace1.endSynch(signal);
            fTmfTrace1.endSynch(signal);
            fExperiment.endSynch(signal);
            fTmfTrace2.endSynch(signal);
            fExperiment.endSynch(signal);
        }
    }

    private static void setTimerFlags(boolean flag) throws Exception {
        fExperiment.setTimerEnabledFlag(flag);
        fExperiment2.setTimerEnabledFlag(flag);
        fTmfTrace1.setTimerEnabledFlag(flag);
        fTmfTrace2.setTimerEnabledFlag(flag);
        fTmfTrace3.setTimerEnabledFlag(flag);
    }

    private static void clearPendingRequests() throws Exception {
        fExperiment.clearAllPendingRequests();
        fExperiment2.clearAllPendingRequests();
        fTmfTrace1.clearAllPendingRequests();
        fTmfTrace2.clearAllPendingRequests();
        fTmfTrace3.clearAllPendingRequests();
    }

    private static class InnerEventRequest
    extends TmfEventRequest {
        private Set<String> traces = new HashSet<String>();

        public InnerEventRequest(Class<? extends ITmfEvent> dataType, long index, int nbRequested, ITmfEventRequest.ExecutionType priority) {
            super(dataType, index, nbRequested, priority);
        }

        public InnerEventRequest(Class<? extends ITmfEvent> dataType, long index, int nbRequested, ITmfEventRequest.ExecutionType priority, int dependency) {
            super(dataType, TmfTimeRange.ETERNITY, index, nbRequested, priority, dependency);
        }

        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (!this.traces.contains(event.getTrace().getName())) {
                this.traces.add(event.getTrace().getName());
            }
        }

        public boolean isTraceHandled(ITmfTrace trace) {
            return this.traces.contains(trace.getName());
        }
    }
}

